<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'yyyy. M. d.',
            'time' => 'a h:mm',
            'datetime' => 'yyyy. M. d. a h:mm',
        ],
        'medium' => [
            'date' => 'y. M. d.',
            'time' => 'a h:mm:ss',
            'datetime' => 'y. M. d. a h:mm:ss',
        ],
        'long' => [
            'date' => 'y년 M월 d일',
            'time' => 'a h시 m분 s초 z',
            'datetime' => 'y년 M월 d일 a h시 m분 s초 z',
        ],
        'full' => [
            'date' => 'y년 M월 d일 EEEE',
            'time' => 'a h시 m분 s초 zzzz',
            'datetime' => 'y년 M월 d일 EEEE a h시 m분 s초 zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤#,##0.00',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => '오전',
    'pmName' => '오후',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '.',
        'groupingSeparator' => ',',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => '.',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ',',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JP¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => 'THB ',
        'TWD' => 'NT$',
        'USD' => 'US$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월',
        ],
        'medium' => [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월',
        ],
        'full' => [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월',
        ],
        'medium' => [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월',
        ],
        'full' => [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            '일',
            '월',
            '화',
            '수',
            '목',
            '금',
            '토',
        ],
        'short' => [
            '일',
            '월',
            '화',
            '수',
            '목',
            '금',
            '토',
        ],
        'medium' => [
            '일',
            '월',
            '화',
            '수',
            '목',
            '금',
            '토',
        ],
        'full' => [
            '일요일',
            '월요일',
            '화요일',
            '수요일',
            '목요일',
            '금요일',
            '토요일',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            '일',
            '월',
            '화',
            '수',
            '목',
            '금',
            '토',
        ],
        'short' => [
            '일',
            '월',
            '화',
            '수',
            '목',
            '금',
            '토',
        ],
        'medium' => [
            '일',
            '월',
            '화',
            '수',
            '목',
            '금',
            '토',
        ],
        'full' => [
            '일요일',
            '월요일',
            '화요일',
            '수요일',
            '목요일',
            '금요일',
            '토요일',
        ],
    ],
    'localeDisplayNames' => [
        'af' => '아프리칸스어',
        'af-NA' => '아프리칸스어(나미비아)',
        'af-ZA' => '아프리칸스어(남아프리카)',
        'agq' => '아그햄어',
        'agq-CM' => '아그햄어(카메룬)',
        'ak' => '아칸어',
        'ak-GH' => '아칸어(가나)',
        'am' => '암하라어',
        'am-ET' => '암하라어(에티오피아)',
        'ar' => '아랍어',
        'ar-001' => '아랍어(세계)',
        'ar-AE' => '아랍어(아랍에미리트)',
        'ar-BH' => '아랍어(바레인)',
        'ar-DJ' => '아랍어(지부티)',
        'ar-DZ' => '아랍어(알제리)',
        'ar-EG' => '아랍어(이집트)',
        'ar-EH' => '아랍어(서사하라)',
        'ar-ER' => '아랍어(에리트리아)',
        'ar-IL' => '아랍어(이스라엘)',
        'ar-IQ' => '아랍어(이라크)',
        'ar-JO' => '아랍어(요르단)',
        'ar-KM' => '아랍어(코모로)',
        'ar-KW' => '아랍어(쿠웨이트)',
        'ar-LB' => '아랍어(레바논)',
        'ar-LY' => '아랍어(리비아)',
        'ar-MA' => '아랍어(모로코)',
        'ar-MR' => '아랍어(모리타니)',
        'ar-OM' => '아랍어(오만)',
        'ar-PS' => '아랍어(팔레스타인 지구)',
        'ar-QA' => '아랍어(카타르)',
        'ar-SA' => '아랍어(사우디아라비아)',
        'ar-SD' => '아랍어(수단)',
        'ar-SO' => '아랍어(소말리아)',
        'ar-SS' => '아랍어(남수단)',
        'ar-SY' => '아랍어(시리아)',
        'ar-TD' => '아랍어(차드)',
        'ar-TN' => '아랍어(튀니지)',
        'ar-YE' => '아랍어(예멘)',
        'as' => '아삼어',
        'as-IN' => '아삼어(인도)',
        'asa' => '아수어',
        'asa-TZ' => '아수어(탄자니아)',
        'ast' => '아스투리아어',
        'ast-ES' => '아스투리아어(스페인)',
        'az' => '아제르바이잔어',
        'az-Cyrl' => '아제르바이잔어(키릴 문자)',
        'az-Cyrl-AZ' => '아제르바이잔어(키릴 문자, 아제르바이잔)',
        'az-Latn' => '아제르바이잔어(로마자)',
        'az-Latn-AZ' => '아제르바이잔어(로마자, 아제르바이잔)',
        'bas' => '바사어',
        'bas-CM' => '바사어(카메룬)',
        'be' => '벨라루스어',
        'be-BY' => '벨라루스어(벨라루스)',
        'bem' => '벰바어',
        'bem-ZM' => '벰바어(잠비아)',
        'bez' => '베나어',
        'bez-TZ' => '베나어(탄자니아)',
        'bg' => '불가리아어',
        'bg-BG' => '불가리아어(불가리아)',
        'bm' => '밤바라어',
        'bm-ML' => '밤바라어(말리)',
        'bn' => '벵골어',
        'bn-BD' => '벵골어(방글라데시)',
        'bn-IN' => '벵골어(인도)',
        'bo' => '티베트어',
        'bo-CN' => '티베트어(중국)',
        'bo-IN' => '티베트어(인도)',
        'br' => '브르타뉴어',
        'br-FR' => '브르타뉴어(프랑스)',
        'brx' => '보도어',
        'brx-IN' => '보도어(인도)',
        'bs' => '보스니아어',
        'bs-Cyrl' => '보스니아어(키릴 문자)',
        'bs-Cyrl-BA' => '보스니아어(키릴 문자, 보스니아 헤르체고비나)',
        'bs-Latn' => '보스니아어(로마자)',
        'bs-Latn-BA' => '보스니아어(로마자, 보스니아 헤르체고비나)',
        'ca' => '카탈로니아어',
        'ca-AD' => '카탈로니아어(안도라)',
        'ca-ES' => '카탈로니아어(스페인)',
        'ca-FR' => '카탈로니아어(프랑스)',
        'ca-IT' => '카탈로니아어(이탈리아)',
        'ccp' => '차크마어',
        'ccp-BD' => '차크마어(방글라데시)',
        'ccp-IN' => '차크마어(인도)',
        'ce' => '체첸어',
        'ce-RU' => '체첸어(러시아)',
        'ceb' => '세부아노어',
        'ceb-PH' => '세부아노어(필리핀)',
        'cgg' => '치가어',
        'cgg-UG' => '치가어(우간다)',
        'chr' => '체로키어',
        'chr-US' => '체로키어(미국)',
        'ckb' => '소라니 쿠르드어',
        'ckb-IQ' => '소라니 쿠르드어(이라크)',
        'ckb-IR' => '소라니 쿠르드어(이란)',
        'cs' => '체코어',
        'cs-CZ' => '체코어(체코)',
        'cy' => '웨일스어',
        'cy-GB' => '웨일스어(영국)',
        'da' => '덴마크어',
        'da-DK' => '덴마크어(덴마크)',
        'da-GL' => '덴마크어(그린란드)',
        'dav' => '타이타어',
        'dav-KE' => '타이타어(케냐)',
        'de' => '독일어',
        'de-AT' => '독일어(오스트리아)',
        'de-BE' => '독일어(벨기에)',
        'de-CH' => '독일어(스위스)',
        'de-DE' => '독일어(독일)',
        'de-IT' => '독일어(이탈리아)',
        'de-LI' => '독일어(리히텐슈타인)',
        'de-LU' => '독일어(룩셈부르크)',
        'dje' => '자르마어',
        'dje-NE' => '자르마어(니제르)',
        'dsb' => '저지 소르비아어',
        'dsb-DE' => '저지 소르비아어(독일)',
        'dua' => '두알라어',
        'dua-CM' => '두알라어(카메룬)',
        'dyo' => '졸라 포니어',
        'dyo-SN' => '졸라 포니어(세네갈)',
        'dz' => '종카어',
        'dz-BT' => '종카어(부탄)',
        'ebu' => '엠부어',
        'ebu-KE' => '엠부어(케냐)',
        'ee' => '에웨어',
        'ee-GH' => '에웨어(가나)',
        'ee-TG' => '에웨어(토고)',
        'el' => '그리스어',
        'el-CY' => '그리스어(키프로스)',
        'el-GR' => '그리스어(그리스)',
        'en' => '영어',
        'en-001' => '영어(세계)',
        'en-150' => '영어(유럽)',
        'en-AE' => '영어(아랍에미리트)',
        'en-AG' => '영어(앤티가 바부다)',
        'en-AI' => '영어(앵귈라)',
        'en-AS' => '영어(아메리칸 사모아)',
        'en-AT' => '영어(오스트리아)',
        'en-AU' => '영어(오스트레일리아)',
        'en-BB' => '영어(바베이도스)',
        'en-BE' => '영어(벨기에)',
        'en-BI' => '영어(부룬디)',
        'en-BM' => '영어(버뮤다)',
        'en-BS' => '영어(바하마)',
        'en-BW' => '영어(보츠와나)',
        'en-BZ' => '영어(벨리즈)',
        'en-CA' => '영어(캐나다)',
        'en-CC' => '영어(코코스 제도)',
        'en-CH' => '영어(스위스)',
        'en-CK' => '영어(쿡 제도)',
        'en-CM' => '영어(카메룬)',
        'en-CX' => '영어(크리스마스섬)',
        'en-CY' => '영어(키프로스)',
        'en-DE' => '영어(독일)',
        'en-DG' => '영어(디에고 가르시아)',
        'en-DK' => '영어(덴마크)',
        'en-DM' => '영어(도미니카)',
        'en-ER' => '영어(에리트리아)',
        'en-FI' => '영어(핀란드)',
        'en-FJ' => '영어(피지)',
        'en-FK' => '영어(포클랜드 제도)',
        'en-FM' => '영어(미크로네시아)',
        'en-GB' => '영어(영국)',
        'en-GD' => '영어(그레나다)',
        'en-GG' => '영어(건지)',
        'en-GH' => '영어(가나)',
        'en-GI' => '영어(지브롤터)',
        'en-GM' => '영어(감비아)',
        'en-GU' => '영어(괌)',
        'en-GY' => '영어(가이아나)',
        'en-HK' => '영어(홍콩[중국 특별행정구])',
        'en-IE' => '영어(아일랜드)',
        'en-IL' => '영어(이스라엘)',
        'en-IM' => '영어(맨 섬)',
        'en-IN' => '영어(인도)',
        'en-IO' => '영어(영국령 인도양 식민지)',
        'en-JE' => '영어(저지)',
        'en-JM' => '영어(자메이카)',
        'en-KE' => '영어(케냐)',
        'en-KI' => '영어(키리바시)',
        'en-KN' => '영어(세인트키츠 네비스)',
        'en-KY' => '영어(케이맨 제도)',
        'en-LC' => '영어(세인트루시아)',
        'en-LR' => '영어(라이베리아)',
        'en-LS' => '영어(레소토)',
        'en-MG' => '영어(마다가스카르)',
        'en-MH' => '영어(마셜 제도)',
        'en-MO' => '영어(마카오[중국 특별행정구])',
        'en-MP' => '영어(북마리아나제도)',
        'en-MS' => '영어(몬트세라트)',
        'en-MT' => '영어(몰타)',
        'en-MU' => '영어(모리셔스)',
        'en-MW' => '영어(말라위)',
        'en-MY' => '영어(말레이시아)',
        'en-NA' => '영어(나미비아)',
        'en-NF' => '영어(노퍽섬)',
        'en-NG' => '영어(나이지리아)',
        'en-NL' => '영어(네덜란드)',
        'en-NR' => '영어(나우루)',
        'en-NU' => '영어(니우에)',
        'en-NZ' => '영어(뉴질랜드)',
        'en-PG' => '영어(파푸아뉴기니)',
        'en-PH' => '영어(필리핀)',
        'en-PK' => '영어(파키스탄)',
        'en-PN' => '영어(핏케언 섬)',
        'en-PR' => '영어(푸에르토리코)',
        'en-PW' => '영어(팔라우)',
        'en-RW' => '영어(르완다)',
        'en-SB' => '영어(솔로몬 제도)',
        'en-SC' => '영어(세이셸)',
        'en-SD' => '영어(수단)',
        'en-SE' => '영어(스웨덴)',
        'en-SG' => '영어(싱가포르)',
        'en-SH' => '영어(세인트헬레나)',
        'en-SI' => '영어(슬로베니아)',
        'en-SL' => '영어(시에라리온)',
        'en-SS' => '영어(남수단)',
        'en-SX' => '영어(신트마르턴)',
        'en-SZ' => '영어(에스와티니)',
        'en-TC' => '영어(터크스 케이커스 제도)',
        'en-TK' => '영어(토켈라우)',
        'en-TO' => '영어(통가)',
        'en-TT' => '영어(트리니다드 토바고)',
        'en-TV' => '영어(투발루)',
        'en-TZ' => '영어(탄자니아)',
        'en-UG' => '영어(우간다)',
        'en-UM' => '영어(미국령 해외 제도)',
        'en-US' => '영어(미국)',
        'en-US-POSIX' => '영어(미국, Computer)',
        'en-VC' => '영어(세인트빈센트그레나딘)',
        'en-VG' => '영어(영국령 버진아일랜드)',
        'en-VI' => '영어(미국령 버진아일랜드)',
        'en-VU' => '영어(바누아투)',
        'en-WS' => '영어(사모아)',
        'en-ZA' => '영어(남아프리카)',
        'en-ZM' => '영어(잠비아)',
        'en-ZW' => '영어(짐바브웨)',
        'eo' => '에스페란토어',
        'eo-001' => '에스페란토어(세계)',
        'es' => '스페인어',
        'es-419' => '스페인어(라틴 아메리카)',
        'es-AR' => '스페인어(아르헨티나)',
        'es-BO' => '스페인어(볼리비아)',
        'es-BR' => '스페인어(브라질)',
        'es-BZ' => '스페인어(벨리즈)',
        'es-CL' => '스페인어(칠레)',
        'es-CO' => '스페인어(콜롬비아)',
        'es-CR' => '스페인어(코스타리카)',
        'es-CU' => '스페인어(쿠바)',
        'es-DO' => '스페인어(도미니카 공화국)',
        'es-EA' => '스페인어(세우타 및 멜리야)',
        'es-EC' => '스페인어(에콰도르)',
        'es-ES' => '스페인어(스페인)',
        'es-GQ' => '스페인어(적도 기니)',
        'es-GT' => '스페인어(과테말라)',
        'es-HN' => '스페인어(온두라스)',
        'es-IC' => '스페인어(카나리아 제도)',
        'es-MX' => '스페인어(멕시코)',
        'es-NI' => '스페인어(니카라과)',
        'es-PA' => '스페인어(파나마)',
        'es-PE' => '스페인어(페루)',
        'es-PH' => '스페인어(필리핀)',
        'es-PR' => '스페인어(푸에르토리코)',
        'es-PY' => '스페인어(파라과이)',
        'es-SV' => '스페인어(엘살바도르)',
        'es-US' => '스페인어(미국)',
        'es-UY' => '스페인어(우루과이)',
        'es-VE' => '스페인어(베네수엘라)',
        'et' => '에스토니아어',
        'et-EE' => '에스토니아어(에스토니아)',
        'eu' => '바스크어',
        'eu-ES' => '바스크어(스페인)',
        'ewo' => '이원도어',
        'ewo-CM' => '이원도어(카메룬)',
        'fa' => '페르시아어',
        'fa-AF' => '페르시아어(아프가니스탄)',
        'fa-IR' => '페르시아어(이란)',
        'ff' => '풀라어',
        'ff-Latn' => '풀라어(로마자)',
        'ff-Latn-BF' => '풀라어(로마자, 부르키나파소)',
        'ff-Latn-CM' => '풀라어(로마자, 카메룬)',
        'ff-Latn-GH' => '풀라어(로마자, 가나)',
        'ff-Latn-GM' => '풀라어(로마자, 감비아)',
        'ff-Latn-GN' => '풀라어(로마자, 기니)',
        'ff-Latn-GW' => '풀라어(로마자, 기니비사우)',
        'ff-Latn-LR' => '풀라어(로마자, 라이베리아)',
        'ff-Latn-MR' => '풀라어(로마자, 모리타니)',
        'ff-Latn-NE' => '풀라어(로마자, 니제르)',
        'ff-Latn-NG' => '풀라어(로마자, 나이지리아)',
        'ff-Latn-SL' => '풀라어(로마자, 시에라리온)',
        'ff-Latn-SN' => '풀라어(로마자, 세네갈)',
        'fi' => '핀란드어',
        'fi-FI' => '핀란드어(핀란드)',
        'fil' => '필리핀어',
        'fil-PH' => '필리핀어(필리핀)',
        'fo' => '페로어',
        'fo-DK' => '페로어(덴마크)',
        'fo-FO' => '페로어(페로 제도)',
        'fr' => '프랑스어',
        'fr-BE' => '프랑스어(벨기에)',
        'fr-BF' => '프랑스어(부르키나파소)',
        'fr-BI' => '프랑스어(부룬디)',
        'fr-BJ' => '프랑스어(베냉)',
        'fr-BL' => '프랑스어(생바르텔레미)',
        'fr-CA' => '프랑스어(캐나다)',
        'fr-CD' => '프랑스어(콩고-킨샤사)',
        'fr-CF' => '프랑스어(중앙 아프리카 공화국)',
        'fr-CG' => '프랑스어(콩고-브라자빌)',
        'fr-CH' => '프랑스어(스위스)',
        'fr-CI' => '프랑스어(코트디부아르)',
        'fr-CM' => '프랑스어(카메룬)',
        'fr-DJ' => '프랑스어(지부티)',
        'fr-DZ' => '프랑스어(알제리)',
        'fr-FR' => '프랑스어(프랑스)',
        'fr-GA' => '프랑스어(가봉)',
        'fr-GF' => '프랑스어(프랑스령 기아나)',
        'fr-GN' => '프랑스어(기니)',
        'fr-GP' => '프랑스어(과들루프)',
        'fr-GQ' => '프랑스어(적도 기니)',
        'fr-HT' => '프랑스어(아이티)',
        'fr-KM' => '프랑스어(코모로)',
        'fr-LU' => '프랑스어(룩셈부르크)',
        'fr-MA' => '프랑스어(모로코)',
        'fr-MC' => '프랑스어(모나코)',
        'fr-MF' => '프랑스어(생마르탱)',
        'fr-MG' => '프랑스어(마다가스카르)',
        'fr-ML' => '프랑스어(말리)',
        'fr-MQ' => '프랑스어(마르티니크)',
        'fr-MR' => '프랑스어(모리타니)',
        'fr-MU' => '프랑스어(모리셔스)',
        'fr-NC' => '프랑스어(뉴칼레도니아)',
        'fr-NE' => '프랑스어(니제르)',
        'fr-PF' => '프랑스어(프랑스령 폴리네시아)',
        'fr-PM' => '프랑스어(생피에르 미클롱)',
        'fr-RE' => '프랑스어(리유니온)',
        'fr-RW' => '프랑스어(르완다)',
        'fr-SC' => '프랑스어(세이셸)',
        'fr-SN' => '프랑스어(세네갈)',
        'fr-SY' => '프랑스어(시리아)',
        'fr-TD' => '프랑스어(차드)',
        'fr-TG' => '프랑스어(토고)',
        'fr-TN' => '프랑스어(튀니지)',
        'fr-VU' => '프랑스어(바누아투)',
        'fr-WF' => '프랑스어(왈리스-푸투나 제도)',
        'fr-YT' => '프랑스어(마요트)',
        'fur' => '프리울리어',
        'fur-IT' => '프리울리어(이탈리아)',
        'fy' => '서부 프리지아어',
        'fy-NL' => '서부 프리지아어(네덜란드)',
        'ga' => '아일랜드어',
        'ga-IE' => '아일랜드어(아일랜드)',
        'gd' => '스코틀랜드 게일어',
        'gd-GB' => '스코틀랜드 게일어(영국)',
        'gl' => '갈리시아어',
        'gl-ES' => '갈리시아어(스페인)',
        'gsw' => '독일어(스위스)',
        'gsw-CH' => '독일어(스위스)(스위스)',
        'gsw-FR' => '독일어(스위스)(프랑스)',
        'gsw-LI' => '독일어(스위스)(리히텐슈타인)',
        'gu' => '구자라트어',
        'gu-IN' => '구자라트어(인도)',
        'guz' => '구시어',
        'guz-KE' => '구시어(케냐)',
        'gv' => '맹크스어',
        'gv-IM' => '맹크스어(맨 섬)',
        'ha' => '하우사어',
        'ha-GH' => '하우사어(가나)',
        'ha-NE' => '하우사어(니제르)',
        'ha-NG' => '하우사어(나이지리아)',
        'haw' => '하와이어',
        'haw-US' => '하와이어(미국)',
        'he' => '히브리어',
        'he-IL' => '히브리어(이스라엘)',
        'hi' => '힌디어',
        'hi-IN' => '힌디어(인도)',
        'hr' => '크로아티아어',
        'hr-BA' => '크로아티아어(보스니아 헤르체고비나)',
        'hr-HR' => '크로아티아어(크로아티아)',
        'hsb' => '고지 소르비아어',
        'hsb-DE' => '고지 소르비아어(독일)',
        'hu' => '헝가리어',
        'hu-HU' => '헝가리어(헝가리)',
        'hy' => '아르메니아어',
        'hy-AM' => '아르메니아어(아르메니아)',
        'ia' => '인터링구아',
        'ia-001' => '인터링구아(세계)',
        'id' => '인도네시아어',
        'id-ID' => '인도네시아어(인도네시아)',
        'ig' => '이그보어',
        'ig-NG' => '이그보어(나이지리아)',
        'ii' => '쓰촨 이어',
        'ii-CN' => '쓰촨 이어(중국)',
        'is' => '아이슬란드어',
        'is-IS' => '아이슬란드어(아이슬란드)',
        'it' => '이탈리아어',
        'it-CH' => '이탈리아어(스위스)',
        'it-IT' => '이탈리아어(이탈리아)',
        'it-SM' => '이탈리아어(산마리노)',
        'it-VA' => '이탈리아어(바티칸 시국)',
        'ja' => '일본어',
        'ja-JP' => '일본어(일본)',
        'jgo' => '응곰바어',
        'jgo-CM' => '응곰바어(카메룬)',
        'jmc' => '마차메어',
        'jmc-TZ' => '마차메어(탄자니아)',
        'jv' => '자바어',
        'jv-ID' => '자바어(인도네시아)',
        'ka' => '조지아어',
        'ka-GE' => '조지아어(조지아)',
        'kab' => '커바일어',
        'kab-DZ' => '커바일어(알제리)',
        'kam' => '캄바어',
        'kam-KE' => '캄바어(케냐)',
        'kde' => '마콘데어',
        'kde-TZ' => '마콘데어(탄자니아)',
        'kea' => '크리올어',
        'kea-CV' => '크리올어(카보베르데)',
        'khq' => '코이라 친니어',
        'khq-ML' => '코이라 친니어(말리)',
        'ki' => '키쿠유어',
        'ki-KE' => '키쿠유어(케냐)',
        'kk' => '카자흐어',
        'kk-KZ' => '카자흐어(카자흐스탄)',
        'kkj' => '카코어',
        'kkj-CM' => '카코어(카메룬)',
        'kl' => '그린란드어',
        'kl-GL' => '그린란드어(그린란드)',
        'kln' => '칼렌진어',
        'kln-KE' => '칼렌진어(케냐)',
        'km' => '크메르어',
        'km-KH' => '크메르어(캄보디아)',
        'kn' => '칸나다어',
        'kn-IN' => '칸나다어(인도)',
        'ko' => '한국어',
        'ko-KP' => '한국어(북한)',
        'ko-KR' => '한국어(대한민국)',
        'kok' => '코카니어',
        'kok-IN' => '코카니어(인도)',
        'ks' => '카슈미르어',
        'ks-IN' => '카슈미르어(인도)',
        'ksb' => '샴발라어',
        'ksb-TZ' => '샴발라어(탄자니아)',
        'ksf' => '바피아어',
        'ksf-CM' => '바피아어(카메룬)',
        'ksh' => '콜로그니안어',
        'ksh-DE' => '콜로그니안어(독일)',
        'ku' => '쿠르드어',
        'ku-TR' => '쿠르드어(터키)',
        'kw' => '콘월어',
        'kw-GB' => '콘월어(영국)',
        'ky' => '키르기스어',
        'ky-KG' => '키르기스어(키르기스스탄)',
        'lag' => '랑기어',
        'lag-TZ' => '랑기어(탄자니아)',
        'lb' => '룩셈부르크어',
        'lb-LU' => '룩셈부르크어(룩셈부르크)',
        'lg' => '간다어',
        'lg-UG' => '간다어(우간다)',
        'lkt' => '라코타어',
        'lkt-US' => '라코타어(미국)',
        'ln' => '링갈라어',
        'ln-AO' => '링갈라어(앙골라)',
        'ln-CD' => '링갈라어(콩고-킨샤사)',
        'ln-CF' => '링갈라어(중앙 아프리카 공화국)',
        'ln-CG' => '링갈라어(콩고-브라자빌)',
        'lo' => '라오어',
        'lo-LA' => '라오어(라오스)',
        'lrc' => '북부 루리어',
        'lrc-IQ' => '북부 루리어(이라크)',
        'lrc-IR' => '북부 루리어(이란)',
        'lt' => '리투아니아어',
        'lt-LT' => '리투아니아어(리투아니아)',
        'lu' => '루바-카탄가어',
        'lu-CD' => '루바-카탄가어(콩고-킨샤사)',
        'luo' => '루오어',
        'luo-KE' => '루오어(케냐)',
        'luy' => '루야어',
        'luy-KE' => '루야어(케냐)',
        'lv' => '라트비아어',
        'lv-LV' => '라트비아어(라트비아)',
        'mas' => '마사이어',
        'mas-KE' => '마사이어(케냐)',
        'mas-TZ' => '마사이어(탄자니아)',
        'mer' => '메루어',
        'mer-KE' => '메루어(케냐)',
        'mfe' => '모리스얀어',
        'mfe-MU' => '모리스얀어(모리셔스)',
        'mg' => '말라가시어',
        'mg-MG' => '말라가시어(마다가스카르)',
        'mgh' => '마크후와-메토어',
        'mgh-MZ' => '마크후와-메토어(모잠비크)',
        'mgo' => '메타어',
        'mgo-CM' => '메타어(카메룬)',
        'mi' => '마오리어',
        'mi-NZ' => '마오리어(뉴질랜드)',
        'mk' => '마케도니아어',
        'mk-MK' => '마케도니아어(마케도니아)',
        'ml' => '말라얄람어',
        'ml-IN' => '말라얄람어(인도)',
        'mn' => '몽골어',
        'mn-MN' => '몽골어(몽골)',
        'mr' => '마라티어',
        'mr-IN' => '마라티어(인도)',
        'ms' => '말레이어',
        'ms-BN' => '말레이어(브루나이)',
        'ms-MY' => '말레이어(말레이시아)',
        'ms-SG' => '말레이어(싱가포르)',
        'mt' => '몰타어',
        'mt-MT' => '몰타어(몰타)',
        'mua' => '문당어',
        'mua-CM' => '문당어(카메룬)',
        'my' => '버마어',
        'my-MM' => '버마어(미얀마)',
        'mzn' => '마잔데라니어',
        'mzn-IR' => '마잔데라니어(이란)',
        'naq' => '나마어',
        'naq-NA' => '나마어(나미비아)',
        'nb' => '노르웨이어(보크말)',
        'nb-NO' => '노르웨이어(보크말)(노르웨이)',
        'nb-SJ' => '노르웨이어(보크말)(스발바르제도-얀마웬섬)',
        'nd' => '북부 은데벨레어',
        'nd-ZW' => '북부 은데벨레어(짐바브웨)',
        'nds' => '저지 독일어',
        'nds-DE' => '저지 독일어(독일)',
        'nds-NL' => '저지 독일어(네덜란드)',
        'ne' => '네팔어',
        'ne-IN' => '네팔어(인도)',
        'ne-NP' => '네팔어(네팔)',
        'nl' => '네덜란드어',
        'nl-AW' => '네덜란드어(아루바)',
        'nl-BE' => '네덜란드어(벨기에)',
        'nl-BQ' => '네덜란드어(네덜란드령 카리브)',
        'nl-CW' => '네덜란드어(퀴라소)',
        'nl-NL' => '네덜란드어(네덜란드)',
        'nl-SR' => '네덜란드어(수리남)',
        'nl-SX' => '네덜란드어(신트마르턴)',
        'nmg' => '크와시오어',
        'nmg-CM' => '크와시오어(카메룬)',
        'nn' => '노르웨이어(니노르스크)',
        'nn-NO' => '노르웨이어(니노르스크)(노르웨이)',
        'nnh' => '느기엠본어',
        'nnh-CM' => '느기엠본어(카메룬)',
        'nus' => '누에르어',
        'nus-SS' => '누에르어(남수단)',
        'nyn' => '니안콜어',
        'nyn-UG' => '니안콜어(우간다)',
        'om' => '오로모어',
        'om-ET' => '오로모어(에티오피아)',
        'om-KE' => '오로모어(케냐)',
        'or' => '오리야어',
        'or-IN' => '오리야어(인도)',
        'os' => '오세트어',
        'os-GE' => '오세트어(조지아)',
        'os-RU' => '오세트어(러시아)',
        'pa' => '펀잡어',
        'pa-Arab' => '펀잡어(아랍 문자)',
        'pa-Arab-PK' => '펀잡어(아랍 문자, 파키스탄)',
        'pa-Guru' => '펀잡어(구르무키 문자)',
        'pa-Guru-IN' => '펀잡어(구르무키 문자, 인도)',
        'pl' => '폴란드어',
        'pl-PL' => '폴란드어(폴란드)',
        'ps' => '파슈토어',
        'ps-AF' => '파슈토어(아프가니스탄)',
        'ps-PK' => '파슈토어(파키스탄)',
        'pt' => '포르투갈어',
        'pt-AO' => '포르투갈어(앙골라)',
        'pt-BR' => '포르투갈어(브라질)',
        'pt-CH' => '포르투갈어(스위스)',
        'pt-CV' => '포르투갈어(카보베르데)',
        'pt-GQ' => '포르투갈어(적도 기니)',
        'pt-GW' => '포르투갈어(기니비사우)',
        'pt-LU' => '포르투갈어(룩셈부르크)',
        'pt-MO' => '포르투갈어(마카오[중국 특별행정구])',
        'pt-MZ' => '포르투갈어(모잠비크)',
        'pt-PT' => '포르투갈어(포르투갈)',
        'pt-ST' => '포르투갈어(상투메 프린시페)',
        'pt-TL' => '포르투갈어(동티모르)',
        'qu' => '케추아어',
        'qu-BO' => '케추아어(볼리비아)',
        'qu-EC' => '케추아어(에콰도르)',
        'qu-PE' => '케추아어(페루)',
        'rm' => '로만시어',
        'rm-CH' => '로만시어(스위스)',
        'rn' => '룬디어',
        'rn-BI' => '룬디어(부룬디)',
        'ro' => '루마니아어',
        'ro-MD' => '루마니아어(몰도바)',
        'ro-RO' => '루마니아어(루마니아)',
        'rof' => '롬보어',
        'rof-TZ' => '롬보어(탄자니아)',
        'ru' => '러시아어',
        'ru-BY' => '러시아어(벨라루스)',
        'ru-KG' => '러시아어(키르기스스탄)',
        'ru-KZ' => '러시아어(카자흐스탄)',
        'ru-MD' => '러시아어(몰도바)',
        'ru-RU' => '러시아어(러시아)',
        'ru-UA' => '러시아어(우크라이나)',
        'rw' => '르완다어',
        'rw-RW' => '르완다어(르완다)',
        'rwk' => '르와어',
        'rwk-TZ' => '르와어(탄자니아)',
        'sah' => '야쿠트어',
        'sah-RU' => '야쿠트어(러시아)',
        'saq' => '삼부루어',
        'saq-KE' => '삼부루어(케냐)',
        'sbp' => '상구어',
        'sbp-TZ' => '상구어(탄자니아)',
        'sd' => '신디어',
        'sd-PK' => '신디어(파키스탄)',
        'se' => '북부 사미어',
        'se-FI' => '북부 사미어(핀란드)',
        'se-NO' => '북부 사미어(노르웨이)',
        'se-SE' => '북부 사미어(스웨덴)',
        'seh' => '세나어',
        'seh-MZ' => '세나어(모잠비크)',
        'ses' => '코이야보로 세니어',
        'ses-ML' => '코이야보로 세니어(말리)',
        'sg' => '산고어',
        'sg-CF' => '산고어(중앙 아프리카 공화국)',
        'shi' => '타셸히트어',
        'shi-Latn' => '타셸히트어(로마자)',
        'shi-Latn-MA' => '타셸히트어(로마자, 모로코)',
        'shi-Tfng' => '타셸히트어(티피나그 문자)',
        'shi-Tfng-MA' => '타셸히트어(티피나그 문자, 모로코)',
        'si' => '스리랑카어',
        'si-LK' => '스리랑카어(스리랑카)',
        'sk' => '슬로바키아어',
        'sk-SK' => '슬로바키아어(슬로바키아)',
        'sl' => '슬로베니아어',
        'sl-SI' => '슬로베니아어(슬로베니아)',
        'smn' => '이나리 사미어',
        'smn-FI' => '이나리 사미어(핀란드)',
        'sn' => '쇼나어',
        'sn-ZW' => '쇼나어(짐바브웨)',
        'so' => '소말리아어',
        'so-DJ' => '소말리아어(지부티)',
        'so-ET' => '소말리아어(에티오피아)',
        'so-KE' => '소말리아어(케냐)',
        'so-SO' => '소말리아어(소말리아)',
        'sq' => '알바니아어',
        'sq-AL' => '알바니아어(알바니아)',
        'sq-MK' => '알바니아어(마케도니아)',
        'sq-XK' => '알바니아어(코소보)',
        'sr' => '세르비아어',
        'sr-Cyrl' => '세르비아어(키릴 문자)',
        'sr-Cyrl-BA' => '세르비아어(키릴 문자, 보스니아 헤르체고비나)',
        'sr-Cyrl-ME' => '세르비아어(키릴 문자, 몬테네그로)',
        'sr-Cyrl-RS' => '세르비아어(키릴 문자, 세르비아)',
        'sr-Cyrl-XK' => '세르비아어(키릴 문자, 코소보)',
        'sr-Latn' => '세르비아어(로마자)',
        'sr-Latn-BA' => '세르비아어(로마자, 보스니아 헤르체고비나)',
        'sr-Latn-ME' => '세르비아어(로마자, 몬테네그로)',
        'sr-Latn-RS' => '세르비아어(로마자, 세르비아)',
        'sr-Latn-XK' => '세르비아어(로마자, 코소보)',
        'sv' => '스웨덴어',
        'sv-AX' => '스웨덴어(올란드 제도)',
        'sv-FI' => '스웨덴어(핀란드)',
        'sv-SE' => '스웨덴어(스웨덴)',
        'sw' => '스와힐리어',
        'sw-CD' => '스와힐리어(콩고-킨샤사)',
        'sw-KE' => '스와힐리어(케냐)',
        'sw-TZ' => '스와힐리어(탄자니아)',
        'sw-UG' => '스와힐리어(우간다)',
        'ta' => '타밀어',
        'ta-IN' => '타밀어(인도)',
        'ta-LK' => '타밀어(스리랑카)',
        'ta-MY' => '타밀어(말레이시아)',
        'ta-SG' => '타밀어(싱가포르)',
        'te' => '텔루구어',
        'te-IN' => '텔루구어(인도)',
        'teo' => '테조어',
        'teo-KE' => '테조어(케냐)',
        'teo-UG' => '테조어(우간다)',
        'tg' => '타지크어',
        'tg-TJ' => '타지크어(타지키스탄)',
        'th' => '태국어',
        'th-TH' => '태국어(태국)',
        'ti' => '티그리냐어',
        'ti-ER' => '티그리냐어(에리트리아)',
        'ti-ET' => '티그리냐어(에티오피아)',
        'tk' => '투르크멘어',
        'tk-TM' => '투르크멘어(투르크메니스탄)',
        'to' => '통가어',
        'to-TO' => '통가어(통가)',
        'tr' => '터키어',
        'tr-CY' => '터키어(키프로스)',
        'tr-TR' => '터키어(터키)',
        'tt' => '타타르어',
        'tt-RU' => '타타르어(러시아)',
        'twq' => '타사와크어',
        'twq-NE' => '타사와크어(니제르)',
        'tzm' => '중앙 모로코 타마지트어',
        'tzm-MA' => '중앙 모로코 타마지트어(모로코)',
        'ug' => '위구르어',
        'ug-CN' => '위구르어(중국)',
        'uk' => '우크라이나어',
        'uk-UA' => '우크라이나어(우크라이나)',
        'ur' => '우르두어',
        'ur-IN' => '우르두어(인도)',
        'ur-PK' => '우르두어(파키스탄)',
        'uz' => '우즈베크어',
        'uz-Arab' => '우즈베크어(아랍 문자)',
        'uz-Arab-AF' => '우즈베크어(아랍 문자, 아프가니스탄)',
        'uz-Cyrl' => '우즈베크어(키릴 문자)',
        'uz-Cyrl-UZ' => '우즈베크어(키릴 문자, 우즈베키스탄)',
        'uz-Latn' => '우즈베크어(로마자)',
        'uz-Latn-UZ' => '우즈베크어(로마자, 우즈베키스탄)',
        'vai' => '바이어',
        'vai-Latn' => '바이어(로마자)',
        'vai-Latn-LR' => '바이어(로마자, 라이베리아)',
        'vai-Vaii' => '바이어(바이 문자)',
        'vai-Vaii-LR' => '바이어(바이 문자, 라이베리아)',
        'vi' => '베트남어',
        'vi-VN' => '베트남어(베트남)',
        'vun' => '분조어',
        'vun-TZ' => '분조어(탄자니아)',
        'wae' => '월저어',
        'wae-CH' => '월저어(스위스)',
        'wo' => '월로프어',
        'wo-SN' => '월로프어(세네갈)',
        'xh' => '코사어',
        'xh-ZA' => '코사어(남아프리카)',
        'xog' => '소가어',
        'xog-UG' => '소가어(우간다)',
        'yav' => '양본어',
        'yav-CM' => '양본어(카메룬)',
        'yi' => '이디시어',
        'yi-001' => '이디시어(세계)',
        'yo' => '요루바어',
        'yo-BJ' => '요루바어(베냉)',
        'yo-NG' => '요루바어(나이지리아)',
        'yue' => '광둥어',
        'yue-Hans' => '광둥어(간체)',
        'yue-Hans-CN' => '광둥어(간체, 중국)',
        'yue-Hant' => '광둥어(번체)',
        'yue-Hant-HK' => '광둥어(번체, 홍콩[중국 특별행정구])',
        'zgh' => '표준 모로코 타마지트어',
        'zgh-MA' => '표준 모로코 타마지트어(모로코)',
        'zh' => '중국어',
        'zh-Hans' => '중국어(간체)',
        'zh-Hans-CN' => '중국어(간체, 중국)',
        'zh-Hans-HK' => '중국어(간체, 홍콩[중국 특별행정구])',
        'zh-Hans-MO' => '중국어(간체, 마카오[중국 특별행정구])',
        'zh-Hans-SG' => '중국어(간체, 싱가포르)',
        'zh-Hant' => '중국어(번체)',
        'zh-Hant-HK' => '중국어(번체, 홍콩[중국 특별행정구])',
        'zh-Hant-MO' => '중국어(번체, 마카오[중국 특별행정구])',
        'zh-Hant-TW' => '중국어(번체, 대만)',
        'zu' => '줄루어',
        'zu-ZA' => '줄루어(남아프리카)',
    ],
];
