<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'dd-MM-y',
            'time' => 'HH:mm',
            'datetime' => 'dd-MM-y HH:mm',
        ],
        'medium' => [
            'date' => 'd MMM y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd MMM y HH:mm:ss',
        ],
        'long' => [
            'date' => 'd MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd MMMM y \'om\' HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE d MMMM y',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'EEEE d MMMM y \'om\' HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤ #,##0.00;¤ -#,##0.00',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'a.m.',
    'pmName' => 'p.m.',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => '.',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '.',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'C$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JP¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => 'US$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'XPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'feb.',
            'mrt.',
            'apr.',
            'mei',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.',
        ],
        'full' => [
            'januari',
            'februari',
            'maart',
            'april',
            'mei',
            'juni',
            'juli',
            'augustus',
            'september',
            'oktober',
            'november',
            'december',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'feb.',
            'mrt.',
            'apr.',
            'mei',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.',
        ],
        'full' => [
            'januari',
            'februari',
            'maart',
            'april',
            'mei',
            'juni',
            'juli',
            'augustus',
            'september',
            'oktober',
            'november',
            'december',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'Z',
            'M',
            'D',
            'W',
            'D',
            'V',
            'Z',
        ],
        'short' => [
            'zo',
            'ma',
            'di',
            'wo',
            'do',
            'vr',
            'za',
        ],
        'medium' => [
            'zo',
            'ma',
            'di',
            'wo',
            'do',
            'vr',
            'za',
        ],
        'full' => [
            'zondag',
            'maandag',
            'dinsdag',
            'woensdag',
            'donderdag',
            'vrijdag',
            'zaterdag',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'Z',
            'M',
            'D',
            'W',
            'D',
            'V',
            'Z',
        ],
        'short' => [
            'zo',
            'ma',
            'di',
            'wo',
            'do',
            'vr',
            'za',
        ],
        'medium' => [
            'zo',
            'ma',
            'di',
            'wo',
            'do',
            'vr',
            'za',
        ],
        'full' => [
            'zondag',
            'maandag',
            'dinsdag',
            'woensdag',
            'donderdag',
            'vrijdag',
            'zaterdag',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'Afrikaans',
        'af-NA' => 'Afrikaans (Namibië)',
        'af-ZA' => 'Afrikaans (Zuid-Afrika)',
        'agq' => 'Aghem',
        'agq-CM' => 'Aghem (Kameroen)',
        'ak' => 'Akan',
        'ak-GH' => 'Akan (Ghana)',
        'am' => 'Amhaars',
        'am-ET' => 'Amhaars (Ethiopië)',
        'ar' => 'Arabisch',
        'ar-001' => 'Arabisch (wereld)',
        'ar-AE' => 'Arabisch (Verenigde Arabische Emiraten)',
        'ar-BH' => 'Arabisch (Bahrein)',
        'ar-DJ' => 'Arabisch (Djibouti)',
        'ar-DZ' => 'Arabisch (Algerije)',
        'ar-EG' => 'Arabisch (Egypte)',
        'ar-EH' => 'Arabisch (Westelijke Sahara)',
        'ar-ER' => 'Arabisch (Eritrea)',
        'ar-IL' => 'Arabisch (Israël)',
        'ar-IQ' => 'Arabisch (Irak)',
        'ar-JO' => 'Arabisch (Jordanië)',
        'ar-KM' => 'Arabisch (Comoren)',
        'ar-KW' => 'Arabisch (Koeweit)',
        'ar-LB' => 'Arabisch (Libanon)',
        'ar-LY' => 'Arabisch (Libië)',
        'ar-MA' => 'Arabisch (Marokko)',
        'ar-MR' => 'Arabisch (Mauritanië)',
        'ar-OM' => 'Arabisch (Oman)',
        'ar-PS' => 'Arabisch (Palestijnse gebieden)',
        'ar-QA' => 'Arabisch (Qatar)',
        'ar-SA' => 'Arabisch (Saoedi-Arabië)',
        'ar-SD' => 'Arabisch (Soedan)',
        'ar-SO' => 'Arabisch (Somalië)',
        'ar-SS' => 'Arabisch (Zuid-Soedan)',
        'ar-SY' => 'Arabisch (Syrië)',
        'ar-TD' => 'Arabisch (Tsjaad)',
        'ar-TN' => 'Arabisch (Tunesië)',
        'ar-YE' => 'Arabisch (Jemen)',
        'as' => 'Assamees',
        'as-IN' => 'Assamees (India)',
        'asa' => 'Asu',
        'asa-TZ' => 'Asu (Tanzania)',
        'ast' => 'Asturisch',
        'ast-ES' => 'Asturisch (Spanje)',
        'az' => 'Azerbeidzjaans',
        'az-Cyrl' => 'Azerbeidzjaans (Cyrillisch)',
        'az-Cyrl-AZ' => 'Azerbeidzjaans (Cyrillisch, Azerbeidzjan)',
        'az-Latn' => 'Azerbeidzjaans (Latijns)',
        'az-Latn-AZ' => 'Azerbeidzjaans (Latijns, Azerbeidzjan)',
        'bas' => 'Basa',
        'bas-CM' => 'Basa (Kameroen)',
        'be' => 'Wit-Russisch',
        'be-BY' => 'Wit-Russisch (Belarus)',
        'bem' => 'Bemba',
        'bem-ZM' => 'Bemba (Zambia)',
        'bez' => 'Bena',
        'bez-TZ' => 'Bena (Tanzania)',
        'bg' => 'Bulgaars',
        'bg-BG' => 'Bulgaars (Bulgarije)',
        'bm' => 'Bambara',
        'bm-ML' => 'Bambara (Mali)',
        'bn' => 'Bengaals',
        'bn-BD' => 'Bengaals (Bangladesh)',
        'bn-IN' => 'Bengaals (India)',
        'bo' => 'Tibetaans',
        'bo-CN' => 'Tibetaans (China)',
        'bo-IN' => 'Tibetaans (India)',
        'br' => 'Bretons',
        'br-FR' => 'Bretons (Frankrijk)',
        'brx' => 'Bodo',
        'brx-IN' => 'Bodo (India)',
        'bs' => 'Bosnisch',
        'bs-Cyrl' => 'Bosnisch (Cyrillisch)',
        'bs-Cyrl-BA' => 'Bosnisch (Cyrillisch, Bosnië en Herzegovina)',
        'bs-Latn' => 'Bosnisch (Latijns)',
        'bs-Latn-BA' => 'Bosnisch (Latijns, Bosnië en Herzegovina)',
        'ca' => 'Catalaans',
        'ca-AD' => 'Catalaans (Andorra)',
        'ca-ES' => 'Catalaans (Spanje)',
        'ca-FR' => 'Catalaans (Frankrijk)',
        'ca-IT' => 'Catalaans (Italië)',
        'ccp' => 'Chakma',
        'ccp-BD' => 'Chakma (Bangladesh)',
        'ccp-IN' => 'Chakma (India)',
        'ce' => 'Tsjetsjeens',
        'ce-RU' => 'Tsjetsjeens (Rusland)',
        'ceb' => 'Cebuano',
        'ceb-PH' => 'Cebuano (Filipijnen)',
        'cgg' => 'Chiga',
        'cgg-UG' => 'Chiga (Oeganda)',
        'chr' => 'Cherokee',
        'chr-US' => 'Cherokee (Verenigde Staten)',
        'ckb' => 'Soranî',
        'ckb-IQ' => 'Soranî (Irak)',
        'ckb-IR' => 'Soranî (Iran)',
        'cs' => 'Tsjechisch',
        'cs-CZ' => 'Tsjechisch (Tsjechië)',
        'cy' => 'Welsh',
        'cy-GB' => 'Welsh (Verenigd Koninkrijk)',
        'da' => 'Deens',
        'da-DK' => 'Deens (Denemarken)',
        'da-GL' => 'Deens (Groenland)',
        'dav' => 'Taita',
        'dav-KE' => 'Taita (Kenia)',
        'de' => 'Duits',
        'de-AT' => 'Duits (Oostenrijk)',
        'de-BE' => 'Duits (België)',
        'de-CH' => 'Duits (Zwitserland)',
        'de-DE' => 'Duits (Duitsland)',
        'de-IT' => 'Duits (Italië)',
        'de-LI' => 'Duits (Liechtenstein)',
        'de-LU' => 'Duits (Luxemburg)',
        'dje' => 'Zarma',
        'dje-NE' => 'Zarma (Niger)',
        'dsb' => 'Nedersorbisch',
        'dsb-DE' => 'Nedersorbisch (Duitsland)',
        'dua' => 'Duala',
        'dua-CM' => 'Duala (Kameroen)',
        'dyo' => 'Jola-Fonyi',
        'dyo-SN' => 'Jola-Fonyi (Senegal)',
        'dz' => 'Dzongkha',
        'dz-BT' => 'Dzongkha (Bhutan)',
        'ebu' => 'Embu',
        'ebu-KE' => 'Embu (Kenia)',
        'ee' => 'Ewe',
        'ee-GH' => 'Ewe (Ghana)',
        'ee-TG' => 'Ewe (Togo)',
        'el' => 'Grieks',
        'el-CY' => 'Grieks (Cyprus)',
        'el-GR' => 'Grieks (Griekenland)',
        'en' => 'Engels',
        'en-001' => 'Engels (wereld)',
        'en-150' => 'Engels (Europa)',
        'en-AE' => 'Engels (Verenigde Arabische Emiraten)',
        'en-AG' => 'Engels (Antigua en Barbuda)',
        'en-AI' => 'Engels (Anguilla)',
        'en-AS' => 'Engels (Amerikaans-Samoa)',
        'en-AT' => 'Engels (Oostenrijk)',
        'en-AU' => 'Engels (Australië)',
        'en-BB' => 'Engels (Barbados)',
        'en-BE' => 'Engels (België)',
        'en-BI' => 'Engels (Burundi)',
        'en-BM' => 'Engels (Bermuda)',
        'en-BS' => 'Engels (Bahama’s)',
        'en-BW' => 'Engels (Botswana)',
        'en-BZ' => 'Engels (Belize)',
        'en-CA' => 'Engels (Canada)',
        'en-CC' => 'Engels (Cocoseilanden)',
        'en-CH' => 'Engels (Zwitserland)',
        'en-CK' => 'Engels (Cookeilanden)',
        'en-CM' => 'Engels (Kameroen)',
        'en-CX' => 'Engels (Christmaseiland)',
        'en-CY' => 'Engels (Cyprus)',
        'en-DE' => 'Engels (Duitsland)',
        'en-DG' => 'Engels (Diego Garcia)',
        'en-DK' => 'Engels (Denemarken)',
        'en-DM' => 'Engels (Dominica)',
        'en-ER' => 'Engels (Eritrea)',
        'en-FI' => 'Engels (Finland)',
        'en-FJ' => 'Engels (Fiji)',
        'en-FK' => 'Engels (Falklandeilanden)',
        'en-FM' => 'Engels (Micronesia)',
        'en-GB' => 'Engels (Verenigd Koninkrijk)',
        'en-GD' => 'Engels (Grenada)',
        'en-GG' => 'Engels (Guernsey)',
        'en-GH' => 'Engels (Ghana)',
        'en-GI' => 'Engels (Gibraltar)',
        'en-GM' => 'Engels (Gambia)',
        'en-GU' => 'Engels (Guam)',
        'en-GY' => 'Engels (Guyana)',
        'en-HK' => 'Engels (Hongkong SAR van China)',
        'en-IE' => 'Engels (Ierland)',
        'en-IL' => 'Engels (Israël)',
        'en-IM' => 'Engels (Isle of Man)',
        'en-IN' => 'Engels (India)',
        'en-IO' => 'Engels (Brits Indische Oceaanterritorium)',
        'en-JE' => 'Engels (Jersey)',
        'en-JM' => 'Engels (Jamaica)',
        'en-KE' => 'Engels (Kenia)',
        'en-KI' => 'Engels (Kiribati)',
        'en-KN' => 'Engels (Saint Kitts en Nevis)',
        'en-KY' => 'Engels (Kaaimaneilanden)',
        'en-LC' => 'Engels (Saint Lucia)',
        'en-LR' => 'Engels (Liberia)',
        'en-LS' => 'Engels (Lesotho)',
        'en-MG' => 'Engels (Madagaskar)',
        'en-MH' => 'Engels (Marshalleilanden)',
        'en-MO' => 'Engels (Macau SAR van China)',
        'en-MP' => 'Engels (Noordelijke Marianen)',
        'en-MS' => 'Engels (Montserrat)',
        'en-MT' => 'Engels (Malta)',
        'en-MU' => 'Engels (Mauritius)',
        'en-MW' => 'Engels (Malawi)',
        'en-MY' => 'Engels (Maleisië)',
        'en-NA' => 'Engels (Namibië)',
        'en-NF' => 'Engels (Norfolk)',
        'en-NG' => 'Engels (Nigeria)',
        'en-NL' => 'Engels (Nederland)',
        'en-NR' => 'Engels (Nauru)',
        'en-NU' => 'Engels (Niue)',
        'en-NZ' => 'Engels (Nieuw-Zeeland)',
        'en-PG' => 'Engels (Papoea-Nieuw-Guinea)',
        'en-PH' => 'Engels (Filipijnen)',
        'en-PK' => 'Engels (Pakistan)',
        'en-PN' => 'Engels (Pitcairneilanden)',
        'en-PR' => 'Engels (Puerto Rico)',
        'en-PW' => 'Engels (Palau)',
        'en-RW' => 'Engels (Rwanda)',
        'en-SB' => 'Engels (Salomonseilanden)',
        'en-SC' => 'Engels (Seychellen)',
        'en-SD' => 'Engels (Soedan)',
        'en-SE' => 'Engels (Zweden)',
        'en-SG' => 'Engels (Singapore)',
        'en-SH' => 'Engels (Sint-Helena)',
        'en-SI' => 'Engels (Slovenië)',
        'en-SL' => 'Engels (Sierra Leone)',
        'en-SS' => 'Engels (Zuid-Soedan)',
        'en-SX' => 'Engels (Sint-Maarten)',
        'en-SZ' => 'Engels (eSwatini)',
        'en-TC' => 'Engels (Turks- en Caicoseilanden)',
        'en-TK' => 'Engels (Tokelau)',
        'en-TO' => 'Engels (Tonga)',
        'en-TT' => 'Engels (Trinidad en Tobago)',
        'en-TV' => 'Engels (Tuvalu)',
        'en-TZ' => 'Engels (Tanzania)',
        'en-UG' => 'Engels (Oeganda)',
        'en-UM' => 'Engels (Kleine afgelegen eilanden van de Verenigde Staten)',
        'en-US' => 'Engels (Verenigde Staten)',
        'en-US-POSIX' => 'Engels (Verenigde Staten, Computer)',
        'en-VC' => 'Engels (Saint Vincent en de Grenadines)',
        'en-VG' => 'Engels (Britse Maagdeneilanden)',
        'en-VI' => 'Engels (Amerikaanse Maagdeneilanden)',
        'en-VU' => 'Engels (Vanuatu)',
        'en-WS' => 'Engels (Samoa)',
        'en-ZA' => 'Engels (Zuid-Afrika)',
        'en-ZM' => 'Engels (Zambia)',
        'en-ZW' => 'Engels (Zimbabwe)',
        'eo' => 'Esperanto',
        'eo-001' => 'Esperanto (wereld)',
        'es' => 'Spaans',
        'es-419' => 'Spaans (Latijns-Amerika)',
        'es-AR' => 'Spaans (Argentinië)',
        'es-BO' => 'Spaans (Bolivia)',
        'es-BR' => 'Spaans (Brazilië)',
        'es-BZ' => 'Spaans (Belize)',
        'es-CL' => 'Spaans (Chili)',
        'es-CO' => 'Spaans (Colombia)',
        'es-CR' => 'Spaans (Costa Rica)',
        'es-CU' => 'Spaans (Cuba)',
        'es-DO' => 'Spaans (Dominicaanse Republiek)',
        'es-EA' => 'Spaans (Ceuta en Melilla)',
        'es-EC' => 'Spaans (Ecuador)',
        'es-ES' => 'Spaans (Spanje)',
        'es-GQ' => 'Spaans (Equatoriaal-Guinea)',
        'es-GT' => 'Spaans (Guatemala)',
        'es-HN' => 'Spaans (Honduras)',
        'es-IC' => 'Spaans (Canarische Eilanden)',
        'es-MX' => 'Spaans (Mexico)',
        'es-NI' => 'Spaans (Nicaragua)',
        'es-PA' => 'Spaans (Panama)',
        'es-PE' => 'Spaans (Peru)',
        'es-PH' => 'Spaans (Filipijnen)',
        'es-PR' => 'Spaans (Puerto Rico)',
        'es-PY' => 'Spaans (Paraguay)',
        'es-SV' => 'Spaans (El Salvador)',
        'es-US' => 'Spaans (Verenigde Staten)',
        'es-UY' => 'Spaans (Uruguay)',
        'es-VE' => 'Spaans (Venezuela)',
        'et' => 'Estisch',
        'et-EE' => 'Estisch (Estland)',
        'eu' => 'Baskisch',
        'eu-ES' => 'Baskisch (Spanje)',
        'ewo' => 'Ewondo',
        'ewo-CM' => 'Ewondo (Kameroen)',
        'fa' => 'Perzisch',
        'fa-AF' => 'Perzisch (Afghanistan)',
        'fa-IR' => 'Perzisch (Iran)',
        'ff' => 'Fulah',
        'ff-Latn' => 'Fulah (Latijns)',
        'ff-Latn-BF' => 'Fulah (Latijns, Burkina Faso)',
        'ff-Latn-CM' => 'Fulah (Latijns, Kameroen)',
        'ff-Latn-GH' => 'Fulah (Latijns, Ghana)',
        'ff-Latn-GM' => 'Fulah (Latijns, Gambia)',
        'ff-Latn-GN' => 'Fulah (Latijns, Guinee)',
        'ff-Latn-GW' => 'Fulah (Latijns, Guinee-Bissau)',
        'ff-Latn-LR' => 'Fulah (Latijns, Liberia)',
        'ff-Latn-MR' => 'Fulah (Latijns, Mauritanië)',
        'ff-Latn-NE' => 'Fulah (Latijns, Niger)',
        'ff-Latn-NG' => 'Fulah (Latijns, Nigeria)',
        'ff-Latn-SL' => 'Fulah (Latijns, Sierra Leone)',
        'ff-Latn-SN' => 'Fulah (Latijns, Senegal)',
        'fi' => 'Fins',
        'fi-FI' => 'Fins (Finland)',
        'fil' => 'Filipijns',
        'fil-PH' => 'Filipijns (Filipijnen)',
        'fo' => 'Faeröers',
        'fo-DK' => 'Faeröers (Denemarken)',
        'fo-FO' => 'Faeröers (Faeröer)',
        'fr' => 'Frans',
        'fr-BE' => 'Frans (België)',
        'fr-BF' => 'Frans (Burkina Faso)',
        'fr-BI' => 'Frans (Burundi)',
        'fr-BJ' => 'Frans (Benin)',
        'fr-BL' => 'Frans (Saint-Barthélemy)',
        'fr-CA' => 'Frans (Canada)',
        'fr-CD' => 'Frans (Congo-Kinshasa)',
        'fr-CF' => 'Frans (Centraal-Afrikaanse Republiek)',
        'fr-CG' => 'Frans (Congo-Brazzaville)',
        'fr-CH' => 'Frans (Zwitserland)',
        'fr-CI' => 'Frans (Ivoorkust)',
        'fr-CM' => 'Frans (Kameroen)',
        'fr-DJ' => 'Frans (Djibouti)',
        'fr-DZ' => 'Frans (Algerije)',
        'fr-FR' => 'Frans (Frankrijk)',
        'fr-GA' => 'Frans (Gabon)',
        'fr-GF' => 'Frans (Frans-Guyana)',
        'fr-GN' => 'Frans (Guinee)',
        'fr-GP' => 'Frans (Guadeloupe)',
        'fr-GQ' => 'Frans (Equatoriaal-Guinea)',
        'fr-HT' => 'Frans (Haïti)',
        'fr-KM' => 'Frans (Comoren)',
        'fr-LU' => 'Frans (Luxemburg)',
        'fr-MA' => 'Frans (Marokko)',
        'fr-MC' => 'Frans (Monaco)',
        'fr-MF' => 'Frans (Saint-Martin)',
        'fr-MG' => 'Frans (Madagaskar)',
        'fr-ML' => 'Frans (Mali)',
        'fr-MQ' => 'Frans (Martinique)',
        'fr-MR' => 'Frans (Mauritanië)',
        'fr-MU' => 'Frans (Mauritius)',
        'fr-NC' => 'Frans (Nieuw-Caledonië)',
        'fr-NE' => 'Frans (Niger)',
        'fr-PF' => 'Frans (Frans-Polynesië)',
        'fr-PM' => 'Frans (Saint-Pierre en Miquelon)',
        'fr-RE' => 'Frans (Réunion)',
        'fr-RW' => 'Frans (Rwanda)',
        'fr-SC' => 'Frans (Seychellen)',
        'fr-SN' => 'Frans (Senegal)',
        'fr-SY' => 'Frans (Syrië)',
        'fr-TD' => 'Frans (Tsjaad)',
        'fr-TG' => 'Frans (Togo)',
        'fr-TN' => 'Frans (Tunesië)',
        'fr-VU' => 'Frans (Vanuatu)',
        'fr-WF' => 'Frans (Wallis en Futuna)',
        'fr-YT' => 'Frans (Mayotte)',
        'fur' => 'Friulisch',
        'fur-IT' => 'Friulisch (Italië)',
        'fy' => 'Fries',
        'fy-NL' => 'Fries (Nederland)',
        'ga' => 'Iers',
        'ga-IE' => 'Iers (Ierland)',
        'gd' => 'Schots-Gaelisch',
        'gd-GB' => 'Schots-Gaelisch (Verenigd Koninkrijk)',
        'gl' => 'Galicisch',
        'gl-ES' => 'Galicisch (Spanje)',
        'gsw' => 'Zwitserduits',
        'gsw-CH' => 'Zwitserduits (Zwitserland)',
        'gsw-FR' => 'Zwitserduits (Frankrijk)',
        'gsw-LI' => 'Zwitserduits (Liechtenstein)',
        'gu' => 'Gujarati',
        'gu-IN' => 'Gujarati (India)',
        'guz' => 'Gusii',
        'guz-KE' => 'Gusii (Kenia)',
        'gv' => 'Manx',
        'gv-IM' => 'Manx (Isle of Man)',
        'ha' => 'Hausa',
        'ha-GH' => 'Hausa (Ghana)',
        'ha-NE' => 'Hausa (Niger)',
        'ha-NG' => 'Hausa (Nigeria)',
        'haw' => 'Hawaïaans',
        'haw-US' => 'Hawaïaans (Verenigde Staten)',
        'he' => 'Hebreeuws',
        'he-IL' => 'Hebreeuws (Israël)',
        'hi' => 'Hindi',
        'hi-IN' => 'Hindi (India)',
        'hr' => 'Kroatisch',
        'hr-BA' => 'Kroatisch (Bosnië en Herzegovina)',
        'hr-HR' => 'Kroatisch (Kroatië)',
        'hsb' => 'Oppersorbisch',
        'hsb-DE' => 'Oppersorbisch (Duitsland)',
        'hu' => 'Hongaars',
        'hu-HU' => 'Hongaars (Hongarije)',
        'hy' => 'Armeens',
        'hy-AM' => 'Armeens (Armenië)',
        'ia' => 'Interlingua',
        'ia-001' => 'Interlingua (wereld)',
        'id' => 'Indonesisch',
        'id-ID' => 'Indonesisch (Indonesië)',
        'ig' => 'Igbo',
        'ig-NG' => 'Igbo (Nigeria)',
        'ii' => 'Yi',
        'ii-CN' => 'Yi (China)',
        'is' => 'IJslands',
        'is-IS' => 'IJslands (IJsland)',
        'it' => 'Italiaans',
        'it-CH' => 'Italiaans (Zwitserland)',
        'it-IT' => 'Italiaans (Italië)',
        'it-SM' => 'Italiaans (San Marino)',
        'it-VA' => 'Italiaans (Vaticaanstad)',
        'ja' => 'Japans',
        'ja-JP' => 'Japans (Japan)',
        'jgo' => 'Ngomba',
        'jgo-CM' => 'Ngomba (Kameroen)',
        'jmc' => 'Machame',
        'jmc-TZ' => 'Machame (Tanzania)',
        'jv' => 'Javaans',
        'jv-ID' => 'Javaans (Indonesië)',
        'ka' => 'Georgisch',
        'ka-GE' => 'Georgisch (Georgië)',
        'kab' => 'Kabylisch',
        'kab-DZ' => 'Kabylisch (Algerije)',
        'kam' => 'Kamba',
        'kam-KE' => 'Kamba (Kenia)',
        'kde' => 'Makonde',
        'kde-TZ' => 'Makonde (Tanzania)',
        'kea' => 'Kaapverdisch Creools',
        'kea-CV' => 'Kaapverdisch Creools (Kaapverdië)',
        'khq' => 'Koyra Chiini',
        'khq-ML' => 'Koyra Chiini (Mali)',
        'ki' => 'Gikuyu',
        'ki-KE' => 'Gikuyu (Kenia)',
        'kk' => 'Kazachs',
        'kk-KZ' => 'Kazachs (Kazachstan)',
        'kkj' => 'Kako',
        'kkj-CM' => 'Kako (Kameroen)',
        'kl' => 'Groenlands',
        'kl-GL' => 'Groenlands (Groenland)',
        'kln' => 'Kalenjin',
        'kln-KE' => 'Kalenjin (Kenia)',
        'km' => 'Khmer',
        'km-KH' => 'Khmer (Cambodja)',
        'kn' => 'Kannada',
        'kn-IN' => 'Kannada (India)',
        'ko' => 'Koreaans',
        'ko-KP' => 'Koreaans (Noord-Korea)',
        'ko-KR' => 'Koreaans (Zuid-Korea)',
        'kok' => 'Konkani',
        'kok-IN' => 'Konkani (India)',
        'ks' => 'Kasjmiri',
        'ks-IN' => 'Kasjmiri (India)',
        'ksb' => 'Shambala',
        'ksb-TZ' => 'Shambala (Tanzania)',
        'ksf' => 'Bafia',
        'ksf-CM' => 'Bafia (Kameroen)',
        'ksh' => 'Kölsch',
        'ksh-DE' => 'Kölsch (Duitsland)',
        'ku' => 'Koerdisch',
        'ku-TR' => 'Koerdisch (Turkije)',
        'kw' => 'Cornish',
        'kw-GB' => 'Cornish (Verenigd Koninkrijk)',
        'ky' => 'Kirgizisch',
        'ky-KG' => 'Kirgizisch (Kirgizië)',
        'lag' => 'Langi',
        'lag-TZ' => 'Langi (Tanzania)',
        'lb' => 'Luxemburgs',
        'lb-LU' => 'Luxemburgs (Luxemburg)',
        'lg' => 'Luganda',
        'lg-UG' => 'Luganda (Oeganda)',
        'lkt' => 'Lakota',
        'lkt-US' => 'Lakota (Verenigde Staten)',
        'ln' => 'Lingala',
        'ln-AO' => 'Lingala (Angola)',
        'ln-CD' => 'Lingala (Congo-Kinshasa)',
        'ln-CF' => 'Lingala (Centraal-Afrikaanse Republiek)',
        'ln-CG' => 'Lingala (Congo-Brazzaville)',
        'lo' => 'Laotiaans',
        'lo-LA' => 'Laotiaans (Laos)',
        'lrc' => 'Noordelijk Luri',
        'lrc-IQ' => 'Noordelijk Luri (Irak)',
        'lrc-IR' => 'Noordelijk Luri (Iran)',
        'lt' => 'Litouws',
        'lt-LT' => 'Litouws (Litouwen)',
        'lu' => 'Luba-Katanga',
        'lu-CD' => 'Luba-Katanga (Congo-Kinshasa)',
        'luo' => 'Luo',
        'luo-KE' => 'Luo (Kenia)',
        'luy' => 'Luyia',
        'luy-KE' => 'Luyia (Kenia)',
        'lv' => 'Lets',
        'lv-LV' => 'Lets (Letland)',
        'mas' => 'Maa',
        'mas-KE' => 'Maa (Kenia)',
        'mas-TZ' => 'Maa (Tanzania)',
        'mer' => 'Meru',
        'mer-KE' => 'Meru (Kenia)',
        'mfe' => 'Morisyen',
        'mfe-MU' => 'Morisyen (Mauritius)',
        'mg' => 'Malagassisch',
        'mg-MG' => 'Malagassisch (Madagaskar)',
        'mgh' => 'Makhuwa-Meetto',
        'mgh-MZ' => 'Makhuwa-Meetto (Mozambique)',
        'mgo' => 'Meta’',
        'mgo-CM' => 'Meta’ (Kameroen)',
        'mi' => 'Maori',
        'mi-NZ' => 'Maori (Nieuw-Zeeland)',
        'mk' => 'Macedonisch',
        'mk-MK' => 'Macedonisch (Noord-Macedonië)',
        'ml' => 'Malayalam',
        'ml-IN' => 'Malayalam (India)',
        'mn' => 'Mongools',
        'mn-MN' => 'Mongools (Mongolië)',
        'mr' => 'Marathi',
        'mr-IN' => 'Marathi (India)',
        'ms' => 'Maleis',
        'ms-BN' => 'Maleis (Brunei)',
        'ms-MY' => 'Maleis (Maleisië)',
        'ms-SG' => 'Maleis (Singapore)',
        'mt' => 'Maltees',
        'mt-MT' => 'Maltees (Malta)',
        'mua' => 'Mundang',
        'mua-CM' => 'Mundang (Kameroen)',
        'my' => 'Birmaans',
        'my-MM' => 'Birmaans (Myanmar [Birma])',
        'mzn' => 'Mazanderani',
        'mzn-IR' => 'Mazanderani (Iran)',
        'naq' => 'Nama',
        'naq-NA' => 'Nama (Namibië)',
        'nb' => 'Noors - Bokmål',
        'nb-NO' => 'Noors - Bokmål (Noorwegen)',
        'nb-SJ' => 'Noors - Bokmål (Spitsbergen en Jan Mayen)',
        'nd' => 'Noord-Ndebele',
        'nd-ZW' => 'Noord-Ndebele (Zimbabwe)',
        'nds' => 'Nedersaksisch',
        'nds-DE' => 'Nedersaksisch (Duitsland)',
        'nds-NL' => 'Nedersaksisch (Nederland)',
        'ne' => 'Nepalees',
        'ne-IN' => 'Nepalees (India)',
        'ne-NP' => 'Nepalees (Nepal)',
        'nl' => 'Nederlands',
        'nl-AW' => 'Nederlands (Aruba)',
        'nl-BE' => 'Nederlands (België)',
        'nl-BQ' => 'Nederlands (Caribisch Nederland)',
        'nl-CW' => 'Nederlands (Curaçao)',
        'nl-NL' => 'Nederlands (Nederland)',
        'nl-SR' => 'Nederlands (Suriname)',
        'nl-SX' => 'Nederlands (Sint-Maarten)',
        'nmg' => 'Ngumba',
        'nmg-CM' => 'Ngumba (Kameroen)',
        'nn' => 'Noors - Nynorsk',
        'nn-NO' => 'Noors - Nynorsk (Noorwegen)',
        'nnh' => 'Ngiemboon',
        'nnh-CM' => 'Ngiemboon (Kameroen)',
        'nus' => 'Nuer',
        'nus-SS' => 'Nuer (Zuid-Soedan)',
        'nyn' => 'Nyankole',
        'nyn-UG' => 'Nyankole (Oeganda)',
        'om' => 'Afaan Oromo',
        'om-ET' => 'Afaan Oromo (Ethiopië)',
        'om-KE' => 'Afaan Oromo (Kenia)',
        'or' => 'Odia',
        'or-IN' => 'Odia (India)',
        'os' => 'Ossetisch',
        'os-GE' => 'Ossetisch (Georgië)',
        'os-RU' => 'Ossetisch (Rusland)',
        'pa' => 'Punjabi',
        'pa-Arab' => 'Punjabi (Arabisch)',
        'pa-Arab-PK' => 'Punjabi (Arabisch, Pakistan)',
        'pa-Guru' => 'Punjabi (Gurmukhi)',
        'pa-Guru-IN' => 'Punjabi (Gurmukhi, India)',
        'pl' => 'Pools',
        'pl-PL' => 'Pools (Polen)',
        'ps' => 'Pasjtoe',
        'ps-AF' => 'Pasjtoe (Afghanistan)',
        'ps-PK' => 'Pasjtoe (Pakistan)',
        'pt' => 'Portugees',
        'pt-AO' => 'Portugees (Angola)',
        'pt-BR' => 'Portugees (Brazilië)',
        'pt-CH' => 'Portugees (Zwitserland)',
        'pt-CV' => 'Portugees (Kaapverdië)',
        'pt-GQ' => 'Portugees (Equatoriaal-Guinea)',
        'pt-GW' => 'Portugees (Guinee-Bissau)',
        'pt-LU' => 'Portugees (Luxemburg)',
        'pt-MO' => 'Portugees (Macau SAR van China)',
        'pt-MZ' => 'Portugees (Mozambique)',
        'pt-PT' => 'Portugees (Portugal)',
        'pt-ST' => 'Portugees (Sao Tomé en Principe)',
        'pt-TL' => 'Portugees (Oost-Timor)',
        'qu' => 'Quechua',
        'qu-BO' => 'Quechua (Bolivia)',
        'qu-EC' => 'Quechua (Ecuador)',
        'qu-PE' => 'Quechua (Peru)',
        'rm' => 'Reto-Romaans',
        'rm-CH' => 'Reto-Romaans (Zwitserland)',
        'rn' => 'Kirundi',
        'rn-BI' => 'Kirundi (Burundi)',
        'ro' => 'Roemeens',
        'ro-MD' => 'Roemeens (Moldavië)',
        'ro-RO' => 'Roemeens (Roemenië)',
        'rof' => 'Rombo',
        'rof-TZ' => 'Rombo (Tanzania)',
        'ru' => 'Russisch',
        'ru-BY' => 'Russisch (Belarus)',
        'ru-KG' => 'Russisch (Kirgizië)',
        'ru-KZ' => 'Russisch (Kazachstan)',
        'ru-MD' => 'Russisch (Moldavië)',
        'ru-RU' => 'Russisch (Rusland)',
        'ru-UA' => 'Russisch (Oekraïne)',
        'rw' => 'Kinyarwanda',
        'rw-RW' => 'Kinyarwanda (Rwanda)',
        'rwk' => 'Rwa',
        'rwk-TZ' => 'Rwa (Tanzania)',
        'sah' => 'Jakoets',
        'sah-RU' => 'Jakoets (Rusland)',
        'saq' => 'Samburu',
        'saq-KE' => 'Samburu (Kenia)',
        'sbp' => 'Sangu',
        'sbp-TZ' => 'Sangu (Tanzania)',
        'sd' => 'Sindhi',
        'sd-PK' => 'Sindhi (Pakistan)',
        'se' => 'Noord-Samisch',
        'se-FI' => 'Noord-Samisch (Finland)',
        'se-NO' => 'Noord-Samisch (Noorwegen)',
        'se-SE' => 'Noord-Samisch (Zweden)',
        'seh' => 'Sena',
        'seh-MZ' => 'Sena (Mozambique)',
        'ses' => 'Koyraboro Senni',
        'ses-ML' => 'Koyraboro Senni (Mali)',
        'sg' => 'Sango',
        'sg-CF' => 'Sango (Centraal-Afrikaanse Republiek)',
        'shi' => 'Tashelhiyt',
        'shi-Latn' => 'Tashelhiyt (Latijns)',
        'shi-Latn-MA' => 'Tashelhiyt (Latijns, Marokko)',
        'shi-Tfng' => 'Tashelhiyt (Tifinagh)',
        'shi-Tfng-MA' => 'Tashelhiyt (Tifinagh, Marokko)',
        'si' => 'Singalees',
        'si-LK' => 'Singalees (Sri Lanka)',
        'sk' => 'Slowaaks',
        'sk-SK' => 'Slowaaks (Slowakije)',
        'sl' => 'Sloveens',
        'sl-SI' => 'Sloveens (Slovenië)',
        'smn' => 'Inari-Samisch',
        'smn-FI' => 'Inari-Samisch (Finland)',
        'sn' => 'Shona',
        'sn-ZW' => 'Shona (Zimbabwe)',
        'so' => 'Somalisch',
        'so-DJ' => 'Somalisch (Djibouti)',
        'so-ET' => 'Somalisch (Ethiopië)',
        'so-KE' => 'Somalisch (Kenia)',
        'so-SO' => 'Somalisch (Somalië)',
        'sq' => 'Albanees',
        'sq-AL' => 'Albanees (Albanië)',
        'sq-MK' => 'Albanees (Noord-Macedonië)',
        'sq-XK' => 'Albanees (Kosovo)',
        'sr' => 'Servisch',
        'sr-Cyrl' => 'Servisch (Cyrillisch)',
        'sr-Cyrl-BA' => 'Servisch (Cyrillisch, Bosnië en Herzegovina)',
        'sr-Cyrl-ME' => 'Servisch (Cyrillisch, Montenegro)',
        'sr-Cyrl-RS' => 'Servisch (Cyrillisch, Servië)',
        'sr-Cyrl-XK' => 'Servisch (Cyrillisch, Kosovo)',
        'sr-Latn' => 'Servisch (Latijns)',
        'sr-Latn-BA' => 'Servisch (Latijns, Bosnië en Herzegovina)',
        'sr-Latn-ME' => 'Servisch (Latijns, Montenegro)',
        'sr-Latn-RS' => 'Servisch (Latijns, Servië)',
        'sr-Latn-XK' => 'Servisch (Latijns, Kosovo)',
        'sv' => 'Zweeds',
        'sv-AX' => 'Zweeds (Åland)',
        'sv-FI' => 'Zweeds (Finland)',
        'sv-SE' => 'Zweeds (Zweden)',
        'sw' => 'Swahili',
        'sw-CD' => 'Swahili (Congo-Kinshasa)',
        'sw-KE' => 'Swahili (Kenia)',
        'sw-TZ' => 'Swahili (Tanzania)',
        'sw-UG' => 'Swahili (Oeganda)',
        'ta' => 'Tamil',
        'ta-IN' => 'Tamil (India)',
        'ta-LK' => 'Tamil (Sri Lanka)',
        'ta-MY' => 'Tamil (Maleisië)',
        'ta-SG' => 'Tamil (Singapore)',
        'te' => 'Telugu',
        'te-IN' => 'Telugu (India)',
        'teo' => 'Teso',
        'teo-KE' => 'Teso (Kenia)',
        'teo-UG' => 'Teso (Oeganda)',
        'tg' => 'Tadzjieks',
        'tg-TJ' => 'Tadzjieks (Tadzjikistan)',
        'th' => 'Thai',
        'th-TH' => 'Thai (Thailand)',
        'ti' => 'Tigrinya',
        'ti-ER' => 'Tigrinya (Eritrea)',
        'ti-ET' => 'Tigrinya (Ethiopië)',
        'tk' => 'Turkmeens',
        'tk-TM' => 'Turkmeens (Turkmenistan)',
        'to' => 'Tongaans',
        'to-TO' => 'Tongaans (Tonga)',
        'tr' => 'Turks',
        'tr-CY' => 'Turks (Cyprus)',
        'tr-TR' => 'Turks (Turkije)',
        'tt' => 'Tataars',
        'tt-RU' => 'Tataars (Rusland)',
        'twq' => 'Tasawaq',
        'twq-NE' => 'Tasawaq (Niger)',
        'tzm' => 'Tamazight (Centraal-Marokko)',
        'tzm-MA' => 'Tamazight (Centraal-Marokko) (Marokko)',
        'ug' => 'Oeigoers',
        'ug-CN' => 'Oeigoers (China)',
        'uk' => 'Oekraïens',
        'uk-UA' => 'Oekraïens (Oekraïne)',
        'ur' => 'Urdu',
        'ur-IN' => 'Urdu (India)',
        'ur-PK' => 'Urdu (Pakistan)',
        'uz' => 'Oezbeeks',
        'uz-Arab' => 'Oezbeeks (Arabisch)',
        'uz-Arab-AF' => 'Oezbeeks (Arabisch, Afghanistan)',
        'uz-Cyrl' => 'Oezbeeks (Cyrillisch)',
        'uz-Cyrl-UZ' => 'Oezbeeks (Cyrillisch, Oezbekistan)',
        'uz-Latn' => 'Oezbeeks (Latijns)',
        'uz-Latn-UZ' => 'Oezbeeks (Latijns, Oezbekistan)',
        'vai' => 'Vai',
        'vai-Latn' => 'Vai (Latijns)',
        'vai-Latn-LR' => 'Vai (Latijns, Liberia)',
        'vai-Vaii' => 'Vai (Vai)',
        'vai-Vaii-LR' => 'Vai (Vai, Liberia)',
        'vi' => 'Vietnamees',
        'vi-VN' => 'Vietnamees (Vietnam)',
        'vun' => 'Vunjo',
        'vun-TZ' => 'Vunjo (Tanzania)',
        'wae' => 'Walser',
        'wae-CH' => 'Walser (Zwitserland)',
        'wo' => 'Wolof',
        'wo-SN' => 'Wolof (Senegal)',
        'xh' => 'Xhosa',
        'xh-ZA' => 'Xhosa (Zuid-Afrika)',
        'xog' => 'Soga',
        'xog-UG' => 'Soga (Oeganda)',
        'yav' => 'Yangben',
        'yav-CM' => 'Yangben (Kameroen)',
        'yi' => 'Jiddisch',
        'yi-001' => 'Jiddisch (wereld)',
        'yo' => 'Yoruba',
        'yo-BJ' => 'Yoruba (Benin)',
        'yo-NG' => 'Yoruba (Nigeria)',
        'yue' => 'Kantonees',
        'yue-Hans' => 'Kantonees (vereenvoudigd)',
        'yue-Hans-CN' => 'Kantonees (vereenvoudigd, China)',
        'yue-Hant' => 'Kantonees (traditioneel)',
        'yue-Hant-HK' => 'Kantonees (traditioneel, Hongkong SAR van China)',
        'zgh' => 'Standaard Marokkaanse Tamazight',
        'zgh-MA' => 'Standaard Marokkaanse Tamazight (Marokko)',
        'zh' => 'Chinees',
        'zh-Hans' => 'Chinees (vereenvoudigd)',
        'zh-Hans-CN' => 'Chinees (vereenvoudigd, China)',
        'zh-Hans-HK' => 'Chinees (vereenvoudigd, Hongkong SAR van China)',
        'zh-Hans-MO' => 'Chinees (vereenvoudigd, Macau SAR van China)',
        'zh-Hans-SG' => 'Chinees (vereenvoudigd, Singapore)',
        'zh-Hant' => 'Chinees (traditioneel)',
        'zh-Hant-HK' => 'Chinees (traditioneel, Hongkong SAR van China)',
        'zh-Hant-MO' => 'Chinees (traditioneel, Macau SAR van China)',
        'zh-Hant-TW' => 'Chinees (traditioneel, Taiwan)',
        'zu' => 'Zoeloe',
        'zu-ZA' => 'Zoeloe (Zuid-Afrika)',
    ],
];
