[//]: # (AUTO-GENERATED BY "PHP README Helper": base file -> docs/base.md)
[![Build Status](https://github.com/voku/Arrayy/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/voku/Arrayy/actions)
[![codecov.io](https://codecov.io/github/voku/Arrayy/coverage.svg?branch=master)](https://codecov.io/github/voku/Arrayy?branch=master)
[![Codacy Badge](https://api.codacy.com/project/badge/grade/b8c4c88a063545d787e2a4f1f5dfdf23)](https://www.codacy.com/app/voku/Arrayy)
[![Latest Stable Version](https://poser.pugx.org/voku/arrayy/v/stable)](https://packagist.org/packages/voku/arrayy) 
[![Total Downloads](https://poser.pugx.org/voku/arrayy/downloads)](https://packagist.org/packages/voku/arrayy) 
[![License](https://poser.pugx.org/voku/arrayy/license)](https://packagist.org/packages/voku/arrayy)
[![Donate to this project using Paypal](https://img.shields.io/badge/paypal-donate-yellow.svg)](https://www.paypal.me/moelleken)
[![Donate to this project using Patreon](https://img.shields.io/badge/patreon-donate-yellow.svg)](https://www.patreon.com/voku)

# 🗃 Arrayy

A PHP array manipulation library. Compatible with PHP 7+ & PHP 8+


``` php
\Arrayy\Type\StringCollection::create(['Array', 'Array'])->unique()->append('y')->implode() // Arrayy
```
[documentation via gitbooks.io](https://voku.gitbooks.io/arrayy/content/)

* [Installation](#installation-via-composer-require)
* [Multidimensional ArrayAccess](#multidimensional-arrayaccess)
* [PhpDoc @property checking](#phpdoc-property-checking)
* [OO and Chaining](#oo-and-chaining)
* [Collections](#collections)
    * [Pre-Defined Typified Collections](#pre-defined-typified-collections])
    * [Convert JSON-Data into Collections](#convert-json-data-into-objects-collection)
* [Class methods](#class-methods)
    * [use a "default object"](#use-a-default-object)
    * [create](#createarray-array--arrayy-immutable)
    * [createByReference](#createbyreferencearray-array--arrayy-mutable)
    * [createFromJson](#createfromjsonstring-json--arrayy-immutable)
    * [createFromJsonMapper](#createfromjsonmapperstring-json--arrayy-immutable)
    * [createFromObject](#createfromobjectarrayaccess-object--arrayy-immutable)
    * [createFromObjectVars](#createfromobjectvarsobject-object--arrayy-immutable)
    * [createWithRange](#createwithrange--arrayy-immutable)
    * [createFromGeneratorImmutable](#createfromgeneratorimmutable--arrayy-immutable)
    * [createFromGeneratorFunction](#createfromgeneratorfunction--arrayy-immutable)
    * [createFromString](#createfromstringstring-str--arrayy-immutable)
* [Instance methods](#instance-methods)
    * ["set an array value"](#set-an-array-value)
    * ["set an array value via dot-notation"](#setmixed-key-mixed-value--arrayy-immutable)
    * ["get an array value"](#get-an-array-value)
    * ["get an array value via dot-notation"](#getstring-key-null-default-null-array--mixed)
    * ["get the array"](#get-the-array)
    * ["delete an array value"](#delete-an-array-value)
    * ["check if an array value is-set"](#check-if-an-array-value-is-set)
    * ["simple loop with an Arrayy-object"](#simple-loop-with-an-arrayy-object)
    * [overview](#arrayy-methods)
* [Tests](#tests)
* [License](#license)

## Installation via "composer require"
```shell
composer require voku/arrayy
```

## Multidimensional ArrayAccess

You can access / change the array via Object, Array or with "Arrayy"-syntax.

### Access via "Arrayy"-syntax: (dot-notation)

```php
$arrayy = new A(['Lars' => ['lastname' => 'Moelleken']]);

$arrayy->get('Lars'); // ['lastname' => 'Moelleken']
$arrayy->get('Lars.lastname'); // 'Moelleken'
```

### Access via "array"-syntax:

```php
$arrayy = new A(['Lars' => ['lastname' => 'Moelleken']]);

$arrayy['Lars'];             // ['lastname' => 'Moelleken']
$arrayy['Lars']['lastname']; // 'Moelleken'
```

### Access via "object"-syntax:

```php
$arrayy = new A(['Lars' => ['lastname' => 'Moelleken']]);

$arrayy->Lars; // Arrayy['lastname' => 'Moelleken']
$arrayy->Lars->lastname; // 'Moelleken'
```

### Set values via "Arrayy"-syntax: (dot-notation)

```php
$arrayy = new A(['Lars' => ['lastname' => 'Mueller']]);

$arrayy->set('Lars.lastname', 'Moelleken');
$arrayy->get('Lars.lastname'); // 'Moelleken'
```

### Set values via "array"-syntax:

```php
$arrayy = new A(['Lars' => ['lastname' => 'Moelleken']]);

$arrayy['Lars'] = array('lastname' => 'Müller');
$arrayy['Lars']['lastname']; // 'Müller'
```

### Set values via "object"-syntax:

```php
$arrayy = new A(['Lars' => ['lastname' => 'Moelleken']]);

$arrayy->Lars = array('lastname' => 'Müller');
$arrayy->Lars->lastname; // 'Müller'
```

## PhpDoc @property checking

The library offers a type checking for @property phpdoc-class-comments, as seen below:

```php
/**
 * @property int        $id
 * @property int|string $firstName
 * @property string     $lastName
 * @property null|City  $city
 *
 * @extends  \Arrayy\Arrayy<array-key,mixed>
 */
class User extends \Arrayy\Arrayy
{
  protected $checkPropertyTypes = true;

  protected $checkPropertiesMismatchInConstructor = true;
}

/**
 * @property string|null $plz
 * @property string      $name
 * @property string[]    $infos
 *
 * @extends  \Arrayy\Arrayy<array-key,mixed>
 */
class City extends \Arrayy\Arrayy
{
    protected $checkPropertyTypes = true;

    protected $checkPropertiesMismatchInConstructor = true;
}

$cityMeta = City::meta();
$city = new City(
    [
        $cityMeta->plz   => null,
        $cityMeta->name  => 'Düsseldorf',
        $cityMeta->infos => ['lall'],
    ]
);

$userMeta = User::meta();
$user = new User(
    [
        $userMeta->id        => 1,
        $userMeta->firstName => 'Lars',
        $userMeta->lastName  => 'Moelleken',
        $userMeta->city      => $city,
    ]
);

var_dump($user['lastName']); // 'Moelleken'
var_dump($user[$userMeta->lastName]); // 'Moelleken'
var_dump($user->lastName); // Moelleken

var_dump($user['city.name']); // 'Düsseldorf'
var_dump($user[$userMeta->city][$cityMeta->name]); // 'Düsseldorf'
var_dump($user->city->name); // Düsseldorf
```

- "checkPropertyTypes": activate the type checking for all defined @property in the class-phpdoc
- "checkPropertiesMismatchInConstructor": activate the property mismatch check, so you can only add an 
                                          array with all needed properties (or an empty array) into the constructor

## OO and Chaining

The library also offers OO method chaining, as seen below:

```php
echo a(['fòô', 'bàř', 'bàř'])->unique()->reverse()->implode(','); // 'bàř,fòô'
```

## Implemented Interfaces

`Arrayy\Arrayy` implements the `IteratorAggregate` interface, meaning that
`foreach` can be used with an instance of the class:

``` php
$arrayy = a(['fòôbàř', 'foo']);
foreach ($arrayy as $value) {
    echo $value;
}
// 'fòôbàř'
// 'foo'
```

It implements the `Countable` interface, enabling the use of `count()` to
retrieve the number of elements in the array:

``` php
$arrayy = a(['fòô', 'foo']);
count($arrayy);  // 2
```

## PHP 5.6 Creation

As of PHP 5.6, [`use function`](https://wiki.php.net/rfc/use_function) is
available for importing functions. Arrayy exposes a namespaced function,
`Arrayy\create`, which emits the same behaviour as `Arrayy\Arrayy::create()`.
If running PHP 5.6, or another runtime that supports the `use function` syntax,
you can take advantage of an even simpler API as seen below:

``` php
use function Arrayy\create as a;

// Instead of: A::create(['fòô', 'bàř'])->reverse()->implode();
a(['fòô', 'bàř'])->reverse()->implode(','); // 'bàř,fòô'
```

## Collections

If you need to group objects together, it's not a good idea 
to use a simple array or Arrayy object. For these cases you can use the ```AbstractCollection```
class.

It will throw a ```InvalidArgumentException``` if you try to add a non valid object into the collection.

e.g.: "YOURCollection.php" (see example ```/tests/CollectionTest.php``` on github)
```php
use Arrayy\Collection\AbstractCollection;

/**
 * @extends  AbstractCollection<array-key,YOURInterface>
 */
class YOURCollection extends AbstractCollection
{
    /**
     * The type (FQCN) associated with this collection.
     *
     * @return string
     */
    public function getType(): string
    {
        return YOURInterface::class;
    }
}

$YOURobject1 = new YOURClass();
$YOURobject2 = new YOURClass();

$YOURcollection = new YOURCollection($YOURobject1);
$YOURcollection->add($YOURobject2); // add one more object

// Or, you can use an array of objects.
//
// $YOURcollection = new YOURCollection([$YOURobject1, $YOURobject2]);

// Or, if you don't want to create new classes ... 
// ... and you don't need typehints and autocompletion via classes.
//
// $YOURcollection = \Arrayy\Collection::construct(YOURInterface::class, [$YOURobject1]);
// $YOURcollection->add($YOURobject2); // add one more object

// Or, if you don't like classes at all. ;-)
//
// $YOURcollection = \Arrayy\collection(YOURInterface::class, [$YOURobject1]);
// $YOURcollection->add($YOURobject2); // add one more object

foreach ($YOURcollection as $YOURobject) {
    if ($YOURobject instanceof YOURInterface) {
        // Do something with $YOURobject
    }
}
``` 

You can also use "dot-notation" to get data from your collections e.g.
```$YOURcollection->get('3123.foo.bar');```

## Pre-Defined Typified Collections

### simple example

This will throw a "TypeError"-Exception. 

```php
use Arrayy\Type\StringCollection;

$collection = new StringCollection(['A', 'B', 'C', 1]);
```

### complex example

This will NOT throw a "TypeError"-Exception. 

```php
use Arrayy\Type\IntCollection;
use Arrayy\Type\StringCollection;
use Arrayy\Type\InstancesCollection;
use Arrayy\Type\TypeInterface;

$collection = InstancesCollection::construct(
    TypeInterface::class,
    [new StringCollection(['A', 'B', 'C']), new IntCollection([1])]
);

$collection->toArray(true); // [['A', 'B', 'C'], [1]]
```

## Convert JSON-Data into Objects (Collection)

```php

namespace Arrayy\tests\Collection;

use Arrayy\Collection\AbstractCollection;

/**
 * @extends  AbstractCollection<array-key,\Arrayy\tests\UserData>
 */
class UserDataCollection extends AbstractCollection
{
    /**
     * The type (FQCN) associated with this collection.
     *
     * @return string
     */
    public function getType()
    {
        return \Arrayy\tests\UserData::class;
    }
}

$json = '[{"id":1,"firstName":"Lars","lastName":"Moelleken","city":{"name":"Düsseldorf","plz":null,"infos":["lall"]}}, {"id":1,"firstName":"Sven","lastName":"Moelleken","city":{"name":"Köln","plz":null,"infos":["foo"]}}]';
$userDataCollection = UserDataCollection::createFromJsonMapper($json);

/** @var \Arrayy\tests\UserData[] $userDatas */
$userDataCollection->getAll();

$userData0 = $userDataCollection[0];
echo $userData0->firstName; // 'Lars'
$userData0->city; // CityData::class
echo $userData0->city->name; // 'Düsseldorf'

$userData1 = $userDataCollection[1];
echo $userData1->firstName; // 'Sven'
$userData1->city; // CityData::class
echo $userData1->city->name; // 'Köln'
```

## Class methods

##### use a "default object" 

Creates an Arrayy object.

```php
$arrayy = new Arrayy(array('fòô', 'bàř')); // Arrayy['fòô', 'bàř']
```

##### create(array $array) : Arrayy (Immutable)

Creates an Arrayy object, via static "create()"-method

```php
$arrayy = A::create(array('fòô', 'bàř')); // Arrayy['fòô', 'bàř']
```

##### createByReference(array &$array) : Arrayy (Mutable)

WARNING: Creates an Arrayy object by reference.

```php
$array = array('fòô', 'bàř');
$arrayy = A::createByReference($array); // Arrayy['fòô', 'bàř']
```

##### createFromJson(string $json) : Arrayy (Immutable)

Create an new Arrayy object via JSON.

```php
$str = '{"firstName":"John", "lastName":"Doe"}';
$arrayy = A::createFromJson($str); // Arrayy['firstName' => 'John', 'lastName' => 'Doe']
```

##### createFromJsonMapper(string $json) : Arrayy (Immutable)

Create an new Arrayy object via JSON and fill sub-objects is possible.

```php
<?php

namespace Arrayy\tests;

/**
 * @property int                         $id
 * @property int|string                  $firstName
 * @property string                      $lastName
 * @property \Arrayy\tests\CityData|null $city
 *
 * @extends  \Arrayy\Arrayy<array-key,mixed>
 */
class UserData extends \Arrayy\Arrayy
{
    protected $checkPropertyTypes = true;

    protected $checkForMissingPropertiesInConstructor = true;
}

/**
 * @property string|null $plz
 * @property string      $name
 * @property string[]    $infos
 *
 * @extends  \Arrayy\Arrayy<array-key,mixed>
 */
class CityData extends \Arrayy\Arrayy
{
    protected $checkPropertyTypes = true;

    protected $checkPropertiesMismatchInConstructor = true;

    protected $checkForMissingPropertiesInConstructor = true;

    protected $checkPropertiesMismatch = true;
}

$json = '{"id":1,"firstName":"Lars","lastName":"Moelleken","city":{"name":"Düsseldorf","plz":null,"infos":["lall"]}}';
$userData = UserData::createFromJsonMapper($json);

$userData; // => \Arrayy\tests\UserData::class
echo $userData->firstName; // 'Lars' 
$userData->city; // => \Arrayy\tests\CityData::class
echo $userData->city->name; // 'Düsseldorf'
```

##### createFromObject(ArrayAccess $object) : Arrayy (Immutable)

Create an new instance filled with values from an object that have implemented ArrayAccess.

```php
$object = A::create(1, 'foo');
$arrayy = A::createFromObject($object); // Arrayy[1, 'foo']
```

##### createFromObjectVars(\object $object) : Arrayy (Immutable)

Create an new instance filled with values from an object.

```php
$object = new stdClass();
$object->x = 42;
$arrayy = A::createFromObjectVars($object); // Arrayy['x' => 42]
```

##### createWithRange() : Arrayy (Immutable)

Create an new instance containing a range of elements.

```php
$arrayy = A::createWithRange(2, 4); // Arrayy[2, 3, 4]
```

##### createFromGeneratorImmutable() : Arrayy (Immutable)

Create an new instance filled with a copy of values from a "Generator"-object.

WARNING: Need more memory then the "A::createFromGeneratorFunction()" call, because we
         will fetch and store all keys and values from the Generator.

```php
$generator = A::createWithRange(2, 4)->getGenerator();
$arrayy = A::createFromGeneratorImmutable($generator); // Arrayy[2, 3, 4]
```

##### createFromGeneratorFunction() : Arrayy (Immutable)

Create an new instance from a callable function which will return a Generator.

```php
$generatorFunction = static function() {
    yield from A::createWithRange(2, 4)->getArray();
};
$arrayy = A::createFromGeneratorFunction($generatorFunction); // Arrayy[2, 3, 4]
```

##### createFromString(string $str) : Arrayy (Immutable)

Create an new Arrayy object via string.

```php
$arrayy = A::createFromString(' foo, bar '); // Arrayy['foo', 'bar']
```

## Instance Methods

Arrayy: All examples below make use of PHP 5.6
function importing, and PHP 5.4 short array syntax. For further details,
see the documentation for the create method above, as well as the notes
on PHP 5.6 creation.

##### "set an array value"

```php
$arrayy = a(['fòô' => 'bàř']);
$arrayy['foo'] = 'bar';
var_dump($arrayy); // Arrayy['fòô' => 'bàř', 'foo' => 'bar']
```

##### "get an array value"

```php
$arrayy = a(['fòô' => 'bàř']);
var_dump($arrayy['fòô']); // 'bàř'
```

##### "get the array"

```php
$arrayy = a(['fòô' => 'bàř']);
var_dump($arrayy->getArray()); // ['fòô' => 'bàř']
```

##### "delete an array value"

```php
$arrayy = a(['fòô' => 'bàř', 'lall']);
unset($arrayy['fòô']);
var_dump($arrayy); // Arrayy[0 => 'lall']
```

##### "check if an array value is-set"

```php
$arrayy = a(['fòô' => 'bàř']);
isset($arrayy['fòô']); // true
```

##### "simple loop with an Arrayy-object"
 
```php
$arrayy = a(['fòô' => 'bàř']);
foreach ($arrayy) as $key => $value) {
  echo $key . ' | ' . $value; // fòô | bàř
}
```

## Arrayy methods

<p id="voku-php-readme-class-methods"></p><table><tr><td><a href="#addmixed-value-intstringnull-key-static">add</a>
</td><td><a href="#appendmixed-value-mixed-key-this">append</a>
</td><td><a href="#appendarrayvaluesarray-values-mixed-key-this">appendArrayValues</a>
</td><td><a href="#appendimmutablemixed-value-mixed-key-this">appendImmutable</a>
</td></tr><tr><td><a href="#appendtoeachkeyintstring-prefix-static">appendToEachKey</a>
</td><td><a href="#appendtoeachvaluefloatintstring-prefix-static">appendToEachValue</a>
</td><td><a href="#arsort-this">arsort</a>
</td><td><a href="#arsortimmutable-this">arsortImmutable</a>
</td></tr><tr><td><a href="#asortint-sort_flags-this">asort</a>
</td><td><a href="#asortimmutableint-sort_flags-this">asortImmutable</a>
</td><td><a href="#atclosure-closure-static">at</a>
</td><td><a href="#averageint-decimals-floatint">average</a>
</td></tr><tr><td><a href="#changekeycaseint-case-static">changeKeyCase</a>
</td><td><a href="#changeseparatorstring-separator-this">changeSeparator</a>
</td><td><a href="#chunkint-size-bool-preservekeys-static">chunk</a>
</td><td><a href="#clean-static">clean</a>
</td></tr><tr><td><a href="#clearintintstringstringnull-key-this">clear</a>
</td><td><a href="#containsfloatintstring-value-bool-recursive-bool-strict-bool">contains</a>
</td><td><a href="#containscaseinsensitivemixed-value-bool-recursive-bool">containsCaseInsensitive</a>
</td><td><a href="#containskeyintstring-key-bool">containsKey</a>
</td></tr><tr><td><a href="#containskeysarray-needles-bool-recursive-bool">containsKeys</a>
</td><td><a href="#containskeysrecursivearray-needles-bool">containsKeysRecursive</a>
</td><td><a href="#containsvaluefloatintstring-value-bool">containsValue</a>
</td><td><a href="#containsvaluerecursivefloatintstring-value-bool">containsValueRecursive</a>
</td></tr><tr><td><a href="#containsvaluesarray-needles-bool">containsValues</a>
</td><td><a href="#countint-mode-int">count</a>
</td><td><a href="#countvalues-static">countValues</a>
</td><td><a href="#createmixed-data-string-iteratorclass-bool-checkpropertiesinconstructor-static">create</a>
</td></tr><tr><td><a href="#createbyreferencearray-array-this">createByReference</a>
</td><td><a href="#createfromarrayarray-array-static">createFromArray</a>
</td><td><a href="#createfromgeneratorfunctioncallable-generatorfunction-static">createFromGeneratorFunction</a>
</td><td><a href="#createfromgeneratorimmutablegenerator-generator-static">createFromGeneratorImmutable</a>
</td></tr><tr><td><a href="#createfromjsonstring-json-static">createFromJson</a>
</td><td><a href="#createfromjsonmapperstring-json-this">createFromJsonMapper</a>
</td><td><a href="#createfromobjecttraversable-object-static">createFromObject</a>
</td><td><a href="#createfromobjectvarsobject-object-static">createFromObjectVars</a>
</td></tr><tr><td><a href="#createfromstringstring-str-stringnull-delimiter-stringnull-regex-static">createFromString</a>
</td><td><a href="#createfromtraversableimmutabletraversable-traversable-bool-use_keys-static">createFromTraversableImmutable</a>
</td><td><a href="#createwithrangefloatintstring-low-floatintstring-high-floatint-step-static">createWithRange</a>
</td><td><a href="#current-falsemixed">current</a>
</td></tr><tr><td><a href="#customsortkeyscallable-function-this">customSortKeys</a>
</td><td><a href="#customsortkeysimmutablecallable-function-this">customSortKeysImmutable</a>
</td><td><a href="#customsortvaluescallable-function-this">customSortValues</a>
</td><td><a href="#customsortvaluesimmutablecallable-function-this">customSortValuesImmutable</a>
</td></tr><tr><td><a href="#deleteintintstringstring-keyorkeys-void">delete</a>
</td><td><a href="#diffarray-array-static">diff</a>
</td><td><a href="#diffkeyarray-array-static">diffKey</a>
</td><td><a href="#diffkeyandvaluearray-array-static">diffKeyAndValue</a>
</td></tr><tr><td><a href="#diffrecursivearray-array-arraygeneratornull-helpervariableforrecursion-static">diffRecursive</a>
</td><td><a href="#diffreversearray-array-static">diffReverse</a>
</td><td><a href="#divide-static">divide</a>
</td><td><a href="#eachclosure-closure-static">each</a>
</td></tr><tr><td><a href="#end-falsemixed">end</a>
</td><td><a href="#exchangearrayarraymixedstatic-data-array">exchangeArray</a>
</td><td><a href="#existsclosure-closure-bool">exists</a>
</td><td><a href="#fillwithdefaultsint-num-mixed-default-static">fillWithDefaults</a>
</td></tr><tr><td><a href="#filterclosurenull-closure-int-flag-static">filter</a>
</td><td><a href="#filterbystring-property-mixed-value-stringnull-comparisonop-static">filterBy</a>
</td><td><a href="#findclosure-closure-falsemixed">find</a>
</td><td><a href="#findbystring-property-mixed-value-string-comparisonop-static">findBy</a>
</td></tr><tr><td><a href="#first-mixednull">first</a>
</td><td><a href="#firstkey-mixednull">firstKey</a>
</td><td><a href="#firstsimmutableintnull-number-static">firstsImmutable</a>
</td><td><a href="#firstskeysintnull-number-static">firstsKeys</a>
</td></tr><tr><td><a href="#firstsmutableintnull-number-this">firstsMutable</a>
</td><td><a href="#flattenstring-delimiter-string-prepend-arraynull-items-array">flatten</a>
</td><td><a href="#flip-static">flip</a>
</td><td><a href="#getintstring-key-mixed-fallback-arraynull-array-bool-usebyreference-mixedstatic">get</a>
</td></tr><tr><td><a href="#getall-array">getAll</a>
</td><td><a href="#getarraybool-convertallarrayyelements-bool-preservekeys-array">getArray</a>
</td><td><a href="#getarraycopy-array">getArrayCopy</a>
</td><td><a href="#getcolumnintstringnull-columnkey-intstringnull-indexkey-static">getColumn</a>
</td></tr><tr><td><a href="#getgenerator-generator">getGenerator</a>
</td><td><a href="#getgeneratorbyreference-generator">getGeneratorByReference</a>
</td><td><a href="#getiterator-iteratormixedmixed">getIterator</a>
</td><td><a href="#getiteratorclass-string">getIteratorClass</a>
</td></tr><tr><td><a href="#getkeys-static">getKeys</a>
</td><td><a href="#getlistbool-convertallarrayyelements-array">getList</a>
</td><td><a href="#getobject-stdclass">getObject</a>
</td><td><a href="#getphpdocpropertiesfromclass">getPhpDocPropertiesFromClass</a>
</td></tr><tr><td><a href="#getrandom-static">getRandom</a>
</td><td><a href="#getrandomkey-nullmixed">getRandomKey</a>
</td><td><a href="#getrandomkeysint-number-static">getRandomKeys</a>
</td><td><a href="#getrandomvalue-nullmixed">getRandomValue</a>
</td></tr><tr><td><a href="#getrandomvaluesint-number-static">getRandomValues</a>
</td><td><a href="#getvalues-static">getValues</a>
</td><td><a href="#getvaluesyield-generator">getValuesYield</a>
</td><td><a href="#groupcallablestring-grouper-bool-savekeys-static">group</a>
</td></tr><tr><td><a href="#hasmixed-key-bool">has</a>
</td><td><a href="#hasvaluemixed-value-bool">hasValue</a>
</td><td><a href="#implodestring-glue-string-prefix-string">implode</a>
</td><td><a href="#implodekeysstring-glue-string">implodeKeys</a>
</td></tr><tr><td><a href="#indexbyintstring-key-static">indexBy</a>
</td><td><a href="#indexofmixed-value-falseintstring">indexOf</a>
</td><td><a href="#initialint-to-static">initial</a>
</td><td><a href="#intersectionarray-search-bool-keepkeys-static">intersection</a>
</td></tr><tr><td><a href="#intersectionmultiarray-array-static">intersectionMulti</a>
</td><td><a href="#intersectsarray-search-bool">intersects</a>
</td><td><a href="#invokecallable-callable-mixed-arguments-static">invoke</a>
</td><td><a href="#isassocbool-recursive-bool">isAssoc</a>
</td></tr><tr><td><a href="#isemptyintintstringstringnull-keys-bool">isEmpty</a>
</td><td><a href="#isequalarray-array-bool">isEqual</a>
</td><td><a href="#ismultiarray-bool">isMultiArray</a>
</td><td><a href="#isnumeric-bool">isNumeric</a>
</td></tr><tr><td><a href="#issequentialbool-recursive-bool">isSequential</a>
</td><td><a href="#jsonserialize-array">jsonSerialize</a>
</td><td><a href="#key-intstringnull">key</a>
</td><td><a href="#keyexistsintstring-key-bool">keyExists</a>
</td></tr><tr><td><a href="#keysbool-recursive-mixednull-search_values-bool-strict-static">keys</a>
</td><td><a href="#krsortint-sort_flags-this">krsort</a>
</td><td><a href="#krsortimmutableint-sort_flags-this">krsortImmutable</a>
</td><td><a href="#ksortint-sort_flags-this">ksort</a>
</td></tr><tr><td><a href="#ksortimmutableint-sort_flags-this">ksortImmutable</a>
</td><td><a href="#last-mixednull">last</a>
</td><td><a href="#lastkey-mixednull">lastKey</a>
</td><td><a href="#lastsimmutableintnull-number-static">lastsImmutable</a>
</td></tr><tr><td><a href="#lastsmutableintnull-number-this">lastsMutable</a>
</td><td><a href="#lengthint-mode-int">length</a>
</td><td><a href="#mapcallable-callable-bool-usekeyassecondparameter-mixed-arguments-static">map</a>
</td><td><a href="#matchesclosure-closure-bool">matches</a>
</td></tr><tr><td><a href="#matchesanyclosure-closure-bool">matchesAny</a>
</td><td><a href="#max-falsefloatintstring">max</a>
</td><td><a href="#mergeappendkeepindexarray-array-bool-recursive-static">mergeAppendKeepIndex</a>
</td><td><a href="#mergeappendnewindexarray-array-bool-recursive-static">mergeAppendNewIndex</a>
</td></tr><tr><td><a href="#mergeprependkeepindexarray-array-bool-recursive-static">mergePrependKeepIndex</a>
</td><td><a href="#mergeprependnewindexarray-array-bool-recursive-static">mergePrependNewIndex</a>
</td><td><a href="#meta-arrayymetamixedstatic">meta</a>
</td><td><a href="#min-falsemixed">min</a>
</td></tr><tr><td><a href="#mostusedvalue-mixednull">mostUsedValue</a>
</td><td><a href="#mostusedvaluesintnull-number-static">mostUsedValues</a>
</td><td><a href="#moveelementintstring-from-int-to-static">moveElement</a>
</td><td><a href="#moveelementtofirstplaceintstring-key-static">moveElementToFirstPlace</a>
</td></tr><tr><td><a href="#moveelementtolastplaceintstring-key-static">moveElementToLastPlace</a>
</td><td><a href="#natcasesort-this">natcasesort</a>
</td><td><a href="#natcasesortimmutable-this">natcasesortImmutable</a>
</td><td><a href="#natsort-this">natsort</a>
</td></tr><tr><td><a href="#natsortimmutable-this">natsortImmutable</a>
</td><td><a href="#next-falsemixed">next</a>
</td><td><a href="#nthint-step-int-offset-static">nth</a>
</td><td><a href="#offsetexistsboolintstring-offset-bool">offsetExists</a>
</td></tr><tr><td><a href="#offsetgetintstring-offset-mixed">offsetGet</a>
</td><td><a href="#offsetsetintstringnull-offset-mixed-value-void">offsetSet</a>
</td><td><a href="#offsetunsetintstring-offset-void">offsetUnset</a>
</td><td><a href="#onlyintstring-keys-static">only</a>
</td></tr><tr><td><a href="#padint-size-mixed-value-static">pad</a>
</td><td><a href="#partitionclosure-closure-arrayintstatic">partition</a>
</td><td><a href="#pop-mixednull">pop</a>
</td><td><a href="#prependmixed-value-mixed-key-this">prepend</a>
</td></tr><tr><td><a href="#prependimmutablemixed-value-mixed-key-this">prependImmutable</a>
</td><td><a href="#prependtoeachkeyfloatintstring-suffix-static">prependToEachKey</a>
</td><td><a href="#prependtoeachvaluefloatintstring-suffix-static">prependToEachValue</a>
</td><td><a href="#pullintintstringstringnull-keyorkeys-mixed-fallback-mixed">pull</a>
</td></tr><tr><td><a href="#pushmixed-args-this">push</a>
</td><td><a href="#randomimmutableintnull-number-static">randomImmutable</a>
</td><td><a href="#randomkey-nullmixed">randomKey</a>
</td><td><a href="#randomkeysint-number-static">randomKeys</a>
</td></tr><tr><td><a href="#randommutableintnull-number-this">randomMutable</a>
</td><td><a href="#randomvalue-mixed">randomValue</a>
</td><td><a href="#randomvaluesint-number-static">randomValues</a>
</td><td><a href="#randomweightedarray-array-int-number">randomWeighted</a>
</td></tr><tr><td><a href="#reducecallable-callable-mixed-initial-static">reduce</a>
</td><td><a href="#reduce_dimensionbool-unique-static">reduce_dimension</a>
</td><td><a href="#reindex-this">reindex</a>
</td><td><a href="#rejectclosure-closure-static">reject</a>
</td></tr><tr><td><a href="#removemixed-key-static">remove</a>
</td><td><a href="#removeelementmixed-element-static">removeElement</a>
</td><td><a href="#removefirst-static">removeFirst</a>
</td><td><a href="#removelast-static">removeLast</a>
</td></tr><tr><td><a href="#removevaluemixed-value-static">removeValue</a>
</td><td><a href="#repeatint-times-static">repeat</a>
</td><td><a href="#replacemixed-oldkey-mixed-newkey-mixed-newvalue-static">replace</a>
</td><td><a href="#replaceallkeysintstring-keys-static">replaceAllKeys</a>
</td></tr><tr><td><a href="#replaceallvaluesarray-array-static">replaceAllValues</a>
</td><td><a href="#replacekeysarray-keys-static">replaceKeys</a>
</td><td><a href="#replaceonevaluemixed-search-mixed-replacement-static">replaceOneValue</a>
</td><td><a href="#replacevaluesstring-search-string-replacement-static">replaceValues</a>
</td></tr><tr><td><a href="#restint-from-static">rest</a>
</td><td><a href="#reverse-this">reverse</a>
</td><td><a href="#rsortint-sort_flags-this">rsort</a>
</td><td><a href="#rsortimmutableint-sort_flags-this">rsortImmutable</a>
</td></tr><tr><td><a href="#searchindexmixed-value-falseintstring">searchIndex</a>
</td><td><a href="#searchvaluemixed-index-static">searchValue</a>
</td><td><a href="#serialize-string">serialize</a>
</td><td><a href="#setstring-key-mixed-value-this">set</a>
</td></tr><tr><td><a href="#setandgetmixed-key-mixed-fallback-mixed">setAndGet</a>
</td><td><a href="#setiteratorclassstring-iteratorclass-void">setIteratorClass</a>
</td><td><a href="#shift-mixed">shift</a>
</td><td><a href="#shufflebool-secure-arraynull-array-static">shuffle</a>
</td></tr><tr><td><a href="#sizeint-mode-int">size</a>
</td><td><a href="#sizeisint-size-bool">sizeIs</a>
</td><td><a href="#sizeisbetweenint-fromsize-int-tosize-bool">sizeIsBetween</a>
</td><td><a href="#sizeisgreaterthanint-size-bool">sizeIsGreaterThan</a>
</td></tr><tr><td><a href="#sizeislessthanint-size-bool">sizeIsLessThan</a>
</td><td><a href="#sizerecursive-int">sizeRecursive</a>
</td><td><a href="#sliceint-offset-intnull-length-bool-preservekeys-static">slice</a>
</td><td><a href="#sortintstring-direction-int-strategy-bool-keepkeys-static">sort</a>
</td></tr><tr><td><a href="#sortimmutableintstring-direction-int-strategy-bool-keepkeys-static">sortImmutable</a>
</td><td><a href="#sortkeysintstring-direction-int-strategy-this">sortKeys</a>
</td><td><a href="#sortkeysimmutableintstring-direction-int-strategy-this">sortKeysImmutable</a>
</td><td><a href="#sortvaluekeepindexintstring-direction-int-strategy-static">sortValueKeepIndex</a>
</td></tr><tr><td><a href="#sortvaluenewindexintstring-direction-int-strategy-static">sortValueNewIndex</a>
</td><td><a href="#sortercallablemixednull-sorter-intstring-direction-int-strategy-static">sorter</a>
</td><td><a href="#spliceint-offset-intnull-length-array-replacement-static">splice</a>
</td><td><a href="#splitint-numberofpieces-bool-keepkeys-static">split</a>
</td></tr><tr><td><a href="#stripempty-static">stripEmpty</a>
</td><td><a href="#swapintstring-swapa-intstring-swapb-static">swap</a>
</td><td><a href="#toarraybool-convertallarrayyelements-bool-preservekeys-array">toArray</a>
</td><td><a href="#tojsonint-options-int-depth-string">toJson</a>
</td></tr><tr><td><a href="#tolistbool-convertallarrayyelements-array">toList</a>
</td><td><a href="#topermutationstringnull-items-string-helper-staticstatic">toPermutation</a>
</td><td><a href="#tostringstring-separator-string">toString</a>
</td><td><a href="#uasortcallable-function-this">uasort</a>
</td></tr><tr><td><a href="#uasortimmutablecallable-function-this">uasortImmutable</a>
</td><td><a href="#uksortcallable-function-static">uksort</a>
</td><td><a href="#uksortimmutablecallable-function-static">uksortImmutable</a>
</td><td><a href="#unique-static">unique</a>
</td></tr><tr><td><a href="#uniquekeepindex-this">uniqueKeepIndex</a>
</td><td><a href="#uniquenewindex-this">uniqueNewIndex</a>
</td><td><a href="#unserializestring-string-this">unserialize</a>
</td><td><a href="#unshiftmixed-args-this">unshift</a>
</td></tr><tr><td><a href="#validateclosure-closure-bool">validate</a>
</td><td><a href="#values-static">values</a>
</td><td><a href="#walkcallable-callable-bool-recursive-mixed-userdata-this">walk</a>
</td><td><a href="#wherestring-keyorpropertyormethod-mixed-value-static">where</a>
</td></tr></table>

## add(mixed $value, int|string|null $key): static
<a href="#voku-php-readme-class-methods">↑</a>
Add new values (optional using dot-notation).

**Parameters:**
- `T $value`
- `TKey $key`

**Return:**
- `static <p>(Immutable) Return this Arrayy object, with the appended values.</p>`

--------

## append(mixed $value, mixed $key): $this
<a href="#voku-php-readme-class-methods">↑</a>
Append a (key) + value to the current array.

EXAMPLE: <code>
a(['fòô' => 'bàř'])->append('foo'); // Arrayy['fòô' => 'bàř', 0 => 'foo']
</code>

**Parameters:**
- `T $value`
- `TKey|null $key`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object, with the appended values.</p>`

--------

## appendArrayValues(array $values, mixed $key): $this
<a href="#voku-php-readme-class-methods">↑</a>
Append a (key) + values to the current array.

EXAMPLE: <code>
a(['fòô' => ['bàř']])->appendArrayValues(['foo1', 'foo2'], 'fòô'); // Arrayy['fòô' => ['bàř', 'foo1', 'foo2']]
</code>

**Parameters:**
- `array<array-key, T> $values`
- `TKey|null $key`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object, with the appended values.</p>`

--------

## appendImmutable(mixed $value, mixed $key): $this
<a href="#voku-php-readme-class-methods">↑</a>
Append a (key) + value to the current array.

EXAMPLE: <code>
a(['fòô' => 'bàř'])->appendImmutable('foo')->getArray(); // ['fòô' => 'bàř', 0 => 'foo']
</code>

**Parameters:**
- `T $value`
- `TKey $key`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object, with the appended values.</p>`

--------

## appendToEachKey(int|string $prefix): static
<a href="#voku-php-readme-class-methods">↑</a>
Add a suffix to each key.

**Parameters:**
- `int|string $prefix`

**Return:**
- `static <p>(Immutable) Return an Arrayy object, with the prefixed keys.</p>`

--------

## appendToEachValue(float|int|string $prefix): static
<a href="#voku-php-readme-class-methods">↑</a>
Add a prefix to each value.

**Parameters:**
- `float|int|string $prefix`

**Return:**
- `static <p>(Immutable) Return an Arrayy object, with the prefixed values.</p>`

--------

## arsort(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort an array in reverse order and maintain index association.

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## arsortImmutable(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort an array in reverse order and maintain index association.

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## asort(int $sort_flags): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort the entries by value.

**Parameters:**
- `int $sort_flags [optional] <p>
You may modify the behavior of the sort using the optional
parameter sort_flags, for details
see sort.
</p>`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## asortImmutable(int $sort_flags): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort the entries by value.

**Parameters:**
- `int $sort_flags [optional] <p>
You may modify the behavior of the sort using the optional
parameter sort_flags, for details
see sort.
</p>`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## at(\Closure $closure): static
<a href="#voku-php-readme-class-methods">↑</a>
Iterate over the current array and execute a callback for each loop.

EXAMPLE: <code>
$result = A::create();
$closure = function ($value, $key) use ($result) {
    $result[$key] = ':' . $value . ':';
};
a(['foo', 'bar' => 'bis'])->at($closure); // Arrayy[':foo:', 'bar' => ':bis:']
</code>

**Parameters:**
- `\Closure $closure`

**Return:**
- `static <p>(Immutable)</p>`

--------

## average(int $decimals): float|int
<a href="#voku-php-readme-class-methods">↑</a>
Returns the average value of the current array.

EXAMPLE: <code>
a([-9, -8, -7, 1.32])->average(2); // -5.67
</code>

**Parameters:**
- `int $decimals <p>The number of decimal-numbers to return.</p>`

**Return:**
- `float|int <p>The average value.</p>`

--------

## changeKeyCase(int $case): static
<a href="#voku-php-readme-class-methods">↑</a>
Changes all keys in an array.

**Parameters:**
- `int $case [optional] <p> Either <strong>CASE_UPPER</strong><br />
or <strong>CASE_LOWER</strong> (default)</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## changeSeparator(string $separator): $this
<a href="#voku-php-readme-class-methods">↑</a>
Change the path separator of the array wrapper.

By default, the separator is: "."

**Parameters:**
- `string $separator <p>Separator to set.</p>`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## chunk(int $size, bool $preserveKeys): static
<a href="#voku-php-readme-class-methods">↑</a>
Create a chunked version of the current array.

EXAMPLE: <code>
a([-9, -8, -7, 1.32])->chunk(2); // Arrayy[[-9, -8], [-7, 1.32]]
</code>

**Parameters:**
- `int $size <p>Size of each chunk.</p>`
- `bool $preserveKeys <p>Whether array keys are preserved or no.</p>`

**Return:**
- `static <p>(Immutable) A new array of chunks from the original array.</p>`

--------

## clean(): static
<a href="#voku-php-readme-class-methods">↑</a>
Clean all falsy values from the current array.

EXAMPLE: <code>
a([-8 => -9, 1, 2 => false])->clean(); // Arrayy[-8 => -9, 1]
</code>

**Parameters:**
__nothing__

**Return:**
- `static <p>(Immutable)</p>`

--------

## clear(int|int[]|string|string[]|null $key): $this
<a href="#voku-php-readme-class-methods">↑</a>
WARNING!!! -> Clear the current full array or a $key of it.

EXAMPLE: <code>
a([-8 => -9, 1, 2 => false])->clear(); // Arrayy[]
</code>

**Parameters:**
- `int|int[]|string|string[]|null $key`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object, with an empty array.</p>`

--------

## contains(float|int|string $value, bool $recursive, bool $strict): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if an item is in the current array.

EXAMPLE: <code>
a([1, true])->contains(true); // true
</code>

**Parameters:**
- `float|int|string $value`
- `bool $recursive`
- `bool $strict`

**Return:**
- `bool`

--------

## containsCaseInsensitive(mixed $value, bool $recursive): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if an (case-insensitive) string is in the current array.

EXAMPLE: <code>
a(['E', 'é'])->containsCaseInsensitive('É'); // true
</code>

**Parameters:**
- `mixed $value`
- `bool $recursive`

**Return:**
- `bool`

--------

## containsKey(int|string $key): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if the given key/index exists in the array.

EXAMPLE: <code>
a([1 => true])->containsKey(1); // true
</code>

**Parameters:**
- `int|string $key <p>key/index to search for</p>`

**Return:**
- `bool <p>Returns true if the given key/index exists in the array, false otherwise.</p>`

--------

## containsKeys(array $needles, bool $recursive): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if all given needles are present in the array as key/index.

EXAMPLE: <code>
a([1 => true])->containsKeys(array(1 => 0)); // true
</code>

**Parameters:**
- `array<array-key>|array<TKey> $needles <p>The keys you are searching for.</p>`
- `bool $recursive`

**Return:**
- `bool <p>Returns true if all the given keys/indexes exists in the array, false otherwise.</p>`

--------

## containsKeysRecursive(array $needles): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if all given needles are present in the array as key/index.

**Parameters:**
- `array<array-key>|array<TKey> $needles <p>The keys you are searching for.</p>`

**Return:**
- `bool <p>Returns true if all the given keys/indexes exists in the array, false otherwise.</p>`

--------

## containsValue(float|int|string $value): bool
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->contains()"

**Parameters:**
- `float|int|string $value`

**Return:**
- `bool`

--------

## containsValueRecursive(float|int|string $value): bool
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->contains($value, true)"

**Parameters:**
- `float|int|string $value`

**Return:**
- `bool`

--------

## containsValues(array $needles): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if all given needles are present in the array.

EXAMPLE: <code>
a([1, true])->containsValues(array(1, true)); // true
</code>

**Parameters:**
- `array<mixed>|array<T> $needles`

**Return:**
- `bool <p>Returns true if all the given values exists in the array, false otherwise.</p>`

--------

## count(int $mode): int
<a href="#voku-php-readme-class-methods">↑</a>
Counts all elements in an array, or something in an object.

EXAMPLE: <code>
a([-9, -8, -7, 1.32])->count(); // 4
</code>

<p>
For objects, if you have SPL installed, you can hook into count() by implementing interface {@see \Countable}.
The interface has exactly one method, {@see \Countable::count()}, which returns the return value for the count()
function. Please see the {@see \Array} section of the manual for a detailed explanation of how arrays are
implemented and used in PHP.
</p>

**Parameters:**
- `int $mode [optional] If the optional mode parameter is set to
COUNT_RECURSIVE (or 1), count
will recursively count the array. This is particularly useful for
counting all the elements of a multidimensional array. count does not detect infinite recursion.`

**Return:**
- `int <p>
The number of elements in var, which is
typically an array, since anything else will have one
element.
</p>
<p>
If var is not an array or an object with
implemented Countable interface,
1 will be returned.
There is one exception, if var is &null;,
0 will be returned.
</p>
<p>
Caution: count may return 0 for a variable that isn't set,
but it may also return 0 for a variable that has been initialized with an
empty array. Use isset to test if a variable is set.
</p>`

--------

## countValues(): static
<a href="#voku-php-readme-class-methods">↑</a>
Counts all the values of an array

**Parameters:**
__nothing__

**Return:**
- `static <p>
(Immutable)
An associative Arrayy-object of values from input as
keys and their count as value.
</p>`

--------

## create(mixed $data, string $iteratorClass, bool $checkPropertiesInConstructor): static
<a href="#voku-php-readme-class-methods">↑</a>
Creates an Arrayy object.

**Parameters:**
- `mixed $data`
- `class-string<\Arrayy\ArrayyIterator> $iteratorClass`
- `bool $checkPropertiesInConstructor`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## createByReference(array $array): $this
<a href="#voku-php-readme-class-methods">↑</a>
WARNING: Creates an Arrayy object by reference.

**Parameters:**
- `array<TKey, T> $array`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## createFromArray(array $array): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an new Arrayy object via JSON.

**Parameters:**
- `array<TKey, T> $array`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## createFromGeneratorFunction(callable $generatorFunction): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an new instance from a callable function which will return an Generator.

**Parameters:**
- `callable(): \Generator<TKey, T> $generatorFunction`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## createFromGeneratorImmutable(\Generator $generator): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an new instance filled with a copy of values from a "Generator"-object.

**Parameters:**
- `\Generator<TKey, T> $generator`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## createFromJson(string $json): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an new Arrayy object via JSON.

**Parameters:**
- `string $json`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## createFromJsonMapper(string $json): $this
<a href="#voku-php-readme-class-methods">↑</a>


**Parameters:**
- `string $json`

**Return:**
- `$this`

--------

## createFromObject(\Traversable $object): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an new instance filled with values from an object that is iterable.

**Parameters:**
- `\Traversable<array-key, T> $object <p>iterable object</p>`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## createFromObjectVars(object $object): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an new instance filled with values from an object.

**Parameters:**
- `object $object`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## createFromString(string $str, string|null $delimiter, string|null $regEx): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an new Arrayy object via string.

**Parameters:**
- `string $str <p>The input string.</p>`
- `string|null $delimiter <p>The boundary string.</p>`
- `string|null $regEx <p>Use the $delimiter or the $regEx, so if $pattern is null, $delimiter will be
used.</p>`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## createFromTraversableImmutable(\Traversable $traversable, bool $use_keys): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an new instance filled with a copy of values from a "Traversable"-object.

**Parameters:**
- `\Traversable<(array-key|TKey), T> $traversable`
- `bool $use_keys [optional] <p>
Whether to use the iterator element keys as index.
</p>`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## createWithRange(float|int|string $low, float|int|string $high, float|int $step): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an new instance containing a range of elements.

**Parameters:**
- `float|int|string $low <p>First value of the sequence.</p>`
- `float|int|string $high <p>The sequence is ended upon reaching the end value.</p>`
- `float|int $step <p>Used as the increment between elements in the sequence.</p>`

**Return:**
- `static <p>(Immutable) Returns an new instance of the Arrayy object.</p>`

--------

## current(): false|mixed
<a href="#voku-php-readme-class-methods">↑</a>
Gets the element of the array at the current internal iterator position.

**Parameters:**
__nothing__

**Return:**
- `false|mixed`

--------

## customSortKeys(callable $function): $this
<a href="#voku-php-readme-class-methods">↑</a>
Custom sort by index via "uksort".

EXAMPLE: <code>
$callable = function ($a, $b) {
    if ($a == $b) {
        return 0;
    }
    return ($a > $b) ? 1 : -1;
};
$arrayy = a(['three' => 3, 'one' => 1, 'two' => 2]);
$resultArrayy = $arrayy->customSortKeys($callable); // Arrayy['one' => 1, 'three' => 3, 'two' => 2]
</code>

**Parameters:**
- `callable $function`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## customSortKeysImmutable(callable $function): $this
<a href="#voku-php-readme-class-methods">↑</a>
Custom sort by index via "uksort".

**Parameters:**
- `callable $function`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## customSortValues(callable $function): $this
<a href="#voku-php-readme-class-methods">↑</a>
Custom sort by value via "usort".

EXAMPLE: <code>
$callable = function ($a, $b) {
    if ($a == $b) {
        return 0;
    }
    return ($a > $b) ? 1 : -1;
};
$arrayy = a(['three' => 3, 'one' => 1, 'two' => 2]);
$resultArrayy = $arrayy->customSortValues($callable); // Arrayy['one' => 1, 'two' => 2, 'three' => 3]
</code>

**Parameters:**
- `callable $function`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## customSortValuesImmutable(callable $function): $this
<a href="#voku-php-readme-class-methods">↑</a>
Custom sort by value via "usort".

**Parameters:**
- `callable $function`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## delete(int|int[]|string|string[] $keyOrKeys): void
<a href="#voku-php-readme-class-methods">↑</a>
Delete the given key or keys.

**Parameters:**
- `int|int[]|string|string[] $keyOrKeys`

**Return:**
- `void`

--------

## diff(array $array): static
<a href="#voku-php-readme-class-methods">↑</a>
Return elements where the values that are only in the current array.

EXAMPLE: <code>
a([1 => 1, 2 => 2])->diff([1 => 1]); // Arrayy[2 => 2]
</code>

**Parameters:**
- `array<TKey, T> ...$array`

**Return:**
- `static <p>(Immutable)</p>`

--------

## diffKey(array $array): static
<a href="#voku-php-readme-class-methods">↑</a>
Return elements where the keys are only in the current array.

**Parameters:**
- `array<TKey, T> ...$array`

**Return:**
- `static <p>(Immutable)</p>`

--------

## diffKeyAndValue(array $array): static
<a href="#voku-php-readme-class-methods">↑</a>
Return elements where the values and keys are only in the current array.

**Parameters:**
- `array<TKey, T> ...$array`

**Return:**
- `static <p>(Immutable)</p>`

--------

## diffRecursive(array $array, array|\Generator|null $helperVariableForRecursion): static
<a href="#voku-php-readme-class-methods">↑</a>
Return elements where the values are only in the current multi-dimensional array.

EXAMPLE: <code>
a([1 => [1 => 1], 2 => [2 => 2]])->diffRecursive([1 => [1 => 1]]); // Arrayy[2 => [2 => 2]]
</code>

**Parameters:**
- `array<TKey, T> $array`
- `null|array<TKey, T>|\Generator<TKey, T> $helperVariableForRecursion <p>(only for internal usage)</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## diffReverse(array $array): static
<a href="#voku-php-readme-class-methods">↑</a>
Return elements where the values that are only in the new $array.

EXAMPLE: <code>
a([1 => 1])->diffReverse([1 => 1, 2 => 2]); // Arrayy[2 => 2]
</code>

**Parameters:**
- `array<TKey, T> $array`

**Return:**
- `static <p>(Immutable)</p>`

--------

## divide(): static
<a href="#voku-php-readme-class-methods">↑</a>
Divide an array into two arrays. One with keys and the other with values.

EXAMPLE: <code>
a(['a' => 1, 'b' => ''])->divide(); // Arrayy[Arrayy['a', 'b'], Arrayy[1, '']]
</code>

**Parameters:**
__nothing__

**Return:**
- `static <p>(Immutable)</p>`

--------

## each(\Closure $closure): static
<a href="#voku-php-readme-class-methods">↑</a>
Iterate over the current array and modify the array's value.

EXAMPLE: <code>
$result = A::create();
$closure = function ($value) {
    return ':' . $value . ':';
};
a(['foo', 'bar' => 'bis'])->each($closure); // Arrayy[':foo:', 'bar' => ':bis:']
</code>

**Parameters:**
- `\Closure(T  = default): T|\Closure(T  = default, TKey  = default): T $closure`

**Return:**
- `static <p>(Immutable)</p>`

--------

## end(): false|mixed
<a href="#voku-php-readme-class-methods">↑</a>
Sets the internal iterator to the last element in the array and returns this element.

**Parameters:**
__nothing__

**Return:**
- `false|mixed`

--------

## exchangeArray(array|mixed|static $data): array
<a href="#voku-php-readme-class-methods">↑</a>
Exchange the array for another one.

**Parameters:**
- `T|array<TKey, T>|self<TKey, T> $data 1. use the current array, if it's a array
2. fallback to empty array, if there is nothing
3. call "getArray()" on object, if there is a "Arrayy"-object
4. call "createFromObject()" on object, if there is a "\Traversable"-object
5. call "__toArray()" on object, if the method exists
6. cast a string or object with "__toString()" into an array
7. throw a "InvalidArgumentException"-Exception`

**Return:**
- `array`

--------

## exists(\Closure $closure): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if a value is in the current array using a closure.

EXAMPLE: <code>
$callable = function ($value, $key) {
    return 2 === $key and 'two' === $value;
};
a(['foo', 2 => 'two'])->exists($callable); // true
</code>

**Parameters:**
- `\Closure(T  = default, TKey  = default): bool $closure`

**Return:**
- `bool <p>Returns true if the given value is found, false otherwise.</p>`

--------

## fillWithDefaults(int $num, mixed $default): static
<a href="#voku-php-readme-class-methods">↑</a>
Fill the array until "$num" with "$default" values.

EXAMPLE: <code>
a(['bar'])->fillWithDefaults(3, 'foo'); // Arrayy['bar', 'foo', 'foo']
</code>

**Parameters:**
- `int $num`
- `T $default`

**Return:**
- `static <p>(Immutable)</p>`

--------

## filter(\Closure|null $closure, int $flag): static
<a href="#voku-php-readme-class-methods">↑</a>
Find all items in an array that pass the truth test.

EXAMPLE: <code>
$closure = function ($value) {
    return $value % 2 !== 0;
}
a([1, 2, 3, 4])->filter($closure); // Arrayy[0 => 1, 2 => 3]
</code>

**Parameters:**
- `null|\Closure(T  = default, TKey  = default): bool|\Closure(T  = default): bool|\Closure(TKey  = default): bool $closure [optional] <p>
The callback function to use
</p>
<p>
If no callback is supplied, all entries of
input equal to false (see
converting to
boolean) will be removed.
</p>`
- `int $flag [optional] <p>
Flag determining what arguments are sent to <i>callback</i>:
</p>
<ul>
<li>
<b>ARRAY_FILTER_USE_KEY</b> (1) - pass key as the only argument
to <i>callback</i> instead of the value
</li>
<li>
<b>ARRAY_FILTER_USE_BOTH</b> (2) - pass both value and key as
arguments to <i>callback</i> instead of the value
</li>
</ul>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## filterBy(string $property, mixed $value, string|null $comparisonOp): static
<a href="#voku-php-readme-class-methods">↑</a>
Filters an array of objects (or a numeric array of associative arrays) based on the value of a particular
property within that.

**Parameters:**
- `string $property`
- `array|T $value`
- `string|null $comparisonOp <p>
'eq' (equals),<br />
'gt' (greater),<br />
'gte' || 'ge' (greater or equals),<br />
'lt' (less),<br />
'lte' || 'le' (less or equals),<br />
'ne' (not equals),<br />
'contains',<br />
'notContains',<br />
'newer' (via strtotime),<br />
'older' (via strtotime),<br />
</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## find(\Closure $closure): false|mixed
<a href="#voku-php-readme-class-methods">↑</a>
Find the first item in an array that passes the truth test, otherwise return false.

EXAMPLE: <code>
$search = 'foo';
$closure = function ($value, $key) use ($search) {
    return $value === $search;
};
a(['foo', 'bar', 'lall'])->find($closure); // 'foo'
</code>

**Parameters:**
- `\Closure(T  = default, TKey  = default): bool $closure`

**Return:**
- `false|mixed <p>Return false if we did not find the value.</p>`

--------

## findBy(string $property, mixed $value, string $comparisonOp): static
<a href="#voku-php-readme-class-methods">↑</a>
find by .

..

EXAMPLE: <code>
$array = [
    0 => ['id' => 123, 'name' => 'foo', 'group' => 'primary', 'value' => 123456, 'when' => '2014-01-01'],
    1 => ['id' => 456, 'name' => 'bar', 'group' => 'primary', 'value' => 1468, 'when' => '2014-07-15'],
];
a($array)->filterBy('name', 'foo'); // Arrayy[0 => ['id' => 123, 'name' => 'foo', 'group' => 'primary', 'value' => 123456, 'when' => '2014-01-01']]
</code>

**Parameters:**
- `string $property`
- `array|T $value`
- `string $comparisonOp`

**Return:**
- `static <p>(Immutable)</p>`

--------

## first(): mixed|null
<a href="#voku-php-readme-class-methods">↑</a>
Get the first value from the current array.

EXAMPLE: <code>
a([2 => 'foo', 3 => 'bar', 4 => 'lall'])->first(); // 'foo'
</code>

**Parameters:**
__nothing__

**Return:**
- `mixed|null <p>Return null if there wasn't a element.</p>`

--------

## firstKey(): mixed|null
<a href="#voku-php-readme-class-methods">↑</a>
Get the first key from the current array.

**Parameters:**
__nothing__

**Return:**
- `mixed|null <p>Return null if there wasn't a element.</p>`

--------

## firstsImmutable(int|null $number): static
<a href="#voku-php-readme-class-methods">↑</a>
Get the first value(s) from the current array.

And will return an empty array if there was no first entry.

EXAMPLE: <code>
a([2 => 'foo', 3 => 'bar', 4 => 'lall'])->firstsImmutable(2); // Arrayy[0 => 'foo', 1 => 'bar']
</code>

**Parameters:**
- `int|null $number <p>How many values you will take?</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## firstsKeys(int|null $number): static
<a href="#voku-php-readme-class-methods">↑</a>
Get the first value(s) from the current array.

And will return an empty array if there was no first entry.

**Parameters:**
- `int|null $number <p>How many values you will take?</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## firstsMutable(int|null $number): $this
<a href="#voku-php-readme-class-methods">↑</a>
Get and remove the first value(s) from the current array.

And will return an empty array if there was no first entry.

EXAMPLE: <code>
a([2 => 'foo', 3 => 'bar', 4 => 'lall'])->firstsMutable(); // 'foo'
</code>

**Parameters:**
- `int|null $number <p>How many values you will take?</p>`

**Return:**
- `$this <p>(Mutable)</p>`

--------

## flatten(string $delimiter, string $prepend, array|null $items): array
<a href="#voku-php-readme-class-methods">↑</a>
Flatten an array with the given character as a key delimiter.

EXAMPLE: <code>
$dot = a(['foo' => ['abc' => 'xyz', 'bar' => ['baz']]]);
$flatten = $dot->flatten();
$flatten['foo.abc']; // 'xyz'
$flatten['foo.bar.0']; // 'baz'
</code>

**Parameters:**
- `string $delimiter`
- `string $prepend`
- `array|null $items`

**Return:**
- `array`

--------

## flip(): static
<a href="#voku-php-readme-class-methods">↑</a>
Exchanges all keys with their associated values in an array.

EXAMPLE: <code>
a([0 => 'foo', 1 => 'bar'])->flip(); // Arrayy['foo' => 0, 'bar' => 1]
</code>

**Parameters:**
__nothing__

**Return:**
- `static <p>(Immutable)</p>`

--------

## get(int|string $key, mixed $fallback, array|null $array, bool $useByReference): mixed|static
<a href="#voku-php-readme-class-methods">↑</a>
Get a value from an array (optional using dot-notation).

EXAMPLE: <code>
$arrayy = a(['user' => ['lastname' => 'Moelleken']]);
$arrayy->get('user.lastname'); // 'Moelleken'
// ---
$arrayy = new A();
$arrayy['user'] = ['lastname' => 'Moelleken'];
$arrayy['user.firstname'] = 'Lars';
$arrayy['user']['lastname']; // Moelleken
$arrayy['user.lastname']; // Moelleken
$arrayy['user.firstname']; // Lars
</code>

**Parameters:**
- `array-key $key <p>The key to look for.</p>`
- `mixed $fallback <p>Value to fallback to.</p>`
- `array<array-key, mixed>|array<TKey, T> $array <p>The array to get from, if it's set to "null" we use the current array from the
class.</p>`
- `bool $useByReference`

**Return:**
- `mixed|static`

--------

## getAll(): array
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->toArray()"

**Parameters:**
__nothing__

**Return:**
- `array`

--------

## getArray(bool $convertAllArrayyElements, bool $preserveKeys): array
<a href="#voku-php-readme-class-methods">↑</a>
Get the current array from the "Arrayy"-object.

alias for "toArray()"

**Parameters:**
- `bool $convertAllArrayyElements <p>
Convert all Child-"Arrayy" objects also to arrays.
</p>`
- `bool $preserveKeys <p>
e.g.: A generator maybe return the same key more then once,
so maybe you will ignore the keys.
</p>`

**Return:**
- `array`

--------

## getArrayCopy(): array
<a href="#voku-php-readme-class-methods">↑</a>
Creates a copy of the ArrayyObject.

**Parameters:**
__nothing__

**Return:**
- `array`

--------

## getColumn(int|string|null $columnKey, int|string|null $indexKey): static
<a href="#voku-php-readme-class-methods">↑</a>
Returns the values from a single column of the input array, identified by
the $columnKey, can be used to extract data-columns from multi-arrays.

EXAMPLE: <code>
a([['foo' => 'bar', 'id' => 1], ['foo => 'lall', 'id' => 2]])->getColumn('foo', 'id'); // Arrayy[1 => 'bar', 2 => 'lall']
</code>

INFO: Optionally, you may provide an $indexKey to index the values in the returned
      array by the values from the $indexKey column in the input array.

**Parameters:**
- `int|string|null $columnKey`
- `int|string|null $indexKey`

**Return:**
- `static <p>(Immutable)</p>`

--------

## getGenerator(): Generator
<a href="#voku-php-readme-class-methods">↑</a>
Get the current array from the "Arrayy"-object as generator.

**Parameters:**
__nothing__

**Return:**
- `\Generator`

--------

## getGeneratorByReference(): Generator
<a href="#voku-php-readme-class-methods">↑</a>
Get the current array from the "Arrayy"-object as generator by reference.

**Parameters:**
__nothing__

**Return:**
- `\Generator`

--------

## getIterator(): Iterator<mixed,mixed>
<a href="#voku-php-readme-class-methods">↑</a>
Returns a new iterator, thus implementing the \Iterator interface.

EXAMPLE: <code>
a(['foo', 'bar'])->getIterator(); // ArrayyIterator['foo', 'bar']
</code>

**Parameters:**
__nothing__

**Return:**
- `\Iterator<mixed,mixed> <p>An iterator for the values in the array.</p>`

--------

## getIteratorClass(): string
<a href="#voku-php-readme-class-methods">↑</a>
Gets the iterator classname for the ArrayObject.

**Parameters:**
__nothing__

**Return:**
- `string`

--------

## getKeys(): static
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->keys()"

**Parameters:**
__nothing__

**Return:**
- `static <p>(Immutable)</p>`

--------

## getList(bool $convertAllArrayyElements): array
<a href="#voku-php-readme-class-methods">↑</a>
Get the current array from the "Arrayy"-object as list.

alias for "toList()"

**Parameters:**
- `bool $convertAllArrayyElements <p>
Convert all Child-"Arrayy" objects also to arrays.
</p>`

**Return:**
- `array`

--------

## getObject(): stdClass
<a href="#voku-php-readme-class-methods">↑</a>
Get the current array from the "Arrayy"-object as object.

**Parameters:**
__nothing__

**Return:**
- `\stdClass`

--------

## getPhpDocPropertiesFromClass(): 
<a href="#voku-php-readme-class-methods">↑</a>


**Parameters:**
__nothing__

**Return:**
- `TODO: __not_detected__`

--------

## getRandom(): static
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->randomImmutable()"

**Parameters:**
__nothing__

**Return:**
- `static <p>(Immutable)</p>`

--------

## getRandomKey(): null|mixed
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->randomKey()"

**Parameters:**
__nothing__

**Return:**
- `null|mixed <p>Get a key/index or null if there wasn't a key/index.</p>`

--------

## getRandomKeys(int $number): static
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->randomKeys()"

**Parameters:**
- `int $number`

**Return:**
- `static <p>(Immutable)</p>`

--------

## getRandomValue(): null|mixed
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->randomValue()"

**Parameters:**
__nothing__

**Return:**
- `null|mixed <p>Get a random value or null if there wasn't a value.</p>`

--------

## getRandomValues(int $number): static
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->randomValues()"

**Parameters:**
- `int $number`

**Return:**
- `static <p>(Immutable)</p>`

--------

## getValues(): static
<a href="#voku-php-readme-class-methods">↑</a>
Gets all values.

**Parameters:**
__nothing__

**Return:**
- `static <p>The values of all elements in this array, in the order they
appear in the array.</p>`

--------

## getValuesYield(): Generator
<a href="#voku-php-readme-class-methods">↑</a>
Gets all values via Generator.

**Parameters:**
__nothing__

**Return:**
- `\Generator <p>The values of all elements in this array, in the order they
appear in the array as Generator.</p>`

--------

## group(callable|string $grouper, bool $saveKeys): static
<a href="#voku-php-readme-class-methods">↑</a>
Group values from a array according to the results of a closure.

**Parameters:**
- `callable|string $grouper <p>A callable function name.</p>`
- `bool $saveKeys`

**Return:**
- `static <p>(Immutable)</p>`

--------

## has(mixed $key): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if an array has a given key.

**Parameters:**
- `null|TKey|array-key $key`

**Return:**
- `bool`

--------

## hasValue(mixed $value): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if an array has a given value.

INFO: If you need to search recursive please use ```contains($value, true)```.

**Parameters:**
- `T $value`

**Return:**
- `bool`

--------

## implode(string $glue, string $prefix): string
<a href="#voku-php-readme-class-methods">↑</a>
Implodes the values of this array.

EXAMPLE: <code>
a([0 => -9, 1, 2])->implode('|'); // '-9|1|2'
</code>

**Parameters:**
- `string $glue`
- `string $prefix`

**Return:**
- `string`

--------

## implodeKeys(string $glue): string
<a href="#voku-php-readme-class-methods">↑</a>
Implodes the keys of this array.

**Parameters:**
- `string $glue`

**Return:**
- `string`

--------

## indexBy(int|string $key): static
<a href="#voku-php-readme-class-methods">↑</a>
Given a list and an iterate-function that returns
a key for each element in the list (or a property name),
returns an object with an index of each item.

**Parameters:**
- `array-key $key`

**Return:**
- `static <p>(Immutable)</p>`

--------

## indexOf(mixed $value): false|int|string
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->searchIndex()"

**Parameters:**
- `T $value <p>The value to search for.</p>`

**Return:**
- `false|int|string`

--------

## initial(int $to): static
<a href="#voku-php-readme-class-methods">↑</a>
Get everything but the last.

.$to items.

EXAMPLE: <code>
a([2 => 'foo', 3 => 'bar', 4 => 'lall'])->initial(2); // Arrayy[0 => 'foo']
</code>

**Parameters:**
- `int $to`

**Return:**
- `static <p>(Immutable)</p>`

--------

## intersection(array $search, bool $keepKeys): static
<a href="#voku-php-readme-class-methods">↑</a>
Return an array with all elements found in input array.

EXAMPLE: <code>
a(['foo', 'bar'])->intersection(['bar', 'baz']); // Arrayy['bar']
</code>

**Parameters:**
- `array<TKey, T> $search`
- `bool $keepKeys`

**Return:**
- `static <p>(Immutable)</p>`

--------

## intersectionMulti(array $array): static
<a href="#voku-php-readme-class-methods">↑</a>
Return an array with all elements found in input array.

**Parameters:**
- `array<array<TKey, T>> ...$array`

**Return:**
- `static <p>(Immutable)</p>`

--------

## intersects(array $search): bool
<a href="#voku-php-readme-class-methods">↑</a>
Return a boolean flag which indicates whether the two input arrays have any common elements.

EXAMPLE: <code>
a(['foo', 'bar'])->intersects(['föö', 'bär']); // false
</code>

**Parameters:**
- `array<TKey, T> $search`

**Return:**
- `bool`

--------

## invoke(callable $callable, mixed $arguments): static
<a href="#voku-php-readme-class-methods">↑</a>
Invoke a function on all of an array's values.

**Parameters:**
- `callable(T  = default, mixed ): mixed $callable`
- `mixed $arguments`

**Return:**
- `static <p>(Immutable)</p>`

--------

## isAssoc(bool $recursive): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check whether array is associative or not.

EXAMPLE: <code>
a(['foo' => 'bar', 2, 3])->isAssoc(); // true
</code>

**Parameters:**
- `bool $recursive`

**Return:**
- `bool <p>Returns true if associative, false otherwise.</p>`

--------

## isEmpty(int|int[]|string|string[]|null $keys): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if a given key or keys are empty.

**Parameters:**
- `int|int[]|string|string[]|null $keys`

**Return:**
- `bool <p>Returns true if empty, false otherwise.</p>`

--------

## isEqual(array $array): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if the current array is equal to the given "$array" or not.

EXAMPLE: <code>
a(['💩'])->isEqual(['💩']); // true
</code>

**Parameters:**
- `array<array-key, mixed> $array`

**Return:**
- `bool`

--------

## isMultiArray(): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if the current array is a multi-array.

EXAMPLE: <code>
a(['foo' => [1, 2 , 3]])->isMultiArray(); // true
</code>

**Parameters:**
__nothing__

**Return:**
- `bool`

--------

## isNumeric(): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check whether array is numeric or not.

**Parameters:**
__nothing__

**Return:**
- `bool <p>Returns true if numeric, false otherwise.</p>`

--------

## isSequential(bool $recursive): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if the current array is sequential [0, 1, 2, 3, 4, 5 .

..] or not.

EXAMPLE: <code>
a([0 => 'foo', 1 => 'lall', 2 => 'foobar'])->isSequential(); // true
</code>

INFO: If the array is empty we count it as non-sequential.

**Parameters:**
- `bool $recursive`

**Return:**
- `bool`

--------

## jsonSerialize(): array
<a href="#voku-php-readme-class-methods">↑</a>


**Parameters:**
__nothing__

**Return:**
- `array`

--------

## key(): int|string|null
<a href="#voku-php-readme-class-methods">↑</a>
Gets the key/index of the element at the current internal iterator position.

**Parameters:**
__nothing__

**Return:**
- `int|string|null`

--------

## keyExists(int|string $key): bool
<a href="#voku-php-readme-class-methods">↑</a>
Checks if the given key exists in the provided array.

INFO: This method only use "array_key_exists()" if you want to use "dot"-notation,
then you need to use "Arrayy->offsetExists()".

**Parameters:**
- `int|string $key the key to look for`

**Return:**
- `bool`

--------

## keys(bool $recursive, mixed|null $search_values, bool $strict): static
<a href="#voku-php-readme-class-methods">↑</a>
Get all keys from the current array.

EXAMPLE: <code>
a([1 => 'foo', 2 => 'foo2', 3 => 'bar'])->keys(); // Arrayy[1, 2, 3]
</code>

**Parameters:**
- `bool $recursive [optional] <p>
Get all keys, also from all sub-arrays from an multi-dimensional array.
</p>`
- `null|T|T[] $search_values [optional] <p>
If specified, then only keys containing these values are returned.
</p>`
- `bool $strict [optional] <p>
Determines if strict comparison (===) should be used during the search.
</p>`

**Return:**
- `static <p>(Immutable) An array of all the keys in input.</p>`

--------

## krsort(int $sort_flags): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort an array by key in reverse order.

**Parameters:**
- `int $sort_flags [optional] <p>
You may modify the behavior of the sort using the optional
parameter sort_flags, for details
see sort.
</p>`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## krsortImmutable(int $sort_flags): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort an array by key in reverse order.

**Parameters:**
- `int $sort_flags [optional] <p>
You may modify the behavior of the sort using the optional
parameter sort_flags, for details
see sort.
</p>`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## ksort(int $sort_flags): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort the entries by key.

**Parameters:**
- `int $sort_flags [optional] <p>
You may modify the behavior of the sort using the optional
parameter sort_flags, for details
see sort.
</p>`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## ksortImmutable(int $sort_flags): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort the entries by key.

**Parameters:**
- `int $sort_flags [optional] <p>
You may modify the behavior of the sort using the optional
parameter sort_flags, for details
see sort.
</p>`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## last(): mixed|null
<a href="#voku-php-readme-class-methods">↑</a>
Get the last value from the current array.

EXAMPLE: <code>
a([2 => 'foo', 3 => 'bar', 4 => 'lall'])->last(); // 'lall'
</code>

**Parameters:**
__nothing__

**Return:**
- `mixed|null <p>Return null if there wasn't a element.</p>`

--------

## lastKey(): mixed|null
<a href="#voku-php-readme-class-methods">↑</a>
Get the last key from the current array.

**Parameters:**
__nothing__

**Return:**
- `mixed|null <p>Return null if there wasn't a element.</p>`

--------

## lastsImmutable(int|null $number): static
<a href="#voku-php-readme-class-methods">↑</a>
Get the last value(s) from the current array.

EXAMPLE: <code>
a([2 => 'foo', 3 => 'bar', 4 => 'lall'])->lasts(2); // Arrayy[0 => 'bar', 1 => 'lall']
</code>

**Parameters:**
- `int|null $number`

**Return:**
- `static <p>(Immutable)</p>`

--------

## lastsMutable(int|null $number): $this
<a href="#voku-php-readme-class-methods">↑</a>
Get the last value(s) from the current array.

EXAMPLE: <code>
a([2 => 'foo', 3 => 'bar', 4 => 'lall'])->lasts(2); // Arrayy[0 => 'bar', 1 => 'lall']
</code>

**Parameters:**
- `int|null $number`

**Return:**
- `$this <p>(Mutable)</p>`

--------

## length(int $mode): int
<a href="#voku-php-readme-class-methods">↑</a>
Count the values from the current array.

alias: for "Arrayy->count()"

**Parameters:**
- `int $mode`

**Return:**
- `int`

--------

## map(callable $callable, bool $useKeyAsSecondParameter, mixed $arguments): static
<a href="#voku-php-readme-class-methods">↑</a>
Apply the given function to the every element of the array,
collecting the results.

EXAMPLE: <code>
a(['foo', 'Foo'])->map('mb_strtoupper'); // Arrayy['FOO', 'FOO']
</code>

**Parameters:**
- `callable(T , TKey  = default, mixed  = default): T2 $callable`
- `bool $useKeyAsSecondParameter`
- `mixed ...$arguments`

**Return:**
- `static <p>(Immutable) Arrayy object with modified elements.</p>`

--------

## matches(\Closure $closure): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if all items in current array match a truth test.

EXAMPLE: <code>
$closure = function ($value, $key) {
    return ($value % 2 === 0);
};
a([2, 4, 8])->matches($closure); // true
</code>

**Parameters:**
- `\Closure(T  = default, TKey  = default): bool $closure`

**Return:**
- `bool`

--------

## matchesAny(\Closure $closure): bool
<a href="#voku-php-readme-class-methods">↑</a>
Check if any item in the current array matches a truth test.

EXAMPLE: <code>
$closure = function ($value, $key) {
    return ($value % 2 === 0);
};
a([1, 4, 7])->matches($closure); // true
</code>

**Parameters:**
- `\Closure(T  = default, TKey  = default): bool $closure`

**Return:**
- `bool`

--------

## max(): false|float|int|string
<a href="#voku-php-readme-class-methods">↑</a>
Get the max value from an array.

EXAMPLE: <code>
a([-9, -8, -7, 1.32])->max(); // 1.32
</code>

**Parameters:**
__nothing__

**Return:**
- `false|float|int|string <p>Will return false if there are no values.</p>`

--------

## mergeAppendKeepIndex(array $array, bool $recursive): static
<a href="#voku-php-readme-class-methods">↑</a>
Merge the new $array into the current array.

- keep key,value from the current array, also if the index is in the new $array

EXAMPLE: <code>
$array1 = [1 => 'one', 'foo' => 'bar1'];
$array2 = ['foo' => 'bar2', 3 => 'three'];
a($array1)->mergeAppendKeepIndex($array2); // Arrayy[1 => 'one', 'foo' => 'bar2', 3 => 'three']
// ---
$array1 = [0 => 'one', 1 => 'foo'];
$array2 = [0 => 'foo', 1 => 'bar2'];
a($array1)->mergeAppendKeepIndex($array2); // Arrayy[0 => 'foo', 1 => 'bar2']
</code>

**Parameters:**
- `array<(int|TKey), T> $array`
- `bool $recursive`

**Return:**
- `static <p>(Immutable)</p>`

--------

## mergeAppendNewIndex(array $array, bool $recursive): static
<a href="#voku-php-readme-class-methods">↑</a>
Merge the new $array into the current array.

- replace duplicate assoc-keys from the current array with the key,values from the new $array
- create new indexes

EXAMPLE: <code>
$array1 = [1 => 'one', 'foo' => 'bar1'];
$array2 = ['foo' => 'bar2', 3 => 'three'];
a($array1)->mergeAppendNewIndex($array2); // Arrayy[0 => 'one', 'foo' => 'bar2', 1 => 'three']
// ---
$array1 = [0 => 'one', 1 => 'foo'];
$array2 = [0 => 'foo', 1 => 'bar2'];
a($array1)->mergeAppendNewIndex($array2); // Arrayy[0 => 'one', 1 => 'foo', 2 => 'foo', 3 => 'bar2']
</code>

**Parameters:**
- `array<TKey, T> $array`
- `bool $recursive`

**Return:**
- `static <p>(Immutable)</p>`

--------

## mergePrependKeepIndex(array $array, bool $recursive): static
<a href="#voku-php-readme-class-methods">↑</a>
Merge the the current array into the $array.

- use key,value from the new $array, also if the index is in the current array

EXAMPLE: <code>
$array1 = [1 => 'one', 'foo' => 'bar1'];
$array2 = ['foo' => 'bar2', 3 => 'three'];
a($array1)->mergePrependKeepIndex($array2); // Arrayy['foo' => 'bar1', 3 => 'three', 1 => 'one']
// ---
$array1 = [0 => 'one', 1 => 'foo'];
$array2 = [0 => 'foo', 1 => 'bar2'];
a($array1)->mergePrependKeepIndex($array2); // Arrayy[0 => 'one', 1 => 'foo']
</code>

**Parameters:**
- `array<TKey, T> $array`
- `bool $recursive`

**Return:**
- `static <p>(Immutable)</p>`

--------

## mergePrependNewIndex(array $array, bool $recursive): static
<a href="#voku-php-readme-class-methods">↑</a>
Merge the current array into the new $array.

- replace duplicate assoc-keys from new $array with the key,values from the current array
- create new indexes

EXAMPLE: <code>
$array1 = [1 => 'one', 'foo' => 'bar1'];
$array2 = ['foo' => 'bar2', 3 => 'three'];
a($array1)->mergePrependNewIndex($array2); // Arrayy['foo' => 'bar1', 0 => 'three', 1 => 'one']
// ---
$array1 = [0 => 'one', 1 => 'foo'];
$array2 = [0 => 'foo', 1 => 'bar2'];
a($array1)->mergePrependNewIndex($array2); // Arrayy[0 => 'foo', 1 => 'bar2', 2 => 'one', 3 => 'foo']
</code>

**Parameters:**
- `array<TKey, T> $array`
- `bool $recursive`

**Return:**
- `static <p>(Immutable)</p>`

--------

## meta(): ArrayyMeta|mixed|static
<a href="#voku-php-readme-class-methods">↑</a>


**Parameters:**
__nothing__

**Return:**
- `\ArrayyMeta|mixed|static`

--------

## min(): false|mixed
<a href="#voku-php-readme-class-methods">↑</a>
Get the min value from an array.

EXAMPLE: <code>
a([-9, -8, -7, 1.32])->min(); // -9
</code>

**Parameters:**
__nothing__

**Return:**
- `false|mixed <p>Will return false if there are no values.</p>`

--------

## mostUsedValue(): mixed|null
<a href="#voku-php-readme-class-methods">↑</a>
Get the most used value from the array.

**Parameters:**
__nothing__

**Return:**
- `mixed|null <p>(Immutable) Return null if there wasn't a element.</p>`

--------

## mostUsedValues(int|null $number): static
<a href="#voku-php-readme-class-methods">↑</a>
Get the most used value from the array.

**Parameters:**
- `int|null $number <p>How many values you will take?</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## moveElement(int|string $from, int $to): static
<a href="#voku-php-readme-class-methods">↑</a>
Move an array element to a new index.

EXAMPLE: <code>
$arr2 = new A(['A' => 'a', 'B' => 'b', 'C' => 'c', 'D' => 'd', 'E' => 'e']);
$newArr2 = $arr2->moveElement('D', 1); // Arrayy['A' => 'a', 'D' => 'd', 'B' => 'b', 'C' => 'c', 'E' => 'e']
</code>

**Parameters:**
- `int|string $from`
- `int $to`

**Return:**
- `static <p>(Immutable)</p>`

--------

## moveElementToFirstPlace(int|string $key): static
<a href="#voku-php-readme-class-methods">↑</a>
Move an array element to the first place.

INFO: Instead of "Arrayy->moveElement()" this method will NOT
loss the keys of an indexed array.

**Parameters:**
- `int|string $key`

**Return:**
- `static <p>(Immutable)</p>`

--------

## moveElementToLastPlace(int|string $key): static
<a href="#voku-php-readme-class-methods">↑</a>
Move an array element to the last place.

INFO: Instead of "Arrayy->moveElement()" this method will NOT
loss the keys of an indexed array.

**Parameters:**
- `int|string $key`

**Return:**
- `static <p>(Immutable)</p>`

--------

## natcasesort(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort an array using a case insensitive "natural order" algorithm.

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## natcasesortImmutable(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort an array using a case insensitive "natural order" algorithm.

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## natsort(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort entries using a "natural order" algorithm.

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## natsortImmutable(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort entries using a "natural order" algorithm.

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## next(): false|mixed
<a href="#voku-php-readme-class-methods">↑</a>
Moves the internal iterator position to the next element and returns this element.

**Parameters:**
__nothing__

**Return:**
- `false|mixed <p>(Mutable) Will return false if there are no values.</p>`

--------

## nth(int $step, int $offset): static
<a href="#voku-php-readme-class-methods">↑</a>
Get the next nth keys and values from the array.

**Parameters:**
- `int $step`
- `int $offset`

**Return:**
- `static <p>(Immutable)</p>`

--------

## offsetExists(bool|int|string $offset): bool
<a href="#voku-php-readme-class-methods">↑</a>
Whether or not an offset exists.

**Parameters:**
- `bool|int|string $offset`

**Return:**
- `bool`

--------

## offsetGet(int|string $offset): mixed
<a href="#voku-php-readme-class-methods">↑</a>
Returns the value at specified offset.

**Parameters:**
- `TKey $offset`

**Return:**
- `mixed <p>Will return null if the offset did not exists.</p>`

--------

## offsetSet(int|string|null $offset, mixed $value): void
<a href="#voku-php-readme-class-methods">↑</a>
Assigns a value to the specified offset + check the type.

**Parameters:**
- `int|string|null $offset`
- `mixed $value`

**Return:**
- `void`

--------

## offsetUnset(int|string $offset): void
<a href="#voku-php-readme-class-methods">↑</a>
Unset an offset.

**Parameters:**
- `int|string $offset`

**Return:**
- `void <p>(Mutable) Return nothing.</p>`

--------

## only(int[]|string[] $keys): static
<a href="#voku-php-readme-class-methods">↑</a>
Get a subset of the items from the given array.

**Parameters:**
- `array-key[] $keys`

**Return:**
- `static <p>(Immutable)</p>`

--------

## pad(int $size, mixed $value): static
<a href="#voku-php-readme-class-methods">↑</a>
Pad array to the specified size with a given value.

**Parameters:**
- `int $size <p>Size of the result array.</p>`
- `mixed $value <p>Empty value by default.</p>`

**Return:**
- `static <p>(Immutable) Arrayy object padded to $size with $value.</p>`

--------

## partition(\Closure $closure): array<int,static>
<a href="#voku-php-readme-class-methods">↑</a>
Partitions this array in two array according to a predicate.

Keys are preserved in the resulting array.

**Parameters:**
- `\Closure(T  = default, TKey  = default): bool $closure <p>The predicate on which to partition.</p>`

**Return:**
- `array<int,static> <p>An array with two elements. The first element contains the array
of elements where the predicate returned TRUE, the second element
contains the array of elements where the predicate returned FALSE.</p>`

--------

## pop(): mixed|null
<a href="#voku-php-readme-class-methods">↑</a>
Pop a specified value off the end of the current array.

**Parameters:**
__nothing__

**Return:**
- `mixed|null <p>(Mutable) The popped element from the current array or null if the array is e.g. empty.</p>`

--------

## prepend(mixed $value, mixed $key): $this
<a href="#voku-php-readme-class-methods">↑</a>
Prepend a (key) + value to the current array.

EXAMPLE: <code>
a(['fòô' => 'bàř'])->prepend('foo'); // Arrayy[0 => 'foo', 'fòô' => 'bàř']
</code>

**Parameters:**
- `T $value`
- `TKey|null $key`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object, with the prepended value.</p>`

--------

## prependImmutable(mixed $value, mixed $key): $this
<a href="#voku-php-readme-class-methods">↑</a>
Prepend a (key) + value to the current array.

EXAMPLE: <code>
a(['fòô' => 'bàř'])->prependImmutable('foo')->getArray(); // [0 => 'foo', 'fòô' => 'bàř']
</code>

**Parameters:**
- `T $value`
- `TKey $key`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object, with the prepended value.</p>`

--------

## prependToEachKey(float|int|string $suffix): static
<a href="#voku-php-readme-class-methods">↑</a>
Add a suffix to each key.

**Parameters:**
- `float|int|string $suffix`

**Return:**
- `static <p>(Immutable) Return an Arrayy object, with the prepended keys.</p>`

--------

## prependToEachValue(float|int|string $suffix): static
<a href="#voku-php-readme-class-methods">↑</a>
Add a suffix to each value.

**Parameters:**
- `float|int|string $suffix`

**Return:**
- `static <p>(Immutable) Return an Arrayy object, with the prepended values.</p>`

--------

## pull(int|int[]|string|string[]|null $keyOrKeys, mixed $fallback): mixed
<a href="#voku-php-readme-class-methods">↑</a>
Return the value of a given key and
delete the key.

**Parameters:**
- `int|int[]|string|string[]|null $keyOrKeys`
- `mixed $fallback`

**Return:**
- `mixed`

--------

## push(mixed $args): $this
<a href="#voku-php-readme-class-methods">↑</a>
Push one or more values onto the end of array at once.

**Parameters:**
- `array<TKey, T> ...$args`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object, with pushed elements to the end of array.</p>`

--------

## randomImmutable(int|null $number): static
<a href="#voku-php-readme-class-methods">↑</a>
Get a random value from the current array.

EXAMPLE: <code>
a([1, 2, 3, 4])->randomImmutable(2); // e.g.: Arrayy[1, 4]
</code>

**Parameters:**
- `int|null $number <p>How many values you will take?</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## randomKey(): null|mixed
<a href="#voku-php-readme-class-methods">↑</a>
Pick a random key/index from the keys of this array.

EXAMPLE: <code>
$arrayy = A::create([1 => 'one', 2 => 'two']);
$arrayy->randomKey(); // e.g. 2
</code>

**Parameters:**
__nothing__

**Return:**
- `null|mixed <p>Get a key/index or null if there wasn't a key/index.</p>`

--------

## randomKeys(int $number): static
<a href="#voku-php-readme-class-methods">↑</a>
Pick a given number of random keys/indexes out of this array.

EXAMPLE: <code>
a([1 => 'one', 2 => 'two'])->randomKeys(); // e.g. Arrayy[1, 2]
</code>

**Parameters:**
- `int $number <p>The number of keys/indexes (should be <= \count($this->array))</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## randomMutable(int|null $number): $this
<a href="#voku-php-readme-class-methods">↑</a>
Get a random value from the current array.

EXAMPLE: <code>
a([1, 2, 3, 4])->randomMutable(2); // e.g.: Arrayy[1, 4]
</code>

**Parameters:**
- `int|null $number <p>How many values you will take?</p>`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## randomValue(): mixed
<a href="#voku-php-readme-class-methods">↑</a>
Pick a random value from the values of this array.

EXAMPLE: <code>
a([1 => 'one', 2 => 'two'])->randomValue(); // e.g. 'one'
</code>

**Parameters:**
__nothing__

**Return:**
- `mixed <p>Get a random value or null if there wasn't a value.</p>`

--------

## randomValues(int $number): static
<a href="#voku-php-readme-class-methods">↑</a>
Pick a given number of random values out of this array.

EXAMPLE: <code>
a([1 => 'one', 2 => 'two'])->randomValues(); // e.g. Arrayy['one', 'two']
</code>

**Parameters:**
- `int $number`

**Return:**
- `static <p>(Mutable)</p>`

--------

## randomWeighted(array $array, int $number): 
<a href="#voku-php-readme-class-methods">↑</a>


**Parameters:**
- `array $array`
- `int $number`

**Return:**
- `self`

--------

## reduce(callable $callable, mixed $initial): static
<a href="#voku-php-readme-class-methods">↑</a>
Reduce the current array via callable e.g. anonymous-function and return the end result.

EXAMPLE: <code>
a([1, 2, 3, 4])->reduce(
    function ($carry, $item) {
        return $carry * $item;
    },
    1
); // Arrayy[24]
</code>

**Parameters:**
- `callable(T2 , T , TKey ): T2 $callable`
- `T2 $initial`

**Return:**
- `static <p>(Immutable)</p>`

--------

## reduce_dimension(bool $unique): static
<a href="#voku-php-readme-class-methods">↑</a>


**Parameters:**
- `bool $unique`

**Return:**
- `static <p>(Immutable)</p>`

--------

## reindex(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Create a numerically re-indexed Arrayy object.

EXAMPLE: <code>
a([2 => 1, 3 => 2])->reindex(); // Arrayy[0 => 1, 1 => 2]
</code>

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Mutable) Return this Arrayy object, with re-indexed array-elements.</p>`

--------

## reject(\Closure $closure): static
<a href="#voku-php-readme-class-methods">↑</a>
Return all items that fail the truth test.

EXAMPLE: <code>
$closure = function ($value) {
    return $value % 2 !== 0;
}
a([1, 2, 3, 4])->reject($closure); // Arrayy[1 => 2, 3 => 4]
</code>

**Parameters:**
- `\Closure(T  = default, TKey  = default): bool $closure`

**Return:**
- `static <p>(Immutable)</p>`

--------

## remove(mixed $key): static
<a href="#voku-php-readme-class-methods">↑</a>
Remove a value from the current array (optional using dot-notation).

EXAMPLE: <code>
a([1 => 'bar', 'foo' => 'foo'])->remove(1); // Arrayy['foo' => 'foo']
</code>

**Parameters:**
- `TKey $key`

**Return:**
- `static <p>(Mutable)</p>`

--------

## removeElement(mixed $element): static
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->removeValue()"

**Parameters:**
- `T $element`

**Return:**
- `static <p>(Immutable)</p>`

--------

## removeFirst(): static
<a href="#voku-php-readme-class-methods">↑</a>
Remove the first value from the current array.

EXAMPLE: <code>
a([1 => 'bar', 'foo' => 'foo'])->removeFirst(); // Arrayy['foo' => 'foo']
</code>

**Parameters:**
__nothing__

**Return:**
- `static <p>(Immutable)</p>`

--------

## removeLast(): static
<a href="#voku-php-readme-class-methods">↑</a>
Remove the last value from the current array.

EXAMPLE: <code>
a([1 => 'bar', 'foo' => 'foo'])->removeLast(); // Arrayy[1 => 'bar']
</code>

**Parameters:**
__nothing__

**Return:**
- `static <p>(Immutable)</p>`

--------

## removeValue(mixed $value): static
<a href="#voku-php-readme-class-methods">↑</a>
Removes a particular value from an array (numeric or associative).

EXAMPLE: <code>
a([1 => 'bar', 'foo' => 'foo'])->removeValue('foo'); // Arrayy[1 => 'bar']
</code>

**Parameters:**
- `T $value`

**Return:**
- `static <p>(Immutable)</p>`

--------

## repeat(int $times): static
<a href="#voku-php-readme-class-methods">↑</a>
Generate array of repeated arrays.

**Parameters:**
- `int $times <p>How many times has to be repeated.</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## replace(mixed $oldKey, mixed $newKey, mixed $newValue): static
<a href="#voku-php-readme-class-methods">↑</a>
Replace a key with a new key/value pair.

EXAMPLE: <code>
$arrayy = a([1 => 'foo', 2 => 'foo2', 3 => 'bar']);
$arrayy->replace(2, 'notfoo', 'notbar'); // Arrayy[1 => 'foo', 'notfoo' => 'notbar', 3 => 'bar']
</code>

**Parameters:**
- `mixed $oldKey`
- `mixed $newKey`
- `mixed $newValue`

**Return:**
- `static <p>(Immutable)</p>`

--------

## replaceAllKeys(int[]|string[] $keys): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an array using the current array as values and the other array as keys.

EXAMPLE: <code>
$firstArray = [
    1 => 'one',
    2 => 'two',
    3 => 'three',
];
$secondArray = [
    'one' => 1,
    1     => 'one',
    2     => 2,
];
$arrayy = a($firstArray);
$arrayy->replaceAllKeys($secondArray); // Arrayy[1 => "one", 'one' => "two", 2 => "three"]
</code>

**Parameters:**
- `array<array-key, TKey> $keys <p>An array of keys.</p>`

**Return:**
- `static <p>(Immutable) Arrayy object with keys from the other array, empty Arrayy object if the number of elements
for each array isn't equal or if the arrays are empty.
</p>`

--------

## replaceAllValues(array $array): static
<a href="#voku-php-readme-class-methods">↑</a>
Create an array using the current array as keys and the other array as values.

EXAMPLE: <code>
$firstArray = [
    1 => 'one',
    2 => 'two',
    3 => 'three',
];
$secondArray = [
    'one' => 1,
    1     => 'one',
    2     => 2,
];
$arrayy = a($firstArray);
$arrayy->replaceAllValues($secondArray); // Arrayy['one' => 1, 'two' => 'one', 'three' => 2]
</code>

**Parameters:**
- `array<array-key, T> $array <p>An array of values.</p>`

**Return:**
- `static <p>(Immutable) Arrayy object with values from the other array, empty Arrayy object if the number of elements
for each array isn't equal or if the arrays are empty.
</p>`

--------

## replaceKeys(array $keys): static
<a href="#voku-php-readme-class-methods">↑</a>
Replace the keys in an array with another set.

EXAMPLE: <code>
a([1 => 'bar', 'foo' => 'foo'])->replaceKeys([1 => 2, 'foo' => 'replaced']); // Arrayy[2 => 'bar', 'replaced' => 'foo']
</code>

**Parameters:**
- `array<array-key, TKey> $keys <p>An array of keys matching the array's size.</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## replaceOneValue(mixed $search, mixed $replacement): static
<a href="#voku-php-readme-class-methods">↑</a>
Replace the first matched value in an array.

EXAMPLE: <code>
$testArray = ['bar', 'foo' => 'foo', 'foobar' => 'foobar'];
a($testArray)->replaceOneValue('foo', 'replaced'); // Arrayy['bar', 'foo' => 'replaced', 'foobar' => 'foobar']
</code>

**Parameters:**
- `mixed $search <p>The value to replace.</p>`
- `mixed $replacement <p>The value to replace.</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## replaceValues(string $search, string $replacement): static
<a href="#voku-php-readme-class-methods">↑</a>
Replace values in the current array.

EXAMPLE: <code>
$testArray = ['bar', 'foo' => 'foo', 'foobar' => 'foobar'];
a($testArray)->replaceValues('foo', 'replaced'); // Arrayy['bar', 'foo' => 'replaced', 'foobar' => 'replacedbar']
</code>

**Parameters:**
- `string $search <p>The value to replace.</p>`
- `string $replacement <p>What to replace it with.</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## rest(int $from): static
<a href="#voku-php-readme-class-methods">↑</a>
Get the last elements from index $from until the end of this array.

EXAMPLE: <code>
a([2 => 'foo', 3 => 'bar', 4 => 'lall'])->rest(2); // Arrayy[0 => 'lall']
</code>

**Parameters:**
- `int $from`

**Return:**
- `static <p>(Immutable)</p>`

--------

## reverse(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Return the array in the reverse order.

EXAMPLE: <code>
a([1, 2, 3])->reverse(); // self[3, 2, 1]
</code>

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## rsort(int $sort_flags): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort an array in reverse order.

**Parameters:**
- `int $sort_flags [optional] <p>
You may modify the behavior of the sort using the optional
parameter sort_flags, for details
see sort.
</p>`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## rsortImmutable(int $sort_flags): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort an array in reverse order.

**Parameters:**
- `int $sort_flags [optional] <p>
You may modify the behavior of the sort using the optional
parameter sort_flags, for details
see sort.
</p>`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## searchIndex(mixed $value): false|int|string
<a href="#voku-php-readme-class-methods">↑</a>
Search for the first index of the current array via $value.

EXAMPLE: <code>
a(['fòô' => 'bàř', 'lall' => 'bàř'])->searchIndex('bàř'); // Arrayy[0 => 'fòô']
</code>

**Parameters:**
- `T $value`

**Return:**
- `false|int|string <p>Will return <b>FALSE</b> if the value can't be found.</p>`

--------

## searchValue(mixed $index): static
<a href="#voku-php-readme-class-methods">↑</a>
Search for the value of the current array via $index.

EXAMPLE: <code>
a(['fòô' => 'bàř'])->searchValue('fòô'); // Arrayy[0 => 'bàř']
</code>

**Parameters:**
- `mixed $index`

**Return:**
- `static <p>(Immutable) Will return a empty Arrayy if the value wasn't found.</p>`

--------

## serialize(): string
<a href="#voku-php-readme-class-methods">↑</a>
Serialize the current "Arrayy"-object.

EXAMPLE: <code>
a([1, 4, 7])->serialize();
</code>

**Parameters:**
__nothing__

**Return:**
- `string`

--------

## set(string $key, mixed $value): $this
<a href="#voku-php-readme-class-methods">↑</a>
Set a value for the current array (optional using dot-notation).

EXAMPLE: <code>
$arrayy = a(['Lars' => ['lastname' => 'Moelleken']]);
$arrayy->set('Lars.lastname', 'Müller'); // Arrayy['Lars', ['lastname' => 'Müller']]]
</code>

**Parameters:**
- `TKey $key <p>The key to set.</p>`
- `T $value <p>Its value.</p>`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## setAndGet(mixed $key, mixed $fallback): mixed
<a href="#voku-php-readme-class-methods">↑</a>
Get a value from a array and set it if it was not.

WARNING: this method only set the value, if the $key is not already set

EXAMPLE: <code>
$arrayy = a([1 => 1, 2 => 2, 3 => 3]);
$arrayy->setAndGet(1, 4); // 1
$arrayy->setAndGet(0, 4); // 4
</code>

**Parameters:**
- `mixed $key <p>The key</p>`
- `mixed $fallback <p>The default value to set if it isn't.</p>`

**Return:**
- `mixed <p>(Mutable)</p>`

--------

## setIteratorClass(string $iteratorClass): void
<a href="#voku-php-readme-class-methods">↑</a>
Sets the iterator classname for the current "Arrayy"-object.

**Parameters:**
- `class-string<\Arrayy\ArrayyIterator> $iteratorClass`

**Return:**
- `void`

--------

## shift(): mixed
<a href="#voku-php-readme-class-methods">↑</a>
Shifts a specified value off the beginning of array.

**Parameters:**
__nothing__

**Return:**
- `mixed <p>(Mutable) A shifted element from the current array.</p>`

--------

## shuffle(bool $secure, array|null $array): static
<a href="#voku-php-readme-class-methods">↑</a>
Shuffle the current array.

EXAMPLE: <code>
a([1 => 'bar', 'foo' => 'foo'])->shuffle(); // e.g.: Arrayy[['foo' => 'foo', 1 => 'bar']]
</code>

**Parameters:**
- `bool $secure <p>using a CSPRNG | @see https://paragonie.com/b/JvICXzh_jhLyt4y3</p>`
- `array<TKey, T> $array [optional]`

**Return:**
- `static <p>(Immutable)</p>`

--------

## size(int $mode): int
<a href="#voku-php-readme-class-methods">↑</a>
Count the values from the current array.

alias: for "Arrayy->count()"

**Parameters:**
- `int $mode`

**Return:**
- `int`

--------

## sizeIs(int $size): bool
<a href="#voku-php-readme-class-methods">↑</a>
Checks whether array has exactly $size items.

**Parameters:**
- `int $size`

**Return:**
- `bool`

--------

## sizeIsBetween(int $fromSize, int $toSize): bool
<a href="#voku-php-readme-class-methods">↑</a>
Checks whether array has between $fromSize to $toSize items. $toSize can be
smaller than $fromSize.

**Parameters:**
- `int $fromSize`
- `int $toSize`

**Return:**
- `bool`

--------

## sizeIsGreaterThan(int $size): bool
<a href="#voku-php-readme-class-methods">↑</a>
Checks whether array has more than $size items.

**Parameters:**
- `int $size`

**Return:**
- `bool`

--------

## sizeIsLessThan(int $size): bool
<a href="#voku-php-readme-class-methods">↑</a>
Checks whether array has less than $size items.

**Parameters:**
- `int $size`

**Return:**
- `bool`

--------

## sizeRecursive(): int
<a href="#voku-php-readme-class-methods">↑</a>
Counts all elements in an array, or something in an object.

<p>
For objects, if you have SPL installed, you can hook into count() by implementing interface {@see \Countable}.
The interface has exactly one method, {@see \Countable::count()}, which returns the return value for the count()
function. Please see the {@see \Array} section of the manual for a detailed explanation of how arrays are
implemented and used in PHP.
</p>

**Parameters:**
__nothing__

**Return:**
- `int <p>
The number of elements in var, which is
typically an array, since anything else will have one
element.
</p>
<p>
If var is not an array or an object with
implemented Countable interface,
1 will be returned.
There is one exception, if var is &null;,
0 will be returned.
</p>
<p>
Caution: count may return 0 for a variable that isn't set,
but it may also return 0 for a variable that has been initialized with an
empty array. Use isset to test if a variable is set.
</p>`

--------

## slice(int $offset, int|null $length, bool $preserveKeys): static
<a href="#voku-php-readme-class-methods">↑</a>
Extract a slice of the array.

**Parameters:**
- `int $offset <p>Slice begin index.</p>`
- `int|null $length <p>Length of the slice.</p>`
- `bool $preserveKeys <p>Whether array keys are preserved or no.</p>`

**Return:**
- `static <p>(Immutable) A slice of the original array with length $length.</p>`

--------

## sort(int|string $direction, int $strategy, bool $keepKeys): static
<a href="#voku-php-readme-class-methods">↑</a>
Sort the current array and optional you can keep the keys.

EXAMPLE: <code>
a(3 => 'd', 2 => 'f', 0 => 'a')->sort(SORT_ASC, SORT_NATURAL, false); // Arrayy[0 => 'a', 1 => 'd', 2 => 'f']
</code>

**Parameters:**
- `int|string $direction <p>use <strong>SORT_ASC</strong> (default) or <strong>SORT_DESC</strong></p>`
- `int $strategy <p>sort_flags => use e.g.: <strong>SORT_REGULAR</strong> (default) or
<strong>SORT_NATURAL</strong></p>`
- `bool $keepKeys`

**Return:**
- `static <p>(Mutable) Return this Arrayy object.</p>`

--------

## sortImmutable(int|string $direction, int $strategy, bool $keepKeys): static
<a href="#voku-php-readme-class-methods">↑</a>
Sort the current array and optional you can keep the keys.

**Parameters:**
- `int|string $direction <p>use <strong>SORT_ASC</strong> (default) or <strong>SORT_DESC</strong></p>`
- `int $strategy <p>sort_flags => use e.g.: <strong>SORT_REGULAR</strong> (default) or
<strong>SORT_NATURAL</strong></p>`
- `bool $keepKeys`

**Return:**
- `static <p>(Immutable) Return this Arrayy object.</p>`

--------

## sortKeys(int|string $direction, int $strategy): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort the current array by key.

EXAMPLE: <code>
a([1 => 2, 0 => 1])->sortKeys(\SORT_ASC); // Arrayy[0 => 1, 1 => 2]
</code>

**Parameters:**
- `int|string $direction <p>use <strong>SORT_ASC</strong> (default) or <strong>SORT_DESC</strong></p>`
- `int $strategy <p>use e.g.: <strong>SORT_REGULAR</strong> (default) or
<strong>SORT_NATURAL</strong></p>`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## sortKeysImmutable(int|string $direction, int $strategy): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort the current array by key.

**Parameters:**
- `int|string $direction <p>use <strong>SORT_ASC</strong> (default) or <strong>SORT_DESC</strong></p>`
- `int $strategy <p>use e.g.: <strong>SORT_REGULAR</strong> (default) or
<strong>SORT_NATURAL</strong></p>`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## sortValueKeepIndex(int|string $direction, int $strategy): static
<a href="#voku-php-readme-class-methods">↑</a>
Sort the current array by value.

EXAMPLE: <code>
a(3 => 'd', 2 => 'f', 0 => 'a')->sortValueKeepIndex(SORT_ASC, SORT_REGULAR); // Arrayy[0 => 'a', 3 => 'd', 2 => 'f']
</code>

**Parameters:**
- `int|string $direction <p>use <strong>SORT_ASC</strong> (default) or <strong>SORT_DESC</strong></p>`
- `int $strategy <p>use e.g.: <strong>SORT_REGULAR</strong> (default) or
<strong>SORT_NATURAL</strong></p>`

**Return:**
- `static <p>(Mutable)</p>`

--------

## sortValueNewIndex(int|string $direction, int $strategy): static
<a href="#voku-php-readme-class-methods">↑</a>
Sort the current array by value.

EXAMPLE: <code>
a(3 => 'd', 2 => 'f', 0 => 'a')->sortValueNewIndex(SORT_ASC, SORT_NATURAL); // Arrayy[0 => 'a', 1 => 'd', 2 => 'f']
</code>

**Parameters:**
- `int|string $direction <p>use <strong>SORT_ASC</strong> (default) or <strong>SORT_DESC</strong></p>`
- `int $strategy <p>use e.g.: <strong>SORT_REGULAR</strong> (default) or
<strong>SORT_NATURAL</strong></p>`

**Return:**
- `static <p>(Mutable)</p>`

--------

## sorter(callable|mixed|null $sorter, int|string $direction, int $strategy): static
<a href="#voku-php-readme-class-methods">↑</a>
Sort a array by value or by a closure.

- If the sorter is null, the array is sorted naturally.
- Associative (string) keys will be maintained, but numeric keys will be re-indexed.

EXAMPLE: <code>
$testArray = range(1, 5);
$under = a($testArray)->sorter(
    function ($value) {
        return $value % 2 === 0;
    }
);
var_dump($under); // Arrayy[1, 3, 5, 2, 4]
</code>

**Parameters:**
- `callable|mixed|null $sorter`
- `int|string $direction <p>use <strong>SORT_ASC</strong> (default) or
<strong>SORT_DESC</strong></p>`
- `int $strategy <p>use e.g.: <strong>SORT_REGULAR</strong> (default) or
<strong>SORT_NATURAL</strong></p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## splice(int $offset, int|null $length, array $replacement): static
<a href="#voku-php-readme-class-methods">↑</a>


**Parameters:**
- `int $offset`
- `int|null $length`
- `array<array-key, T> $replacement`

**Return:**
- `static <p>(Immutable)</p>`

--------

## split(int $numberOfPieces, bool $keepKeys): static
<a href="#voku-php-readme-class-methods">↑</a>
Split an array in the given amount of pieces.

EXAMPLE: <code>
a(['a' => 1, 'b' => 2])->split(2, true); // Arrayy[['a' => 1], ['b' => 2]]
</code>

**Parameters:**
- `int $numberOfPieces`
- `bool $keepKeys`

**Return:**
- `static <p>(Immutable)</p>`

--------

## stripEmpty(): static
<a href="#voku-php-readme-class-methods">↑</a>
Strip all empty items from the current array.

EXAMPLE: <code>
a(['a' => 1, 'b' => ''])->stripEmpty(); // Arrayy[['a' => 1]]
</code>

**Parameters:**
__nothing__

**Return:**
- `static <p>(Immutable)</p>`

--------

## swap(int|string $swapA, int|string $swapB): static
<a href="#voku-php-readme-class-methods">↑</a>
Swap two values between positions by key.

EXAMPLE: <code>
a(['a' => 1, 'b' => ''])->swap('a', 'b'); // Arrayy[['a' => '', 'b' => 1]]
</code>

**Parameters:**
- `int|string $swapA <p>a key in the array</p>`
- `int|string $swapB <p>a key in the array</p>`

**Return:**
- `static <p>(Immutable)</p>`

--------

## toArray(bool $convertAllArrayyElements, bool $preserveKeys): array
<a href="#voku-php-readme-class-methods">↑</a>
Get the current array from the "Arrayy"-object.

alias for "getArray()"

**Parameters:**
- `bool $convertAllArrayyElements <p>
Convert all Child-"Arrayy" objects also to arrays.
</p>`
- `bool $preserveKeys <p>
e.g.: A generator maybe return the same key more then once,
so maybe you will ignore the keys.
</p>`

**Return:**
- `array`

--------

## toJson(int $options, int $depth): string
<a href="#voku-php-readme-class-methods">↑</a>
Convert the current array to JSON.

EXAMPLE: <code>
a(['bar', ['foo']])->toJson(); // '["bar",{"1":"foo"}]'
</code>

**Parameters:**
- `int $options [optional] <p>e.g. JSON_PRETTY_PRINT</p>`
- `int $depth [optional] <p>Set the maximum depth. Must be greater than zero.</p>`

**Return:**
- `string`

--------

## toList(bool $convertAllArrayyElements): array
<a href="#voku-php-readme-class-methods">↑</a>
Get the current array from the "Arrayy"-object as list.

**Parameters:**
- `bool $convertAllArrayyElements <p>
Convert all Child-"Arrayy" objects also to arrays.
</p>`

**Return:**
- `array`

--------

## toPermutation(string[]|null $items, string[] $helper): static|static[]
<a href="#voku-php-readme-class-methods">↑</a>


**Parameters:**
- `string[]|null $items [optional]`
- `string[] $helper [optional]`

**Return:**
- `static|static[]`

--------

## toString(string $separator): string
<a href="#voku-php-readme-class-methods">↑</a>
Implodes array to a string with specified separator.

**Parameters:**
- `string $separator [optional] <p>The element's separator.</p>`

**Return:**
- `string <p>The string representation of array, separated by ",".</p>`

--------

## uasort(callable $function): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort the entries with a user-defined comparison function and maintain key association.

**Parameters:**
- `callable $function`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object.</p>`

--------

## uasortImmutable(callable $function): $this
<a href="#voku-php-readme-class-methods">↑</a>
Sort the entries with a user-defined comparison function and maintain key association.

**Parameters:**
- `callable $function`

**Return:**
- `$this <p>(Immutable) Return this Arrayy object.</p>`

--------

## uksort(callable $function): static
<a href="#voku-php-readme-class-methods">↑</a>
Sort the entries by keys using a user-defined comparison function.

**Parameters:**
- `callable $function`

**Return:**
- `static <p>(Mutable) Return this Arrayy object.</p>`

--------

## uksortImmutable(callable $function): static
<a href="#voku-php-readme-class-methods">↑</a>
Sort the entries by keys using a user-defined comparison function.

**Parameters:**
- `callable $function`

**Return:**
- `static <p>(Immutable) Return this Arrayy object.</p>`

--------

## unique(): static
<a href="#voku-php-readme-class-methods">↑</a>
alias: for "Arrayy->uniqueNewIndex()"

**Parameters:**
__nothing__

**Return:**
- `static <p>(Mutable) Return this Arrayy object, with the appended values.</p>`

--------

## uniqueKeepIndex(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Return a duplicate free copy of the current array. (with the old keys)

EXAMPLE: <code>
a([2 => 1, 3 => 2, 4 => 2])->uniqueNewIndex(); // Arrayy[2 => 1, 3 => 2]
</code>

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Mutable)</p>`

--------

## uniqueNewIndex(): $this
<a href="#voku-php-readme-class-methods">↑</a>
Return a duplicate free copy of the current array.

EXAMPLE: <code>
a([2 => 1, 3 => 2, 4 => 2])->uniqueNewIndex(); // Arrayy[1, 2]
</code>

**Parameters:**
__nothing__

**Return:**
- `$this <p>(Mutable)</p>`

--------

## unserialize(string $string): $this
<a href="#voku-php-readme-class-methods">↑</a>
Unserialize an string and return the instance of the "Arrayy"-class.

EXAMPLE: <code>
$serialized = a([1, 4, 7])->serialize();
a()->unserialize($serialized);
</code>

**Parameters:**
- `string $string`

**Return:**
- `$this`

--------

## unshift(mixed $args): $this
<a href="#voku-php-readme-class-methods">↑</a>
Prepends one or more values to the beginning of array at once.

**Parameters:**
- `array<TKey, T> ...$args`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object, with prepended elements to the beginning of array.</p>`

--------

## validate(\Closure $closure): bool
<a href="#voku-php-readme-class-methods">↑</a>
Tests whether the given closure return something valid for all elements of this array.

**Parameters:**
- `\Closure(T  = default, TKey  = default): bool $closure the predicate`

**Return:**
- `bool <p>TRUE, if the predicate yields TRUE for all elements, FALSE otherwise.</p>`

--------

## values(): static
<a href="#voku-php-readme-class-methods">↑</a>
Get all values from a array.

EXAMPLE: <code>
$arrayy = a([1 => 'foo', 2 => 'foo2', 3 => 'bar']);
$arrayyTmp->values(); // Arrayy[0 => 'foo', 1 => 'foo2', 2 => 'bar']
</code>

**Parameters:**
__nothing__

**Return:**
- `static <p>(Immutable)</p>`

--------

## walk(callable $callable, bool $recursive, mixed $userData): $this
<a href="#voku-php-readme-class-methods">↑</a>
Apply the given function to every element in the array, discarding the results.

EXAMPLE: <code>
$callable = function (&$value, $key) {
    $value = $key;
};
$arrayy = a([1, 2, 3]);
$arrayy->walk($callable); // Arrayy[0, 1, 2]
</code>

**Parameters:**
- `callable $callable`
- `bool $recursive [optional] <p>Whether array will be walked recursively or no</p>`
- `mixed $userData [optional] <p>
If the optional $userData parameter is supplied,
it will be passed as the third parameter to the $callable.
</p>`

**Return:**
- `$this <p>(Mutable) Return this Arrayy object, with modified elements.</p>`

--------

## where(string $keyOrPropertyOrMethod, mixed $value): static
<a href="#voku-php-readme-class-methods">↑</a>
Returns a collection of matching items.

**Parameters:**
- `string $keyOrPropertyOrMethod <p>The property or method to evaluate.</p>`
- `mixed $value <p>The value to match.</p>`

**Return:**
- `static`

--------



## Support

For support and donations please visit [Github](https://github.com/voku/Arrayy/) | [Issues](https://github.com/voku/Arrayy/issues) | [PayPal](https://paypal.me/moelleken) | [Patreon](https://www.patreon.com/voku).

For status updates and release announcements please visit [Releases](https://github.com/voku/Arrayy/releases) | [Twitter](https://twitter.com/suckup_de) | [Patreon](https://www.patreon.com/voku/posts).

For professional support please contact [me](https://about.me/voku).

## Thanks

- Thanks to [GitHub](https://github.com) (Microsoft) for hosting the code and a good infrastructure including Issues-Managment, etc.
- Thanks to [IntelliJ](https://www.jetbrains.com) as they make the best IDEs for PHP and they gave me an open source license for PhpStorm!
- Thanks to [Travis CI](https://travis-ci.com/) for being the most awesome, easiest continous integration tool out there!
- Thanks to [StyleCI](https://styleci.io/) for the simple but powerfull code style check.
- Thanks to [PHPStan](https://github.com/phpstan/phpstan) && [Psalm](https://github.com/vimeo/psalm) for relly great Static analysis tools and for discover bugs in the code!

## Tests

From the project directory, tests can be ran using `phpunit`

## License

Released under the MIT License - see `LICENSE.txt` for details.
