<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'dd.MM.yyyy',
            'time' => 'H:mm',
            'datetime' => 'dd.MM.yyyy H:mm',
        ],
        'medium' => [
            'date' => 'd. M. y',
            'time' => 'H:mm:ss',
            'datetime' => 'd. M. y H:mm:ss',
        ],
        'long' => [
            'date' => 'd. MMMM y',
            'time' => 'H:mm:ss z',
            'datetime' => 'd. MMMM y H:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE d. MMMM y',
            'time' => 'H:mm:ss zzzz',
            'datetime' => 'EEEE d. MMMM y H:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'dop.',
    'pmName' => 'odp.',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => ' ',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ' ',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => 'ILS ',
        'INR' => 'INR ',
        'JPY' => 'JP¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => 'THB ',
        'TWD' => 'NT$',
        'USD' => 'US$',
        'VND' => 'VND ',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            'led',
            'úno',
            'bře',
            'dub',
            'kvě',
            'čvn',
            'čvc',
            'srp',
            'zář',
            'říj',
            'lis',
            'pro',
        ],
        'full' => [
            'leden',
            'únor',
            'březen',
            'duben',
            'květen',
            'červen',
            'červenec',
            'srpen',
            'září',
            'říjen',
            'listopad',
            'prosinec',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            'led',
            'úno',
            'bře',
            'dub',
            'kvě',
            'čvn',
            'čvc',
            'srp',
            'zář',
            'říj',
            'lis',
            'pro',
        ],
        'full' => [
            'ledna',
            'února',
            'března',
            'dubna',
            'května',
            'června',
            'července',
            'srpna',
            'září',
            'října',
            'listopadu',
            'prosince',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'N',
            'P',
            'Ú',
            'S',
            'Č',
            'P',
            'S',
        ],
        'short' => [
            'ne',
            'po',
            'út',
            'st',
            'čt',
            'pá',
            'so',
        ],
        'medium' => [
            'ne',
            'po',
            'út',
            'st',
            'čt',
            'pá',
            'so',
        ],
        'full' => [
            'neděle',
            'pondělí',
            'úterý',
            'středa',
            'čtvrtek',
            'pátek',
            'sobota',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'N',
            'P',
            'Ú',
            'S',
            'Č',
            'P',
            'S',
        ],
        'short' => [
            'ne',
            'po',
            'út',
            'st',
            'čt',
            'pá',
            'so',
        ],
        'medium' => [
            'ne',
            'po',
            'út',
            'st',
            'čt',
            'pá',
            'so',
        ],
        'full' => [
            'neděle',
            'pondělí',
            'úterý',
            'středa',
            'čtvrtek',
            'pátek',
            'sobota',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikánština',
        'af-NA' => 'afrikánština (Namibie)',
        'af-ZA' => 'afrikánština (Jihoafrická republika)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Kamerun)',
        'ak' => 'akanština',
        'ak-GH' => 'akanština (Ghana)',
        'am' => 'amharština',
        'am-ET' => 'amharština (Etiopie)',
        'ar' => 'arabština',
        'ar-001' => 'arabština (svět)',
        'ar-AE' => 'arabština (Spojené arabské emiráty)',
        'ar-BH' => 'arabština (Bahrajn)',
        'ar-DJ' => 'arabština (Džibutsko)',
        'ar-DZ' => 'arabština (Alžírsko)',
        'ar-EG' => 'arabština (Egypt)',
        'ar-EH' => 'arabština (Západní Sahara)',
        'ar-ER' => 'arabština (Eritrea)',
        'ar-IL' => 'arabština (Izrael)',
        'ar-IQ' => 'arabština (Irák)',
        'ar-JO' => 'arabština (Jordánsko)',
        'ar-KM' => 'arabština (Komory)',
        'ar-KW' => 'arabština (Kuvajt)',
        'ar-LB' => 'arabština (Libanon)',
        'ar-LY' => 'arabština (Libye)',
        'ar-MA' => 'arabština (Maroko)',
        'ar-MR' => 'arabština (Mauritánie)',
        'ar-OM' => 'arabština (Omán)',
        'ar-PS' => 'arabština (Palestinská území)',
        'ar-QA' => 'arabština (Katar)',
        'ar-SA' => 'arabština (Saúdská Arábie)',
        'ar-SD' => 'arabština (Súdán)',
        'ar-SO' => 'arabština (Somálsko)',
        'ar-SS' => 'arabština (Jižní Súdán)',
        'ar-SY' => 'arabština (Sýrie)',
        'ar-TD' => 'arabština (Čad)',
        'ar-TN' => 'arabština (Tunisko)',
        'ar-YE' => 'arabština (Jemen)',
        'as' => 'ásámština',
        'as-IN' => 'ásámština (Indie)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzanie)',
        'ast' => 'asturština',
        'ast-ES' => 'asturština (Španělsko)',
        'az' => 'ázerbájdžánština',
        'az-Cyrl' => 'ázerbájdžánština (cyrilice)',
        'az-Cyrl-AZ' => 'ázerbájdžánština (cyrilice, Ázerbájdžán)',
        'az-Latn' => 'ázerbájdžánština (latinka)',
        'az-Latn-AZ' => 'ázerbájdžánština (latinka, Ázerbájdžán)',
        'bas' => 'basa',
        'bas-CM' => 'basa (Kamerun)',
        'be' => 'běloruština',
        'be-BY' => 'běloruština (Bělorusko)',
        'bem' => 'bembština',
        'bem-ZM' => 'bembština (Zambie)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzanie)',
        'bg' => 'bulharština',
        'bg-BG' => 'bulharština (Bulharsko)',
        'bm' => 'bambarština',
        'bm-ML' => 'bambarština (Mali)',
        'bn' => 'bengálština',
        'bn-BD' => 'bengálština (Bangladéš)',
        'bn-IN' => 'bengálština (Indie)',
        'bo' => 'tibetština',
        'bo-CN' => 'tibetština (Čína)',
        'bo-IN' => 'tibetština (Indie)',
        'br' => 'bretonština',
        'br-FR' => 'bretonština (Francie)',
        'brx' => 'bodoština',
        'brx-IN' => 'bodoština (Indie)',
        'bs' => 'bosenština',
        'bs-Cyrl' => 'bosenština (cyrilice)',
        'bs-Cyrl-BA' => 'bosenština (cyrilice, Bosna a Hercegovina)',
        'bs-Latn' => 'bosenština (latinka)',
        'bs-Latn-BA' => 'bosenština (latinka, Bosna a Hercegovina)',
        'ca' => 'katalánština',
        'ca-AD' => 'katalánština (Andorra)',
        'ca-ES' => 'katalánština (Španělsko)',
        'ca-FR' => 'katalánština (Francie)',
        'ca-IT' => 'katalánština (Itálie)',
        'ccp' => 'čakma',
        'ccp-BD' => 'čakma (Bangladéš)',
        'ccp-IN' => 'čakma (Indie)',
        'ce' => 'čečenština',
        'ce-RU' => 'čečenština (Rusko)',
        'ceb' => 'cebuánština',
        'ceb-PH' => 'cebuánština (Filipíny)',
        'cgg' => 'kiga',
        'cgg-UG' => 'kiga (Uganda)',
        'chr' => 'čerokézština',
        'chr-US' => 'čerokézština (Spojené státy)',
        'ckb' => 'kurdština (sorání)',
        'ckb-IQ' => 'kurdština (sorání) (Irák)',
        'ckb-IR' => 'kurdština (sorání) (Írán)',
        'cs' => 'čeština',
        'cs-CZ' => 'čeština (Česko)',
        'cy' => 'velština',
        'cy-GB' => 'velština (Spojené království)',
        'da' => 'dánština',
        'da-DK' => 'dánština (Dánsko)',
        'da-GL' => 'dánština (Grónsko)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Keňa)',
        'de' => 'němčina',
        'de-AT' => 'němčina (Rakousko)',
        'de-BE' => 'němčina (Belgie)',
        'de-CH' => 'němčina (Švýcarsko)',
        'de-DE' => 'němčina (Německo)',
        'de-IT' => 'němčina (Itálie)',
        'de-LI' => 'němčina (Lichtenštejnsko)',
        'de-LU' => 'němčina (Lucembursko)',
        'dje' => 'zarmština',
        'dje-NE' => 'zarmština (Niger)',
        'dsb' => 'dolnolužická srbština',
        'dsb-DE' => 'dolnolužická srbština (Německo)',
        'dua' => 'dualština',
        'dua-CM' => 'dualština (Kamerun)',
        'dyo' => 'jola-fonyi',
        'dyo-SN' => 'jola-fonyi (Senegal)',
        'dz' => 'dzongkä',
        'dz-BT' => 'dzongkä (Bhútán)',
        'ebu' => 'embu',
        'ebu-KE' => 'embu (Keňa)',
        'ee' => 'eweština',
        'ee-GH' => 'eweština (Ghana)',
        'ee-TG' => 'eweština (Togo)',
        'el' => 'řečtina',
        'el-CY' => 'řečtina (Kypr)',
        'el-GR' => 'řečtina (Řecko)',
        'en' => 'angličtina',
        'en-001' => 'angličtina (svět)',
        'en-150' => 'angličtina (Evropa)',
        'en-AE' => 'angličtina (Spojené arabské emiráty)',
        'en-AG' => 'angličtina (Antigua a Barbuda)',
        'en-AI' => 'angličtina (Anguilla)',
        'en-AS' => 'angličtina (Americká Samoa)',
        'en-AT' => 'angličtina (Rakousko)',
        'en-AU' => 'angličtina (Austrálie)',
        'en-BB' => 'angličtina (Barbados)',
        'en-BE' => 'angličtina (Belgie)',
        'en-BI' => 'angličtina (Burundi)',
        'en-BM' => 'angličtina (Bermudy)',
        'en-BS' => 'angličtina (Bahamy)',
        'en-BW' => 'angličtina (Botswana)',
        'en-BZ' => 'angličtina (Belize)',
        'en-CA' => 'angličtina (Kanada)',
        'en-CC' => 'angličtina (Kokosové ostrovy)',
        'en-CH' => 'angličtina (Švýcarsko)',
        'en-CK' => 'angličtina (Cookovy ostrovy)',
        'en-CM' => 'angličtina (Kamerun)',
        'en-CX' => 'angličtina (Vánoční ostrov)',
        'en-CY' => 'angličtina (Kypr)',
        'en-DE' => 'angličtina (Německo)',
        'en-DG' => 'angličtina (Diego García)',
        'en-DK' => 'angličtina (Dánsko)',
        'en-DM' => 'angličtina (Dominika)',
        'en-ER' => 'angličtina (Eritrea)',
        'en-FI' => 'angličtina (Finsko)',
        'en-FJ' => 'angličtina (Fidži)',
        'en-FK' => 'angličtina (Falklandské ostrovy)',
        'en-FM' => 'angličtina (Mikronésie)',
        'en-GB' => 'angličtina (Spojené království)',
        'en-GD' => 'angličtina (Grenada)',
        'en-GG' => 'angličtina (Guernsey)',
        'en-GH' => 'angličtina (Ghana)',
        'en-GI' => 'angličtina (Gibraltar)',
        'en-GM' => 'angličtina (Gambie)',
        'en-GU' => 'angličtina (Guam)',
        'en-GY' => 'angličtina (Guyana)',
        'en-HK' => 'angličtina (Hongkong – ZAO Číny)',
        'en-IE' => 'angličtina (Irsko)',
        'en-IL' => 'angličtina (Izrael)',
        'en-IM' => 'angličtina (Ostrov Man)',
        'en-IN' => 'angličtina (Indie)',
        'en-IO' => 'angličtina (Britské indickooceánské území)',
        'en-JE' => 'angličtina (Jersey)',
        'en-JM' => 'angličtina (Jamajka)',
        'en-KE' => 'angličtina (Keňa)',
        'en-KI' => 'angličtina (Kiribati)',
        'en-KN' => 'angličtina (Svatý Kryštof a Nevis)',
        'en-KY' => 'angličtina (Kajmanské ostrovy)',
        'en-LC' => 'angličtina (Svatá Lucie)',
        'en-LR' => 'angličtina (Libérie)',
        'en-LS' => 'angličtina (Lesotho)',
        'en-MG' => 'angličtina (Madagaskar)',
        'en-MH' => 'angličtina (Marshallovy ostrovy)',
        'en-MO' => 'angličtina (Macao – ZAO Číny)',
        'en-MP' => 'angličtina (Severní Mariany)',
        'en-MS' => 'angličtina (Montserrat)',
        'en-MT' => 'angličtina (Malta)',
        'en-MU' => 'angličtina (Mauricius)',
        'en-MW' => 'angličtina (Malawi)',
        'en-MY' => 'angličtina (Malajsie)',
        'en-NA' => 'angličtina (Namibie)',
        'en-NF' => 'angličtina (Norfolk)',
        'en-NG' => 'angličtina (Nigérie)',
        'en-NL' => 'angličtina (Nizozemsko)',
        'en-NR' => 'angličtina (Nauru)',
        'en-NU' => 'angličtina (Niue)',
        'en-NZ' => 'angličtina (Nový Zéland)',
        'en-PG' => 'angličtina (Papua-Nová Guinea)',
        'en-PH' => 'angličtina (Filipíny)',
        'en-PK' => 'angličtina (Pákistán)',
        'en-PN' => 'angličtina (Pitcairnovy ostrovy)',
        'en-PR' => 'angličtina (Portoriko)',
        'en-PW' => 'angličtina (Palau)',
        'en-RW' => 'angličtina (Rwanda)',
        'en-SB' => 'angličtina (Šalamounovy ostrovy)',
        'en-SC' => 'angličtina (Seychely)',
        'en-SD' => 'angličtina (Súdán)',
        'en-SE' => 'angličtina (Švédsko)',
        'en-SG' => 'angličtina (Singapur)',
        'en-SH' => 'angličtina (Svatá Helena)',
        'en-SI' => 'angličtina (Slovinsko)',
        'en-SL' => 'angličtina (Sierra Leone)',
        'en-SS' => 'angličtina (Jižní Súdán)',
        'en-SX' => 'angličtina (Svatý Martin [Nizozemsko])',
        'en-SZ' => 'angličtina (Svazijsko)',
        'en-TC' => 'angličtina (Turks a Caicos)',
        'en-TK' => 'angličtina (Tokelau)',
        'en-TO' => 'angličtina (Tonga)',
        'en-TT' => 'angličtina (Trinidad a Tobago)',
        'en-TV' => 'angličtina (Tuvalu)',
        'en-TZ' => 'angličtina (Tanzanie)',
        'en-UG' => 'angličtina (Uganda)',
        'en-UM' => 'angličtina (Menší odlehlé ostrovy USA)',
        'en-US' => 'angličtina (Spojené státy)',
        'en-US-POSIX' => 'angličtina (Spojené státy, POSIX)',
        'en-VC' => 'angličtina (Svatý Vincenc a Grenadiny)',
        'en-VG' => 'angličtina (Britské Panenské ostrovy)',
        'en-VI' => 'angličtina (Americké Panenské ostrovy)',
        'en-VU' => 'angličtina (Vanuatu)',
        'en-WS' => 'angličtina (Samoa)',
        'en-ZA' => 'angličtina (Jihoafrická republika)',
        'en-ZM' => 'angličtina (Zambie)',
        'en-ZW' => 'angličtina (Zimbabwe)',
        'eo' => 'esperanto',
        'eo-001' => 'esperanto (svět)',
        'es' => 'španělština',
        'es-419' => 'španělština (Latinská Amerika)',
        'es-AR' => 'španělština (Argentina)',
        'es-BO' => 'španělština (Bolívie)',
        'es-BR' => 'španělština (Brazílie)',
        'es-BZ' => 'španělština (Belize)',
        'es-CL' => 'španělština (Chile)',
        'es-CO' => 'španělština (Kolumbie)',
        'es-CR' => 'španělština (Kostarika)',
        'es-CU' => 'španělština (Kuba)',
        'es-DO' => 'španělština (Dominikánská republika)',
        'es-EA' => 'španělština (Ceuta a Melilla)',
        'es-EC' => 'španělština (Ekvádor)',
        'es-ES' => 'španělština (Španělsko)',
        'es-GQ' => 'španělština (Rovníková Guinea)',
        'es-GT' => 'španělština (Guatemala)',
        'es-HN' => 'španělština (Honduras)',
        'es-IC' => 'španělština (Kanárské ostrovy)',
        'es-MX' => 'španělština (Mexiko)',
        'es-NI' => 'španělština (Nikaragua)',
        'es-PA' => 'španělština (Panama)',
        'es-PE' => 'španělština (Peru)',
        'es-PH' => 'španělština (Filipíny)',
        'es-PR' => 'španělština (Portoriko)',
        'es-PY' => 'španělština (Paraguay)',
        'es-SV' => 'španělština (Salvador)',
        'es-US' => 'španělština (Spojené státy)',
        'es-UY' => 'španělština (Uruguay)',
        'es-VE' => 'španělština (Venezuela)',
        'et' => 'estonština',
        'et-EE' => 'estonština (Estonsko)',
        'eu' => 'baskičtina',
        'eu-ES' => 'baskičtina (Španělsko)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Kamerun)',
        'fa' => 'perština',
        'fa-AF' => 'perština (Afghánistán)',
        'fa-IR' => 'perština (Írán)',
        'ff' => 'fulbština',
        'ff-Latn' => 'fulbština (latinka)',
        'ff-Latn-BF' => 'fulbština (latinka, Burkina Faso)',
        'ff-Latn-CM' => 'fulbština (latinka, Kamerun)',
        'ff-Latn-GH' => 'fulbština (latinka, Ghana)',
        'ff-Latn-GM' => 'fulbština (latinka, Gambie)',
        'ff-Latn-GN' => 'fulbština (latinka, Guinea)',
        'ff-Latn-GW' => 'fulbština (latinka, Guinea-Bissau)',
        'ff-Latn-LR' => 'fulbština (latinka, Libérie)',
        'ff-Latn-MR' => 'fulbština (latinka, Mauritánie)',
        'ff-Latn-NE' => 'fulbština (latinka, Niger)',
        'ff-Latn-NG' => 'fulbština (latinka, Nigérie)',
        'ff-Latn-SL' => 'fulbština (latinka, Sierra Leone)',
        'ff-Latn-SN' => 'fulbština (latinka, Senegal)',
        'fi' => 'finština',
        'fi-FI' => 'finština (Finsko)',
        'fil' => 'filipínština',
        'fil-PH' => 'filipínština (Filipíny)',
        'fo' => 'faerština',
        'fo-DK' => 'faerština (Dánsko)',
        'fo-FO' => 'faerština (Faerské ostrovy)',
        'fr' => 'francouzština',
        'fr-BE' => 'francouzština (Belgie)',
        'fr-BF' => 'francouzština (Burkina Faso)',
        'fr-BI' => 'francouzština (Burundi)',
        'fr-BJ' => 'francouzština (Benin)',
        'fr-BL' => 'francouzština (Svatý Bartoloměj)',
        'fr-CA' => 'francouzština (Kanada)',
        'fr-CD' => 'francouzština (Kongo – Kinshasa)',
        'fr-CF' => 'francouzština (Středoafrická republika)',
        'fr-CG' => 'francouzština (Kongo – Brazzaville)',
        'fr-CH' => 'francouzština (Švýcarsko)',
        'fr-CI' => 'francouzština (Pobřeží slonoviny)',
        'fr-CM' => 'francouzština (Kamerun)',
        'fr-DJ' => 'francouzština (Džibutsko)',
        'fr-DZ' => 'francouzština (Alžírsko)',
        'fr-FR' => 'francouzština (Francie)',
        'fr-GA' => 'francouzština (Gabon)',
        'fr-GF' => 'francouzština (Francouzská Guyana)',
        'fr-GN' => 'francouzština (Guinea)',
        'fr-GP' => 'francouzština (Guadeloupe)',
        'fr-GQ' => 'francouzština (Rovníková Guinea)',
        'fr-HT' => 'francouzština (Haiti)',
        'fr-KM' => 'francouzština (Komory)',
        'fr-LU' => 'francouzština (Lucembursko)',
        'fr-MA' => 'francouzština (Maroko)',
        'fr-MC' => 'francouzština (Monako)',
        'fr-MF' => 'francouzština (Svatý Martin [Francie])',
        'fr-MG' => 'francouzština (Madagaskar)',
        'fr-ML' => 'francouzština (Mali)',
        'fr-MQ' => 'francouzština (Martinik)',
        'fr-MR' => 'francouzština (Mauritánie)',
        'fr-MU' => 'francouzština (Mauricius)',
        'fr-NC' => 'francouzština (Nová Kaledonie)',
        'fr-NE' => 'francouzština (Niger)',
        'fr-PF' => 'francouzština (Francouzská Polynésie)',
        'fr-PM' => 'francouzština (Saint-Pierre a Miquelon)',
        'fr-RE' => 'francouzština (Réunion)',
        'fr-RW' => 'francouzština (Rwanda)',
        'fr-SC' => 'francouzština (Seychely)',
        'fr-SN' => 'francouzština (Senegal)',
        'fr-SY' => 'francouzština (Sýrie)',
        'fr-TD' => 'francouzština (Čad)',
        'fr-TG' => 'francouzština (Togo)',
        'fr-TN' => 'francouzština (Tunisko)',
        'fr-VU' => 'francouzština (Vanuatu)',
        'fr-WF' => 'francouzština (Wallis a Futuna)',
        'fr-YT' => 'francouzština (Mayotte)',
        'fur' => 'furlanština',
        'fur-IT' => 'furlanština (Itálie)',
        'fy' => 'fríština (západní)',
        'fy-NL' => 'fríština (západní) (Nizozemsko)',
        'ga' => 'irština',
        'ga-IE' => 'irština (Irsko)',
        'gd' => 'skotská gaelština',
        'gd-GB' => 'skotská gaelština (Spojené království)',
        'gl' => 'galicijština',
        'gl-ES' => 'galicijština (Španělsko)',
        'gsw' => 'němčina (Švýcarsko)',
        'gsw-CH' => 'němčina (Švýcarsko) (Švýcarsko)',
        'gsw-FR' => 'němčina (Švýcarsko) (Francie)',
        'gsw-LI' => 'němčina (Švýcarsko) (Lichtenštejnsko)',
        'gu' => 'gudžarátština',
        'gu-IN' => 'gudžarátština (Indie)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Keňa)',
        'gv' => 'manština',
        'gv-IM' => 'manština (Ostrov Man)',
        'ha' => 'hauština',
        'ha-GH' => 'hauština (Ghana)',
        'ha-NE' => 'hauština (Niger)',
        'ha-NG' => 'hauština (Nigérie)',
        'haw' => 'havajština',
        'haw-US' => 'havajština (Spojené státy)',
        'he' => 'hebrejština',
        'he-IL' => 'hebrejština (Izrael)',
        'hi' => 'hindština',
        'hi-IN' => 'hindština (Indie)',
        'hr' => 'chorvatština',
        'hr-BA' => 'chorvatština (Bosna a Hercegovina)',
        'hr-HR' => 'chorvatština (Chorvatsko)',
        'hsb' => 'hornolužická srbština',
        'hsb-DE' => 'hornolužická srbština (Německo)',
        'hu' => 'maďarština',
        'hu-HU' => 'maďarština (Maďarsko)',
        'hy' => 'arménština',
        'hy-AM' => 'arménština (Arménie)',
        'ia' => 'interlingua',
        'ia-001' => 'interlingua (svět)',
        'id' => 'indonéština',
        'id-ID' => 'indonéština (Indonésie)',
        'ig' => 'igboština',
        'ig-NG' => 'igboština (Nigérie)',
        'ii' => 'iština (sečuánská)',
        'ii-CN' => 'iština (sečuánská) (Čína)',
        'is' => 'islandština',
        'is-IS' => 'islandština (Island)',
        'it' => 'italština',
        'it-CH' => 'italština (Švýcarsko)',
        'it-IT' => 'italština (Itálie)',
        'it-SM' => 'italština (San Marino)',
        'it-VA' => 'italština (Vatikán)',
        'ja' => 'japonština',
        'ja-JP' => 'japonština (Japonsko)',
        'jgo' => 'ngomba',
        'jgo-CM' => 'ngomba (Kamerun)',
        'jmc' => 'mašame',
        'jmc-TZ' => 'mašame (Tanzanie)',
        'jv' => 'javánština',
        'jv-ID' => 'javánština (Indonésie)',
        'ka' => 'gruzínština',
        'ka-GE' => 'gruzínština (Gruzie)',
        'kab' => 'kabylština',
        'kab-DZ' => 'kabylština (Alžírsko)',
        'kam' => 'kambština',
        'kam-KE' => 'kambština (Keňa)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzanie)',
        'kea' => 'kapverdština',
        'kea-CV' => 'kapverdština (Kapverdy)',
        'khq' => 'koyra chiini',
        'khq-ML' => 'koyra chiini (Mali)',
        'ki' => 'kikujština',
        'ki-KE' => 'kikujština (Keňa)',
        'kk' => 'kazaština',
        'kk-KZ' => 'kazaština (Kazachstán)',
        'kkj' => 'kako',
        'kkj-CM' => 'kako (Kamerun)',
        'kl' => 'grónština',
        'kl-GL' => 'grónština (Grónsko)',
        'kln' => 'kalendžin',
        'kln-KE' => 'kalendžin (Keňa)',
        'km' => 'khmérština',
        'km-KH' => 'khmérština (Kambodža)',
        'kn' => 'kannadština',
        'kn-IN' => 'kannadština (Indie)',
        'ko' => 'korejština',
        'ko-KP' => 'korejština (Severní Korea)',
        'ko-KR' => 'korejština (Jižní Korea)',
        'kok' => 'konkánština',
        'kok-IN' => 'konkánština (Indie)',
        'ks' => 'kašmírština',
        'ks-IN' => 'kašmírština (Indie)',
        'ksb' => 'šambala',
        'ksb-TZ' => 'šambala (Tanzanie)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Kamerun)',
        'ksh' => 'kolínština',
        'ksh-DE' => 'kolínština (Německo)',
        'ku' => 'kurdština',
        'ku-TR' => 'kurdština (Turecko)',
        'kw' => 'kornština',
        'kw-GB' => 'kornština (Spojené království)',
        'ky' => 'kyrgyzština',
        'ky-KG' => 'kyrgyzština (Kyrgyzstán)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzanie)',
        'lb' => 'lucemburština',
        'lb-LU' => 'lucemburština (Lucembursko)',
        'lg' => 'gandština',
        'lg-UG' => 'gandština (Uganda)',
        'lkt' => 'lakotština',
        'lkt-US' => 'lakotština (Spojené státy)',
        'ln' => 'lingalština',
        'ln-AO' => 'lingalština (Angola)',
        'ln-CD' => 'lingalština (Kongo – Kinshasa)',
        'ln-CF' => 'lingalština (Středoafrická republika)',
        'ln-CG' => 'lingalština (Kongo – Brazzaville)',
        'lo' => 'laoština',
        'lo-LA' => 'laoština (Laos)',
        'lrc' => 'lúrština (severní)',
        'lrc-IQ' => 'lúrština (severní) (Irák)',
        'lrc-IR' => 'lúrština (severní) (Írán)',
        'lt' => 'litevština',
        'lt-LT' => 'litevština (Litva)',
        'lu' => 'lubu-katanžština',
        'lu-CD' => 'lubu-katanžština (Kongo – Kinshasa)',
        'luo' => 'luoština',
        'luo-KE' => 'luoština (Keňa)',
        'luy' => 'luhja',
        'luy-KE' => 'luhja (Keňa)',
        'lv' => 'lotyština',
        'lv-LV' => 'lotyština (Lotyšsko)',
        'mas' => 'masajština',
        'mas-KE' => 'masajština (Keňa)',
        'mas-TZ' => 'masajština (Tanzanie)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Keňa)',
        'mfe' => 'mauricijská kreolština',
        'mfe-MU' => 'mauricijská kreolština (Mauricius)',
        'mg' => 'malgaština',
        'mg-MG' => 'malgaština (Madagaskar)',
        'mgh' => 'makhuwa-meetto',
        'mgh-MZ' => 'makhuwa-meetto (Mosambik)',
        'mgo' => 'meta’',
        'mgo-CM' => 'meta’ (Kamerun)',
        'mi' => 'maorština',
        'mi-NZ' => 'maorština (Nový Zéland)',
        'mk' => 'makedonština',
        'mk-MK' => 'makedonština (Severní Makedonie)',
        'ml' => 'malajálamština',
        'ml-IN' => 'malajálamština (Indie)',
        'mn' => 'mongolština',
        'mn-MN' => 'mongolština (Mongolsko)',
        'mr' => 'maráthština',
        'mr-IN' => 'maráthština (Indie)',
        'ms' => 'malajština',
        'ms-BN' => 'malajština (Brunej)',
        'ms-MY' => 'malajština (Malajsie)',
        'ms-SG' => 'malajština (Singapur)',
        'mt' => 'maltština',
        'mt-MT' => 'maltština (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Kamerun)',
        'my' => 'barmština',
        'my-MM' => 'barmština (Myanmar [Barma])',
        'mzn' => 'mázandaránština',
        'mzn-IR' => 'mázandaránština (Írán)',
        'naq' => 'namaština',
        'naq-NA' => 'namaština (Namibie)',
        'nb' => 'norština (bokmål)',
        'nb-NO' => 'norština (bokmål) (Norsko)',
        'nb-SJ' => 'norština (bokmål) (Špicberky a Jan Mayen)',
        'nd' => 'ndebele (Zimbabwe)',
        'nd-ZW' => 'ndebele (Zimbabwe) (Zimbabwe)',
        'nds' => 'dolnoněmčina',
        'nds-DE' => 'dolnoněmčina (Německo)',
        'nds-NL' => 'dolnoněmčina (Nizozemsko)',
        'ne' => 'nepálština',
        'ne-IN' => 'nepálština (Indie)',
        'ne-NP' => 'nepálština (Nepál)',
        'nl' => 'nizozemština',
        'nl-AW' => 'nizozemština (Aruba)',
        'nl-BE' => 'nizozemština (Belgie)',
        'nl-BQ' => 'nizozemština (Karibské Nizozemsko)',
        'nl-CW' => 'nizozemština (Curaçao)',
        'nl-NL' => 'nizozemština (Nizozemsko)',
        'nl-SR' => 'nizozemština (Surinam)',
        'nl-SX' => 'nizozemština (Svatý Martin [Nizozemsko])',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Kamerun)',
        'nn' => 'norština (nynorsk)',
        'nn-NO' => 'norština (nynorsk) (Norsko)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Kamerun)',
        'nus' => 'nuerština',
        'nus-SS' => 'nuerština (Jižní Súdán)',
        'nyn' => 'ňankolština',
        'nyn-UG' => 'ňankolština (Uganda)',
        'om' => 'oromština',
        'om-ET' => 'oromština (Etiopie)',
        'om-KE' => 'oromština (Keňa)',
        'or' => 'urijština',
        'or-IN' => 'urijština (Indie)',
        'os' => 'osetština',
        'os-GE' => 'osetština (Gruzie)',
        'os-RU' => 'osetština (Rusko)',
        'pa' => 'paňdžábština',
        'pa-Arab' => 'paňdžábština (arabské)',
        'pa-Arab-PK' => 'paňdžábština (arabské, Pákistán)',
        'pa-Guru' => 'paňdžábština (gurmukhi)',
        'pa-Guru-IN' => 'paňdžábština (gurmukhi, Indie)',
        'pl' => 'polština',
        'pl-PL' => 'polština (Polsko)',
        'ps' => 'paštština',
        'ps-AF' => 'paštština (Afghánistán)',
        'ps-PK' => 'paštština (Pákistán)',
        'pt' => 'portugalština',
        'pt-AO' => 'portugalština (Angola)',
        'pt-BR' => 'portugalština (Brazílie)',
        'pt-CH' => 'portugalština (Švýcarsko)',
        'pt-CV' => 'portugalština (Kapverdy)',
        'pt-GQ' => 'portugalština (Rovníková Guinea)',
        'pt-GW' => 'portugalština (Guinea-Bissau)',
        'pt-LU' => 'portugalština (Lucembursko)',
        'pt-MO' => 'portugalština (Macao – ZAO Číny)',
        'pt-MZ' => 'portugalština (Mosambik)',
        'pt-PT' => 'portugalština (Portugalsko)',
        'pt-ST' => 'portugalština (Svatý Tomáš a Princův ostrov)',
        'pt-TL' => 'portugalština (Východní Timor)',
        'qu' => 'kečuánština',
        'qu-BO' => 'kečuánština (Bolívie)',
        'qu-EC' => 'kečuánština (Ekvádor)',
        'qu-PE' => 'kečuánština (Peru)',
        'rm' => 'rétorománština',
        'rm-CH' => 'rétorománština (Švýcarsko)',
        'rn' => 'kirundština',
        'rn-BI' => 'kirundština (Burundi)',
        'ro' => 'rumunština',
        'ro-MD' => 'rumunština (Moldavsko)',
        'ro-RO' => 'rumunština (Rumunsko)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzanie)',
        'ru' => 'ruština',
        'ru-BY' => 'ruština (Bělorusko)',
        'ru-KG' => 'ruština (Kyrgyzstán)',
        'ru-KZ' => 'ruština (Kazachstán)',
        'ru-MD' => 'ruština (Moldavsko)',
        'ru-RU' => 'ruština (Rusko)',
        'ru-UA' => 'ruština (Ukrajina)',
        'rw' => 'kiňarwandština',
        'rw-RW' => 'kiňarwandština (Rwanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzanie)',
        'sah' => 'jakutština',
        'sah-RU' => 'jakutština (Rusko)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Keňa)',
        'sbp' => 'sangoština',
        'sbp-TZ' => 'sangoština (Tanzanie)',
        'sd' => 'sindhština',
        'sd-PK' => 'sindhština (Pákistán)',
        'se' => 'sámština (severní)',
        'se-FI' => 'sámština (severní) (Finsko)',
        'se-NO' => 'sámština (severní) (Norsko)',
        'se-SE' => 'sámština (severní) (Švédsko)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Mosambik)',
        'ses' => 'koyraboro senni',
        'ses-ML' => 'koyraboro senni (Mali)',
        'sg' => 'sangština',
        'sg-CF' => 'sangština (Středoafrická republika)',
        'shi' => 'tašelhit',
        'shi-Latn' => 'tašelhit (latinka)',
        'shi-Latn-MA' => 'tašelhit (latinka, Maroko)',
        'shi-Tfng' => 'tašelhit (berberské)',
        'shi-Tfng-MA' => 'tašelhit (berberské, Maroko)',
        'si' => 'sinhálština',
        'si-LK' => 'sinhálština (Srí Lanka)',
        'sk' => 'slovenština',
        'sk-SK' => 'slovenština (Slovensko)',
        'sl' => 'slovinština',
        'sl-SI' => 'slovinština (Slovinsko)',
        'smn' => 'sámština (inarijská)',
        'smn-FI' => 'sámština (inarijská) (Finsko)',
        'sn' => 'šonština',
        'sn-ZW' => 'šonština (Zimbabwe)',
        'so' => 'somálština',
        'so-DJ' => 'somálština (Džibutsko)',
        'so-ET' => 'somálština (Etiopie)',
        'so-KE' => 'somálština (Keňa)',
        'so-SO' => 'somálština (Somálsko)',
        'sq' => 'albánština',
        'sq-AL' => 'albánština (Albánie)',
        'sq-MK' => 'albánština (Severní Makedonie)',
        'sq-XK' => 'albánština (Kosovo)',
        'sr' => 'srbština',
        'sr-Cyrl' => 'srbština (cyrilice)',
        'sr-Cyrl-BA' => 'srbština (cyrilice, Bosna a Hercegovina)',
        'sr-Cyrl-ME' => 'srbština (cyrilice, Černá Hora)',
        'sr-Cyrl-RS' => 'srbština (cyrilice, Srbsko)',
        'sr-Cyrl-XK' => 'srbština (cyrilice, Kosovo)',
        'sr-Latn' => 'srbština (latinka)',
        'sr-Latn-BA' => 'srbština (latinka, Bosna a Hercegovina)',
        'sr-Latn-ME' => 'srbština (latinka, Černá Hora)',
        'sr-Latn-RS' => 'srbština (latinka, Srbsko)',
        'sr-Latn-XK' => 'srbština (latinka, Kosovo)',
        'sv' => 'švédština',
        'sv-AX' => 'švédština (Ålandy)',
        'sv-FI' => 'švédština (Finsko)',
        'sv-SE' => 'švédština (Švédsko)',
        'sw' => 'svahilština',
        'sw-CD' => 'svahilština (Kongo – Kinshasa)',
        'sw-KE' => 'svahilština (Keňa)',
        'sw-TZ' => 'svahilština (Tanzanie)',
        'sw-UG' => 'svahilština (Uganda)',
        'ta' => 'tamilština',
        'ta-IN' => 'tamilština (Indie)',
        'ta-LK' => 'tamilština (Srí Lanka)',
        'ta-MY' => 'tamilština (Malajsie)',
        'ta-SG' => 'tamilština (Singapur)',
        'te' => 'telugština',
        'te-IN' => 'telugština (Indie)',
        'teo' => 'teso',
        'teo-KE' => 'teso (Keňa)',
        'teo-UG' => 'teso (Uganda)',
        'tg' => 'tádžičtina',
        'tg-TJ' => 'tádžičtina (Tádžikistán)',
        'th' => 'thajština',
        'th-TH' => 'thajština (Thajsko)',
        'ti' => 'tigrinijština',
        'ti-ER' => 'tigrinijština (Eritrea)',
        'ti-ET' => 'tigrinijština (Etiopie)',
        'tk' => 'turkmenština',
        'tk-TM' => 'turkmenština (Turkmenistán)',
        'to' => 'tongánština',
        'to-TO' => 'tongánština (Tonga)',
        'tr' => 'turečtina',
        'tr-CY' => 'turečtina (Kypr)',
        'tr-TR' => 'turečtina (Turecko)',
        'tt' => 'tatarština',
        'tt-RU' => 'tatarština (Rusko)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Niger)',
        'tzm' => 'tamazight (střední Maroko)',
        'tzm-MA' => 'tamazight (střední Maroko) (Maroko)',
        'ug' => 'ujgurština',
        'ug-CN' => 'ujgurština (Čína)',
        'uk' => 'ukrajinština',
        'uk-UA' => 'ukrajinština (Ukrajina)',
        'ur' => 'urdština',
        'ur-IN' => 'urdština (Indie)',
        'ur-PK' => 'urdština (Pákistán)',
        'uz' => 'uzbečtina',
        'uz-Arab' => 'uzbečtina (arabské)',
        'uz-Arab-AF' => 'uzbečtina (arabské, Afghánistán)',
        'uz-Cyrl' => 'uzbečtina (cyrilice)',
        'uz-Cyrl-UZ' => 'uzbečtina (cyrilice, Uzbekistán)',
        'uz-Latn' => 'uzbečtina (latinka)',
        'uz-Latn-UZ' => 'uzbečtina (latinka, Uzbekistán)',
        'vai' => 'vai',
        'vai-Latn' => 'vai (latinka)',
        'vai-Latn-LR' => 'vai (latinka, Libérie)',
        'vai-Vaii' => 'vai (vai)',
        'vai-Vaii-LR' => 'vai (vai, Libérie)',
        'vi' => 'vietnamština',
        'vi-VN' => 'vietnamština (Vietnam)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzanie)',
        'wae' => 'němčina (walser)',
        'wae-CH' => 'němčina (walser) (Švýcarsko)',
        'wo' => 'wolofština',
        'wo-SN' => 'wolofština (Senegal)',
        'xh' => 'xhoština',
        'xh-ZA' => 'xhoština (Jihoafrická republika)',
        'xog' => 'sogština',
        'xog-UG' => 'sogština (Uganda)',
        'yav' => 'jangbenština',
        'yav-CM' => 'jangbenština (Kamerun)',
        'yi' => 'jidiš',
        'yi-001' => 'jidiš (svět)',
        'yo' => 'jorubština',
        'yo-BJ' => 'jorubština (Benin)',
        'yo-NG' => 'jorubština (Nigérie)',
        'yue' => 'kantonština',
        'yue-Hans' => 'kantonština (zjednodušené)',
        'yue-Hans-CN' => 'kantonština (zjednodušené, Čína)',
        'yue-Hant' => 'kantonština (tradiční)',
        'yue-Hant-HK' => 'kantonština (tradiční, Hongkong – ZAO Číny)',
        'zgh' => 'tamazight (standardní marocký)',
        'zgh-MA' => 'tamazight (standardní marocký) (Maroko)',
        'zh' => 'čínština',
        'zh-Hans' => 'čínština (zjednodušené)',
        'zh-Hans-CN' => 'čínština (zjednodušené, Čína)',
        'zh-Hans-HK' => 'čínština (zjednodušené, Hongkong – ZAO Číny)',
        'zh-Hans-MO' => 'čínština (zjednodušené, Macao – ZAO Číny)',
        'zh-Hans-SG' => 'čínština (zjednodušené, Singapur)',
        'zh-Hant' => 'čínština (tradiční)',
        'zh-Hant-HK' => 'čínština (tradiční, Hongkong – ZAO Číny)',
        'zh-Hant-MO' => 'čínština (tradiční, Macao – ZAO Číny)',
        'zh-Hant-TW' => 'čínština (tradiční, Tchaj-wan)',
        'zu' => 'zuluština',
        'zu-ZA' => 'zuluština (Jihoafrická republika)',
    ],
];
