<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'y/M/d',
            'time' => 'H:mm',
            'datetime' => 'y/M/d،‏ H:mm',
        ],
        'medium' => [
            'date' => 'd MMM y',
            'time' => 'H:mm:ss',
            'datetime' => 'd MMM y،‏ H:mm:ss',
        ],
        'long' => [
            'date' => 'd MMMM y',
            'time' => 'H:mm:ss (z)',
            'datetime' => 'd MMMM y، ساعت H:mm:ss (z)',
        ],
        'full' => [
            'date' => 'y MMMM d, EEEE',
            'time' => 'H:mm:ss (zzzz)',
            'datetime' => 'y MMMM d, EEEE، ساعت H:mm:ss (zzzz)',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '‎¤#,##0.00',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'قبل‌ازظهر',
    'pmName' => 'بعدازظهر',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '‎−',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '٫',
        'groupingSeparator' => '٬',
        'patternSeparator' => ';',
        'percent' => '٪',
        'zeroDigit' => '۰',
        'digit' => '#',
        'minusSign' => '‎−',
        'plusSign' => '‎+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => '٫',
        'exponential' => '×۱۰^',
        'permill' => '؉',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'ناعدد',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '٬',
    ],
    'currencySymbols' => [
        'AUD' => 'A$',
        'BRL' => 'R$',
        'CAD' => '$CA ',
        'CNY' => '¥CN ',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => '$HK ',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => '¥',
        'KRW' => '₩',
        'MXN' => '$MX ',
        'NZD' => '$NZ ',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => '$EC ',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'ژ',
            'ف',
            'م',
            'آ',
            'م',
            'ژ',
            'ژ',
            'ا',
            'س',
            'ا',
            'ن',
            'د',
        ],
        'medium' => [
            'ژانویه',
            'فوریه',
            'مارس',
            'آوریل',
            'مه',
            'ژوئن',
            'ژوئیه',
            'اوت',
            'سپتامبر',
            'اکتبر',
            'نوامبر',
            'دسامبر',
        ],
        'full' => [
            'ژانویه',
            'فوریه',
            'مارس',
            'آوریل',
            'مه',
            'ژوئن',
            'ژوئیه',
            'اوت',
            'سپتامبر',
            'اکتبر',
            'نوامبر',
            'دسامبر',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'ژ',
            'ف',
            'م',
            'آ',
            'م',
            'ژ',
            'ژ',
            'ا',
            'س',
            'ا',
            'ن',
            'د',
        ],
        'medium' => [
            'ژانویهٔ',
            'فوریهٔ',
            'مارس',
            'آوریل',
            'مهٔ',
            'ژوئن',
            'ژوئیهٔ',
            'اوت',
            'سپتامبر',
            'اکتبر',
            'نوامبر',
            'دسامبر',
        ],
        'full' => [
            'ژانویهٔ',
            'فوریهٔ',
            'مارس',
            'آوریل',
            'مهٔ',
            'ژوئن',
            'ژوئیهٔ',
            'اوت',
            'سپتامبر',
            'اکتبر',
            'نوامبر',
            'دسامبر',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'ی',
            'د',
            'س',
            'چ',
            'پ',
            'ج',
            'ش',
        ],
        'short' => [
            '۱ش',
            '۲ش',
            '۳ش',
            '۴ش',
            '۵ش',
            'ج',
            'ش',
        ],
        'medium' => [
            'یکشنبه',
            'دوشنبه',
            'سه‌شنبه',
            'چهارشنبه',
            'پنجشنبه',
            'جمعه',
            'شنبه',
        ],
        'full' => [
            'یکشنبه',
            'دوشنبه',
            'سه‌شنبه',
            'چهارشنبه',
            'پنجشنبه',
            'جمعه',
            'شنبه',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'ی',
            'د',
            'س',
            'چ',
            'پ',
            'ج',
            'ش',
        ],
        'short' => [
            '۱ش',
            '۲ش',
            '۳ش',
            '۴ش',
            '۵ش',
            'ج',
            'ش',
        ],
        'medium' => [
            'یکشنبه',
            'دوشنبه',
            'سه‌شنبه',
            'چهارشنبه',
            'پنجشنبه',
            'جمعه',
            'شنبه',
        ],
        'full' => [
            'یکشنبه',
            'دوشنبه',
            'سه‌شنبه',
            'چهارشنبه',
            'پنجشنبه',
            'جمعه',
            'شنبه',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'آفریکانس',
        'af-NA' => 'آفریکانس (نامیبیا)',
        'af-ZA' => 'آفریکانس (افریقای جنوبی)',
        'agq' => 'آگیم',
        'agq-CM' => 'آگیم (کامرون)',
        'ak' => 'آکان',
        'ak-GH' => 'آکان (غنا)',
        'am' => 'امهری',
        'am-ET' => 'امهری (اتیوپی)',
        'ar' => 'عربی',
        'ar-001' => 'عربی (جهان)',
        'ar-AE' => 'عربی (امارات متحدهٔ عربی)',
        'ar-BH' => 'عربی (بحرین)',
        'ar-DJ' => 'عربی (جیبوتی)',
        'ar-DZ' => 'عربی (الجزایر)',
        'ar-EG' => 'عربی (مصر)',
        'ar-EH' => 'عربی (صحرای غربی)',
        'ar-ER' => 'عربی (اریتره)',
        'ar-IL' => 'عربی (اسرائیل)',
        'ar-IQ' => 'عربی (عراق)',
        'ar-JO' => 'عربی (اردن)',
        'ar-KM' => 'عربی (کومور)',
        'ar-KW' => 'عربی (کویت)',
        'ar-LB' => 'عربی (لبنان)',
        'ar-LY' => 'عربی (لیبی)',
        'ar-MA' => 'عربی (مراکش)',
        'ar-MR' => 'عربی (موریتانی)',
        'ar-OM' => 'عربی (عمان)',
        'ar-PS' => 'عربی (سرزمین‌های فلسطینی)',
        'ar-QA' => 'عربی (قطر)',
        'ar-SA' => 'عربی (عربستان سعودی)',
        'ar-SD' => 'عربی (سودان)',
        'ar-SO' => 'عربی (سومالی)',
        'ar-SS' => 'عربی (سودان جنوبی)',
        'ar-SY' => 'عربی (سوریه)',
        'ar-TD' => 'عربی (چاد)',
        'ar-TN' => 'عربی (تونس)',
        'ar-YE' => 'عربی (یمن)',
        'as' => 'آسامی',
        'as-IN' => 'آسامی (هند)',
        'asa' => 'آسو',
        'asa-TZ' => 'آسو (تانزانیا)',
        'ast' => 'آستوری',
        'ast-ES' => 'آستوری (اسپانیا)',
        'az' => 'ترکی آذربایجانی',
        'az-Cyrl' => 'ترکی آذربایجانی (سیریلی)',
        'az-Cyrl-AZ' => 'ترکی آذربایجانی (سیریلی، جمهوری آذربایجان)',
        'az-Latn' => 'ترکی آذربایجانی (لاتینی)',
        'az-Latn-AZ' => 'ترکی آذربایجانی (لاتینی، جمهوری آذربایجان)',
        'bas' => 'باسایی',
        'bas-CM' => 'باسایی (کامرون)',
        'be' => 'بلاروسی',
        'be-BY' => 'بلاروسی (بلاروس)',
        'bem' => 'بمبایی',
        'bem-ZM' => 'بمبایی (زامبیا)',
        'bez' => 'بنایی',
        'bez-TZ' => 'بنایی (تانزانیا)',
        'bg' => 'بلغاری',
        'bg-BG' => 'بلغاری (بلغارستان)',
        'bm' => 'بامبارایی',
        'bm-ML' => 'بامبارایی (مالی)',
        'bn' => 'بنگالی',
        'bn-BD' => 'بنگالی (بنگلادش)',
        'bn-IN' => 'بنگالی (هند)',
        'bo' => 'تبتی',
        'bo-CN' => 'تبتی (چین)',
        'bo-IN' => 'تبتی (هند)',
        'br' => 'برتون',
        'br-FR' => 'برتون (فرانسه)',
        'brx' => 'بودویی',
        'brx-IN' => 'بودویی (هند)',
        'bs' => 'بوسنیایی',
        'bs-Cyrl' => 'بوسنیایی (سیریلی)',
        'bs-Cyrl-BA' => 'بوسنیایی (سیریلی، بوسنی و هرزگوین)',
        'bs-Latn' => 'بوسنیایی (لاتینی)',
        'bs-Latn-BA' => 'بوسنیایی (لاتینی، بوسنی و هرزگوین)',
        'ca' => 'کاتالان',
        'ca-AD' => 'کاتالان (آندورا)',
        'ca-ES' => 'کاتالان (اسپانیا)',
        'ca-FR' => 'کاتالان (فرانسه)',
        'ca-IT' => 'کاتالان (ایتالیا)',
        'ccp' => 'چاکما',
        'ccp-BD' => 'چاکما (بنگلادش)',
        'ccp-IN' => 'چاکما (هند)',
        'ce' => 'چچنی',
        'ce-RU' => 'چچنی (روسیه)',
        'ceb' => 'سبویی',
        'ceb-PH' => 'سبویی (فیلیپین)',
        'cgg' => 'چیگا',
        'cgg-UG' => 'چیگا (اوگاندا)',
        'chr' => 'چروکیایی',
        'chr-US' => 'چروکیایی (ایالات متحده)',
        'ckb' => 'کردی مرکزی',
        'ckb-IQ' => 'کردی مرکزی (عراق)',
        'ckb-IR' => 'کردی مرکزی (ایران)',
        'cs' => 'چکی',
        'cs-CZ' => 'چکی (جمهوری چک)',
        'cy' => 'ولزی',
        'cy-GB' => 'ولزی (بریتانیا)',
        'da' => 'دانمارکی',
        'da-DK' => 'دانمارکی (دانمارک)',
        'da-GL' => 'دانمارکی (گرینلند)',
        'dav' => 'تایتا',
        'dav-KE' => 'تایتا (کنیا)',
        'de' => 'آلمانی',
        'de-AT' => 'آلمانی (اتریش)',
        'de-BE' => 'آلمانی (بلژیک)',
        'de-CH' => 'آلمانی (سوئیس)',
        'de-DE' => 'آلمانی (آلمان)',
        'de-IT' => 'آلمانی (ایتالیا)',
        'de-LI' => 'آلمانی (لیختن‌اشتاین)',
        'de-LU' => 'آلمانی (لوکزامبورگ)',
        'dje' => 'زرما',
        'dje-NE' => 'زرما (نیجر)',
        'dsb' => 'صُربی سفلی',
        'dsb-DE' => 'صُربی سفلی (آلمان)',
        'dua' => 'دوآلایی',
        'dua-CM' => 'دوآلایی (کامرون)',
        'dyo' => 'دیولا فونی',
        'dyo-SN' => 'دیولا فونی (سنگال)',
        'dz' => 'دزونگخا',
        'dz-BT' => 'دزونگخا (بوتان)',
        'ebu' => 'امبو',
        'ebu-KE' => 'امبو (کنیا)',
        'ee' => 'اوه‌ای',
        'ee-GH' => 'اوه‌ای (غنا)',
        'ee-TG' => 'اوه‌ای (توگو)',
        'el' => 'یونانی',
        'el-CY' => 'یونانی (قبرس)',
        'el-GR' => 'یونانی (یونان)',
        'en' => 'انگلیسی',
        'en-001' => 'انگلیسی (جهان)',
        'en-150' => 'انگلیسی (اروپا)',
        'en-AE' => 'انگلیسی (امارات متحدهٔ عربی)',
        'en-AG' => 'انگلیسی (آنتیگوا و باربودا)',
        'en-AI' => 'انگلیسی (آنگویلا)',
        'en-AS' => 'انگلیسی (ساموآی امریکا)',
        'en-AT' => 'انگلیسی (اتریش)',
        'en-AU' => 'انگلیسی (استرالیا)',
        'en-BB' => 'انگلیسی (باربادوس)',
        'en-BE' => 'انگلیسی (بلژیک)',
        'en-BI' => 'انگلیسی (بوروندی)',
        'en-BM' => 'انگلیسی (برمودا)',
        'en-BS' => 'انگلیسی (باهاما)',
        'en-BW' => 'انگلیسی (بوتسوانا)',
        'en-BZ' => 'انگلیسی (بلیز)',
        'en-CA' => 'انگلیسی (کانادا)',
        'en-CC' => 'انگلیسی (جزایر کوکوس)',
        'en-CH' => 'انگلیسی (سوئیس)',
        'en-CK' => 'انگلیسی (جزایر کوک)',
        'en-CM' => 'انگلیسی (کامرون)',
        'en-CX' => 'انگلیسی (جزیرهٔ کریسمس)',
        'en-CY' => 'انگلیسی (قبرس)',
        'en-DE' => 'انگلیسی (آلمان)',
        'en-DG' => 'انگلیسی (دیه‌گو گارسیا)',
        'en-DK' => 'انگلیسی (دانمارک)',
        'en-DM' => 'انگلیسی (دومینیکا)',
        'en-ER' => 'انگلیسی (اریتره)',
        'en-FI' => 'انگلیسی (فنلاند)',
        'en-FJ' => 'انگلیسی (فیجی)',
        'en-FK' => 'انگلیسی (جزایر فالکلند)',
        'en-FM' => 'انگلیسی (میکرونزی)',
        'en-GB' => 'انگلیسی (بریتانیا)',
        'en-GD' => 'انگلیسی (گرنادا)',
        'en-GG' => 'انگلیسی (گرنزی)',
        'en-GH' => 'انگلیسی (غنا)',
        'en-GI' => 'انگلیسی (جبل‌الطارق)',
        'en-GM' => 'انگلیسی (گامبیا)',
        'en-GU' => 'انگلیسی (گوام)',
        'en-GY' => 'انگلیسی (گویان)',
        'en-HK' => 'انگلیسی (هنگ‌کنگ، منطقۀ ویژۀ اداری چین)',
        'en-IE' => 'انگلیسی (ایرلند)',
        'en-IL' => 'انگلیسی (اسرائیل)',
        'en-IM' => 'انگلیسی (جزیرهٔ من)',
        'en-IN' => 'انگلیسی (هند)',
        'en-IO' => 'انگلیسی (قلمرو بریتانیا در اقیانوس هند)',
        'en-JE' => 'انگلیسی (جرزی)',
        'en-JM' => 'انگلیسی (جامائیکا)',
        'en-KE' => 'انگلیسی (کنیا)',
        'en-KI' => 'انگلیسی (کیریباتی)',
        'en-KN' => 'انگلیسی (سنت کیتس و نویس)',
        'en-KY' => 'انگلیسی (جزایر کِیمن)',
        'en-LC' => 'انگلیسی (سنت لوسیا)',
        'en-LR' => 'انگلیسی (لیبریا)',
        'en-LS' => 'انگلیسی (لسوتو)',
        'en-MG' => 'انگلیسی (ماداگاسکار)',
        'en-MH' => 'انگلیسی (جزایر مارشال)',
        'en-MO' => 'انگلیسی (ماکائو، منطقۀ ویژۀ اداری چین)',
        'en-MP' => 'انگلیسی (جزایر ماریانای شمالی)',
        'en-MS' => 'انگلیسی (مونت‌سرات)',
        'en-MT' => 'انگلیسی (مالت)',
        'en-MU' => 'انگلیسی (موریس)',
        'en-MW' => 'انگلیسی (مالاوی)',
        'en-MY' => 'انگلیسی (مالزی)',
        'en-NA' => 'انگلیسی (نامیبیا)',
        'en-NF' => 'انگلیسی (جزیرهٔ نورفولک)',
        'en-NG' => 'انگلیسی (نیجریه)',
        'en-NL' => 'انگلیسی (هلند)',
        'en-NR' => 'انگلیسی (نائورو)',
        'en-NU' => 'انگلیسی (نیوئه)',
        'en-NZ' => 'انگلیسی (نیوزیلند)',
        'en-PG' => 'انگلیسی (پاپوا گینهٔ نو)',
        'en-PH' => 'انگلیسی (فیلیپین)',
        'en-PK' => 'انگلیسی (پاکستان)',
        'en-PN' => 'انگلیسی (جزایر پیت‌کرن)',
        'en-PR' => 'انگلیسی (پورتوریکو)',
        'en-PW' => 'انگلیسی (پالائو)',
        'en-RW' => 'انگلیسی (رواندا)',
        'en-SB' => 'انگلیسی (جزایر سلیمان)',
        'en-SC' => 'انگلیسی (سیشل)',
        'en-SD' => 'انگلیسی (سودان)',
        'en-SE' => 'انگلیسی (سوئد)',
        'en-SG' => 'انگلیسی (سنگاپور)',
        'en-SH' => 'انگلیسی (سنت هلن)',
        'en-SI' => 'انگلیسی (اسلوونی)',
        'en-SL' => 'انگلیسی (سیرالئون)',
        'en-SS' => 'انگلیسی (سودان جنوبی)',
        'en-SX' => 'انگلیسی (سنت مارتن)',
        'en-SZ' => 'انگلیسی (اسواتینی)',
        'en-TC' => 'انگلیسی (جزایر تورکس و کایکوس)',
        'en-TK' => 'انگلیسی (توکلائو)',
        'en-TO' => 'انگلیسی (تونگا)',
        'en-TT' => 'انگلیسی (ترینیداد و توباگو)',
        'en-TV' => 'انگلیسی (تووالو)',
        'en-TZ' => 'انگلیسی (تانزانیا)',
        'en-UG' => 'انگلیسی (اوگاندا)',
        'en-UM' => 'انگلیسی (جزایر دورافتادهٔ ایالات متحده)',
        'en-US' => 'انگلیسی (ایالات متحده)',
        'en-US-POSIX' => 'انگلیسی (ایالات متحده، کامپیوتری)',
        'en-VC' => 'انگلیسی (سنت وینسنت و گرنادین)',
        'en-VG' => 'انگلیسی (جزایر ویرجین بریتانیا)',
        'en-VI' => 'انگلیسی (جزایر ویرجین ایالات متحده)',
        'en-VU' => 'انگلیسی (وانواتو)',
        'en-WS' => 'انگلیسی (ساموآ)',
        'en-ZA' => 'انگلیسی (افریقای جنوبی)',
        'en-ZM' => 'انگلیسی (زامبیا)',
        'en-ZW' => 'انگلیسی (زیمبابوه)',
        'eo' => 'اسپرانتو',
        'eo-001' => 'اسپرانتو (جهان)',
        'es' => 'اسپانیایی',
        'es-419' => 'اسپانیایی (امریکای لاتین)',
        'es-AR' => 'اسپانیایی (آرژانتین)',
        'es-BO' => 'اسپانیایی (بولیوی)',
        'es-BR' => 'اسپانیایی (برزیل)',
        'es-BZ' => 'اسپانیایی (بلیز)',
        'es-CL' => 'اسپانیایی (شیلی)',
        'es-CO' => 'اسپانیایی (کلمبیا)',
        'es-CR' => 'اسپانیایی (کاستاریکا)',
        'es-CU' => 'اسپانیایی (کوبا)',
        'es-DO' => 'اسپانیایی (جمهوری دومینیکن)',
        'es-EA' => 'اسپانیایی (سبته و ملیله)',
        'es-EC' => 'اسپانیایی (اکوادور)',
        'es-ES' => 'اسپانیایی (اسپانیا)',
        'es-GQ' => 'اسپانیایی (گینهٔ استوایی)',
        'es-GT' => 'اسپانیایی (گواتمالا)',
        'es-HN' => 'اسپانیایی (هندوراس)',
        'es-IC' => 'اسپانیایی (جزایر قناری)',
        'es-MX' => 'اسپانیایی (مکزیک)',
        'es-NI' => 'اسپانیایی (نیکاراگوئه)',
        'es-PA' => 'اسپانیایی (پاناما)',
        'es-PE' => 'اسپانیایی (پرو)',
        'es-PH' => 'اسپانیایی (فیلیپین)',
        'es-PR' => 'اسپانیایی (پورتوریکو)',
        'es-PY' => 'اسپانیایی (پاراگوئه)',
        'es-SV' => 'اسپانیایی (السالوادور)',
        'es-US' => 'اسپانیایی (ایالات متحده)',
        'es-UY' => 'اسپانیایی (اروگوئه)',
        'es-VE' => 'اسپانیایی (ونزوئلا)',
        'et' => 'استونیایی',
        'et-EE' => 'استونیایی (استونی)',
        'eu' => 'باسکی',
        'eu-ES' => 'باسکی (اسپانیا)',
        'ewo' => 'اواندو',
        'ewo-CM' => 'اواندو (کامرون)',
        'fa' => 'فارسی',
        'fa-AF' => 'فارسی (افغانستان)',
        'fa-IR' => 'فارسی (ایران)',
        'ff' => 'فولانی',
        'ff-Latn' => 'فولانی (لاتینی)',
        'ff-Latn-BF' => 'فولانی (لاتینی، بورکینافاسو)',
        'ff-Latn-CM' => 'فولانی (لاتینی، کامرون)',
        'ff-Latn-GH' => 'فولانی (لاتینی، غنا)',
        'ff-Latn-GM' => 'فولانی (لاتینی، گامبیا)',
        'ff-Latn-GN' => 'فولانی (لاتینی، گینه)',
        'ff-Latn-GW' => 'فولانی (لاتینی، گینهٔ بیسائو)',
        'ff-Latn-LR' => 'فولانی (لاتینی، لیبریا)',
        'ff-Latn-MR' => 'فولانی (لاتینی، موریتانی)',
        'ff-Latn-NE' => 'فولانی (لاتینی، نیجر)',
        'ff-Latn-NG' => 'فولانی (لاتینی، نیجریه)',
        'ff-Latn-SL' => 'فولانی (لاتینی، سیرالئون)',
        'ff-Latn-SN' => 'فولانی (لاتینی، سنگال)',
        'fi' => 'فنلاندی',
        'fi-FI' => 'فنلاندی (فنلاند)',
        'fil' => 'فیلیپینی',
        'fil-PH' => 'فیلیپینی (فیلیپین)',
        'fo' => 'فارویی',
        'fo-DK' => 'فارویی (دانمارک)',
        'fo-FO' => 'فارویی (جزایر فارو)',
        'fr' => 'فرانسوی',
        'fr-BE' => 'فرانسوی (بلژیک)',
        'fr-BF' => 'فرانسوی (بورکینافاسو)',
        'fr-BI' => 'فرانسوی (بوروندی)',
        'fr-BJ' => 'فرانسوی (بنین)',
        'fr-BL' => 'فرانسوی (سن بارتلمی)',
        'fr-CA' => 'فرانسوی (کانادا)',
        'fr-CD' => 'فرانسوی (کنگو - کینشاسا)',
        'fr-CF' => 'فرانسوی (جمهوری افریقای مرکزی)',
        'fr-CG' => 'فرانسوی (کنگو - برازویل)',
        'fr-CH' => 'فرانسوی (سوئیس)',
        'fr-CI' => 'فرانسوی (ساحل عاج)',
        'fr-CM' => 'فرانسوی (کامرون)',
        'fr-DJ' => 'فرانسوی (جیبوتی)',
        'fr-DZ' => 'فرانسوی (الجزایر)',
        'fr-FR' => 'فرانسوی (فرانسه)',
        'fr-GA' => 'فرانسوی (گابن)',
        'fr-GF' => 'فرانسوی (گویان فرانسه)',
        'fr-GN' => 'فرانسوی (گینه)',
        'fr-GP' => 'فرانسوی (گوادلوپ)',
        'fr-GQ' => 'فرانسوی (گینهٔ استوایی)',
        'fr-HT' => 'فرانسوی (هائیتی)',
        'fr-KM' => 'فرانسوی (کومور)',
        'fr-LU' => 'فرانسوی (لوکزامبورگ)',
        'fr-MA' => 'فرانسوی (مراکش)',
        'fr-MC' => 'فرانسوی (موناکو)',
        'fr-MF' => 'فرانسوی (سنت مارتین)',
        'fr-MG' => 'فرانسوی (ماداگاسکار)',
        'fr-ML' => 'فرانسوی (مالی)',
        'fr-MQ' => 'فرانسوی (مارتینیک)',
        'fr-MR' => 'فرانسوی (موریتانی)',
        'fr-MU' => 'فرانسوی (موریس)',
        'fr-NC' => 'فرانسوی (کالدونیای جدید)',
        'fr-NE' => 'فرانسوی (نیجر)',
        'fr-PF' => 'فرانسوی (پلی‌نزی فرانسه)',
        'fr-PM' => 'فرانسوی (سن پیر و میکلن)',
        'fr-RE' => 'فرانسوی (رئونیون)',
        'fr-RW' => 'فرانسوی (رواندا)',
        'fr-SC' => 'فرانسوی (سیشل)',
        'fr-SN' => 'فرانسوی (سنگال)',
        'fr-SY' => 'فرانسوی (سوریه)',
        'fr-TD' => 'فرانسوی (چاد)',
        'fr-TG' => 'فرانسوی (توگو)',
        'fr-TN' => 'فرانسوی (تونس)',
        'fr-VU' => 'فرانسوی (وانواتو)',
        'fr-WF' => 'فرانسوی (والیس و فوتونا)',
        'fr-YT' => 'فرانسوی (مایوت)',
        'fur' => 'فریولیایی',
        'fur-IT' => 'فریولیایی (ایتالیا)',
        'fy' => 'فریزی غربی',
        'fy-NL' => 'فریزی غربی (هلند)',
        'ga' => 'ایرلندی',
        'ga-IE' => 'ایرلندی (ایرلند)',
        'gd' => 'گیلی اسکاتلندی',
        'gd-GB' => 'گیلی اسکاتلندی (بریتانیا)',
        'gl' => 'گالیسیایی',
        'gl-ES' => 'گالیسیایی (اسپانیا)',
        'gsw' => 'آلمانی سوئیسی',
        'gsw-CH' => 'آلمانی سوئیسی (سوئیس)',
        'gsw-FR' => 'آلمانی سوئیسی (فرانسه)',
        'gsw-LI' => 'آلمانی سوئیسی (لیختن‌اشتاین)',
        'gu' => 'گجراتی',
        'gu-IN' => 'گجراتی (هند)',
        'guz' => 'گوسی',
        'guz-KE' => 'گوسی (کنیا)',
        'gv' => 'مانی',
        'gv-IM' => 'مانی (جزیرهٔ من)',
        'ha' => 'هوسیایی',
        'ha-GH' => 'هوسیایی (غنا)',
        'ha-NE' => 'هوسیایی (نیجر)',
        'ha-NG' => 'هوسیایی (نیجریه)',
        'haw' => 'هاوائیایی',
        'haw-US' => 'هاوائیایی (ایالات متحده)',
        'he' => 'عبری',
        'he-IL' => 'عبری (اسرائیل)',
        'hi' => 'هندی',
        'hi-IN' => 'هندی (هند)',
        'hr' => 'کروات',
        'hr-BA' => 'کروات (بوسنی و هرزگوین)',
        'hr-HR' => 'کروات (کرواسی)',
        'hsb' => 'صُربی علیا',
        'hsb-DE' => 'صُربی علیا (آلمان)',
        'hu' => 'مجاری',
        'hu-HU' => 'مجاری (مجارستان)',
        'hy' => 'ارمنی',
        'hy-AM' => 'ارمنی (ارمنستان)',
        'ia' => 'میان‌زبان',
        'ia-001' => 'میان‌زبان (جهان)',
        'id' => 'اندونزیایی',
        'id-ID' => 'اندونزیایی (اندونزی)',
        'ig' => 'ایگبویی',
        'ig-NG' => 'ایگبویی (نیجریه)',
        'ii' => 'یی سیچوان',
        'ii-CN' => 'یی سیچوان (چین)',
        'is' => 'ایسلندی',
        'is-IS' => 'ایسلندی (ایسلند)',
        'it' => 'ایتالیایی',
        'it-CH' => 'ایتالیایی (سوئیس)',
        'it-IT' => 'ایتالیایی (ایتالیا)',
        'it-SM' => 'ایتالیایی (سان‌مارینو)',
        'it-VA' => 'ایتالیایی (واتیکان)',
        'ja' => 'ژاپنی',
        'ja-JP' => 'ژاپنی (ژاپن)',
        'jgo' => 'نگومبا',
        'jgo-CM' => 'نگومبا (کامرون)',
        'jmc' => 'ماچامه‌ای',
        'jmc-TZ' => 'ماچامه‌ای (تانزانیا)',
        'jv' => 'جاوه‌ای',
        'jv-ID' => 'جاوه‌ای (اندونزی)',
        'ka' => 'گرجی',
        'ka-GE' => 'گرجی (گرجستان)',
        'kab' => 'قبایلی',
        'kab-DZ' => 'قبایلی (الجزایر)',
        'kam' => 'کامبایی',
        'kam-KE' => 'کامبایی (کنیا)',
        'kde' => 'ماکونده',
        'kde-TZ' => 'ماکونده (تانزانیا)',
        'kea' => 'کابووردیانو',
        'kea-CV' => 'کابووردیانو (کیپ‌ورد)',
        'khq' => 'کوجراچینی',
        'khq-ML' => 'کوجراچینی (مالی)',
        'ki' => 'کیکویویی',
        'ki-KE' => 'کیکویویی (کنیا)',
        'kk' => 'قزاقی',
        'kk-KZ' => 'قزاقی (قزاقستان)',
        'kkj' => 'کاکایی',
        'kkj-CM' => 'کاکایی (کامرون)',
        'kl' => 'گرینلندی',
        'kl-GL' => 'گرینلندی (گرینلند)',
        'kln' => 'کالنجین',
        'kln-KE' => 'کالنجین (کنیا)',
        'km' => 'خمری',
        'km-KH' => 'خمری (کامبوج)',
        'kn' => 'کانارا',
        'kn-IN' => 'کانارا (هند)',
        'ko' => 'کره‌ای',
        'ko-KP' => 'کره‌ای (کرهٔ شمالی)',
        'ko-KR' => 'کره‌ای (کرهٔ جنوبی)',
        'kok' => 'کنکانی',
        'kok-IN' => 'کنکانی (هند)',
        'ks' => 'کشمیری',
        'ks-IN' => 'کشمیری (هند)',
        'ksb' => 'شامبالا',
        'ksb-TZ' => 'شامبالا (تانزانیا)',
        'ksf' => 'بافیایی',
        'ksf-CM' => 'بافیایی (کامرون)',
        'ksh' => 'ریپواری',
        'ksh-DE' => 'ریپواری (آلمان)',
        'ku' => 'کردی',
        'ku-TR' => 'کردی (ترکیه)',
        'kw' => 'کرنوالی',
        'kw-GB' => 'کرنوالی (بریتانیا)',
        'ky' => 'قرقیزی',
        'ky-KG' => 'قرقیزی (قرقیزستان)',
        'lag' => 'لانگی',
        'lag-TZ' => 'لانگی (تانزانیا)',
        'lb' => 'لوگزامبورگی',
        'lb-LU' => 'لوگزامبورگی (لوکزامبورگ)',
        'lg' => 'گاندایی',
        'lg-UG' => 'گاندایی (اوگاندا)',
        'lkt' => 'لاکوتا',
        'lkt-US' => 'لاکوتا (ایالات متحده)',
        'ln' => 'لینگالا',
        'ln-AO' => 'لینگالا (آنگولا)',
        'ln-CD' => 'لینگالا (کنگو - کینشاسا)',
        'ln-CF' => 'لینگالا (جمهوری افریقای مرکزی)',
        'ln-CG' => 'لینگالا (کنگو - برازویل)',
        'lo' => 'لائوسی',
        'lo-LA' => 'لائوسی (لائوس)',
        'lrc' => 'لری شمالی',
        'lrc-IQ' => 'لری شمالی (عراق)',
        'lrc-IR' => 'لری شمالی (ایران)',
        'lt' => 'لیتوانیایی',
        'lt-LT' => 'لیتوانیایی (لیتوانی)',
        'lu' => 'لوبایی‐کاتانگا',
        'lu-CD' => 'لوبایی‐کاتانگا (کنگو - کینشاسا)',
        'luo' => 'لوئویی',
        'luo-KE' => 'لوئویی (کنیا)',
        'luy' => 'لویا',
        'luy-KE' => 'لویا (کنیا)',
        'lv' => 'لتونیایی',
        'lv-LV' => 'لتونیایی (لتونی)',
        'mas' => 'ماسایی',
        'mas-KE' => 'ماسایی (کنیا)',
        'mas-TZ' => 'ماسایی (تانزانیا)',
        'mer' => 'مرویی',
        'mer-KE' => 'مرویی (کنیا)',
        'mfe' => 'موریسین',
        'mfe-MU' => 'موریسین (موریس)',
        'mg' => 'مالاگاسیایی',
        'mg-MG' => 'مالاگاسیایی (ماداگاسکار)',
        'mgh' => 'ماکوا متو',
        'mgh-MZ' => 'ماکوا متو (موزامبیک)',
        'mgo' => 'متایی',
        'mgo-CM' => 'متایی (کامرون)',
        'mi' => 'مائوریایی',
        'mi-NZ' => 'مائوریایی (نیوزیلند)',
        'mk' => 'مقدونی',
        'mk-MK' => 'مقدونی (مقدونیهٔ شمالی)',
        'ml' => 'مالایالامی',
        'ml-IN' => 'مالایالامی (هند)',
        'mn' => 'مغولی',
        'mn-MN' => 'مغولی (مغولستان)',
        'mr' => 'مراتی',
        'mr-IN' => 'مراتی (هند)',
        'ms' => 'مالایی',
        'ms-BN' => 'مالایی (برونئی)',
        'ms-MY' => 'مالایی (مالزی)',
        'ms-SG' => 'مالایی (سنگاپور)',
        'mt' => 'مالتی',
        'mt-MT' => 'مالتی (مالت)',
        'mua' => 'ماندانگی',
        'mua-CM' => 'ماندانگی (کامرون)',
        'my' => 'برمه‌ای',
        'my-MM' => 'برمه‌ای (میانمار [برمه])',
        'mzn' => 'مازندرانی',
        'mzn-IR' => 'مازندرانی (ایران)',
        'naq' => 'نامایی',
        'naq-NA' => 'نامایی (نامیبیا)',
        'nb' => 'نروژی بوک‌مُل',
        'nb-NO' => 'نروژی بوک‌مُل (نروژ)',
        'nb-SJ' => 'نروژی بوک‌مُل (اسوالبارد و جان‌ماین)',
        'nd' => 'انده‌بله‌ای شمالی',
        'nd-ZW' => 'انده‌بله‌ای شمالی (زیمبابوه)',
        'nds' => 'آلمانی سفلی',
        'nds-DE' => 'آلمانی سفلی (آلمان)',
        'nds-NL' => 'آلمانی سفلی (هلند)',
        'ne' => 'نپالی',
        'ne-IN' => 'نپالی (هند)',
        'ne-NP' => 'نپالی (نپال)',
        'nl' => 'هلندی',
        'nl-AW' => 'هلندی (آروبا)',
        'nl-BE' => 'هلندی (بلژیک)',
        'nl-BQ' => 'هلندی (جزایر کارائیب هلند)',
        'nl-CW' => 'هلندی (کوراسائو)',
        'nl-NL' => 'هلندی (هلند)',
        'nl-SR' => 'هلندی (سورینام)',
        'nl-SX' => 'هلندی (سنت مارتن)',
        'nmg' => 'کوازیو',
        'nmg-CM' => 'کوازیو (کامرون)',
        'nn' => 'نروژی نی‌نُشک',
        'nn-NO' => 'نروژی نی‌نُشک (نروژ)',
        'nnh' => 'انگیمبونی',
        'nnh-CM' => 'انگیمبونی (کامرون)',
        'nus' => 'نویر',
        'nus-SS' => 'نویر (سودان جنوبی)',
        'nyn' => 'نیانکوله‌ای',
        'nyn-UG' => 'نیانکوله‌ای (اوگاندا)',
        'om' => 'اورومویی',
        'om-ET' => 'اورومویی (اتیوپی)',
        'om-KE' => 'اورومویی (کنیا)',
        'or' => 'اوریه‌ای',
        'or-IN' => 'اوریه‌ای (هند)',
        'os' => 'آسی',
        'os-GE' => 'آسی (گرجستان)',
        'os-RU' => 'آسی (روسیه)',
        'pa' => 'پنجابی',
        'pa-Arab' => 'پنجابی (عربی)',
        'pa-Arab-PK' => 'پنجابی (عربی، پاکستان)',
        'pa-Guru' => 'پنجابی (گورومخی)',
        'pa-Guru-IN' => 'پنجابی (گورومخی، هند)',
        'pl' => 'لهستانی',
        'pl-PL' => 'لهستانی (لهستان)',
        'ps' => 'پشتو',
        'ps-AF' => 'پشتو (افغانستان)',
        'ps-PK' => 'پشتو (پاکستان)',
        'pt' => 'پرتغالی',
        'pt-AO' => 'پرتغالی (آنگولا)',
        'pt-BR' => 'پرتغالی (برزیل)',
        'pt-CH' => 'پرتغالی (سوئیس)',
        'pt-CV' => 'پرتغالی (کیپ‌ورد)',
        'pt-GQ' => 'پرتغالی (گینهٔ استوایی)',
        'pt-GW' => 'پرتغالی (گینهٔ بیسائو)',
        'pt-LU' => 'پرتغالی (لوکزامبورگ)',
        'pt-MO' => 'پرتغالی (ماکائو، منطقۀ ویژۀ اداری چین)',
        'pt-MZ' => 'پرتغالی (موزامبیک)',
        'pt-PT' => 'پرتغالی (پرتغال)',
        'pt-ST' => 'پرتغالی (سائوتومه و پرینسیپ)',
        'pt-TL' => 'پرتغالی (تیمور-لسته)',
        'qu' => 'کچوایی',
        'qu-BO' => 'کچوایی (بولیوی)',
        'qu-EC' => 'کچوایی (اکوادور)',
        'qu-PE' => 'کچوایی (پرو)',
        'rm' => 'رومانش',
        'rm-CH' => 'رومانش (سوئیس)',
        'rn' => 'روندیایی',
        'rn-BI' => 'روندیایی (بوروندی)',
        'ro' => 'رومانیایی',
        'ro-MD' => 'رومانیایی (مولداوی)',
        'ro-RO' => 'رومانیایی (رومانی)',
        'rof' => 'رومبویی',
        'rof-TZ' => 'رومبویی (تانزانیا)',
        'ru' => 'روسی',
        'ru-BY' => 'روسی (بلاروس)',
        'ru-KG' => 'روسی (قرقیزستان)',
        'ru-KZ' => 'روسی (قزاقستان)',
        'ru-MD' => 'روسی (مولداوی)',
        'ru-RU' => 'روسی (روسیه)',
        'ru-UA' => 'روسی (اوکراین)',
        'rw' => 'کینیارواندایی',
        'rw-RW' => 'کینیارواندایی (رواندا)',
        'rwk' => 'روایی',
        'rwk-TZ' => 'روایی (تانزانیا)',
        'sah' => 'یاقوتی',
        'sah-RU' => 'یاقوتی (روسیه)',
        'saq' => 'سامبورو',
        'saq-KE' => 'سامبورو (کنیا)',
        'sbp' => 'سانگویی',
        'sbp-TZ' => 'سانگویی (تانزانیا)',
        'sd' => 'سندی',
        'sd-PK' => 'سندی (پاکستان)',
        'se' => 'سامی شمالی',
        'se-FI' => 'سامی شمالی (فنلاند)',
        'se-NO' => 'سامی شمالی (نروژ)',
        'se-SE' => 'سامی شمالی (سوئد)',
        'seh' => 'سنا',
        'seh-MZ' => 'سنا (موزامبیک)',
        'ses' => 'کویرابورا سنی',
        'ses-ML' => 'کویرابورا سنی (مالی)',
        'sg' => 'سانگو',
        'sg-CF' => 'سانگو (جمهوری افریقای مرکزی)',
        'shi' => 'تاچل‌هیت',
        'shi-Latn' => 'تاچل‌هیت (لاتینی)',
        'shi-Latn-MA' => 'تاچل‌هیت (لاتینی، مراکش)',
        'shi-Tfng' => 'تاچل‌هیت (تیفیناغی)',
        'shi-Tfng-MA' => 'تاچل‌هیت (تیفیناغی، مراکش)',
        'si' => 'سینهالی',
        'si-LK' => 'سینهالی (سری‌لانکا)',
        'sk' => 'اسلواکی',
        'sk-SK' => 'اسلواکی (اسلواکی)',
        'sl' => 'اسلوونیایی',
        'sl-SI' => 'اسلوونیایی (اسلوونی)',
        'smn' => 'ایناری سامی',
        'smn-FI' => 'ایناری سامی (فنلاند)',
        'sn' => 'شونایی',
        'sn-ZW' => 'شونایی (زیمبابوه)',
        'so' => 'سومالیایی',
        'so-DJ' => 'سومالیایی (جیبوتی)',
        'so-ET' => 'سومالیایی (اتیوپی)',
        'so-KE' => 'سومالیایی (کنیا)',
        'so-SO' => 'سومالیایی (سومالی)',
        'sq' => 'آلبانیایی',
        'sq-AL' => 'آلبانیایی (آلبانی)',
        'sq-MK' => 'آلبانیایی (مقدونیهٔ شمالی)',
        'sq-XK' => 'آلبانیایی (کوزوو)',
        'sr' => 'صربی',
        'sr-Cyrl' => 'صربی (سیریلی)',
        'sr-Cyrl-BA' => 'صربی (سیریلی، بوسنی و هرزگوین)',
        'sr-Cyrl-ME' => 'صربی (سیریلی، مونته‌نگرو)',
        'sr-Cyrl-RS' => 'صربی (سیریلی، صربستان)',
        'sr-Cyrl-XK' => 'صربی (سیریلی، کوزوو)',
        'sr-Latn' => 'صربی (لاتینی)',
        'sr-Latn-BA' => 'صربی (لاتینی، بوسنی و هرزگوین)',
        'sr-Latn-ME' => 'صربی (لاتینی، مونته‌نگرو)',
        'sr-Latn-RS' => 'صربی (لاتینی، صربستان)',
        'sr-Latn-XK' => 'صربی (لاتینی، کوزوو)',
        'sv' => 'سوئدی',
        'sv-AX' => 'سوئدی (جزایر آلاند)',
        'sv-FI' => 'سوئدی (فنلاند)',
        'sv-SE' => 'سوئدی (سوئد)',
        'sw' => 'سواحیلی',
        'sw-CD' => 'سواحیلی (کنگو - کینشاسا)',
        'sw-KE' => 'سواحیلی (کنیا)',
        'sw-TZ' => 'سواحیلی (تانزانیا)',
        'sw-UG' => 'سواحیلی (اوگاندا)',
        'ta' => 'تامیلی',
        'ta-IN' => 'تامیلی (هند)',
        'ta-LK' => 'تامیلی (سری‌لانکا)',
        'ta-MY' => 'تامیلی (مالزی)',
        'ta-SG' => 'تامیلی (سنگاپور)',
        'te' => 'تلوگویی',
        'te-IN' => 'تلوگویی (هند)',
        'teo' => 'تسویی',
        'teo-KE' => 'تسویی (کنیا)',
        'teo-UG' => 'تسویی (اوگاندا)',
        'tg' => 'تاجیکی',
        'tg-TJ' => 'تاجیکی (تاجیکستان)',
        'th' => 'تایلندی',
        'th-TH' => 'تایلندی (تایلند)',
        'ti' => 'تیگرینیایی',
        'ti-ER' => 'تیگرینیایی (اریتره)',
        'ti-ET' => 'تیگرینیایی (اتیوپی)',
        'tk' => 'ترکمنی',
        'tk-TM' => 'ترکمنی (ترکمنستان)',
        'to' => 'تونگایی',
        'to-TO' => 'تونگایی (تونگا)',
        'tr' => 'ترکی استانبولی',
        'tr-CY' => 'ترکی استانبولی (قبرس)',
        'tr-TR' => 'ترکی استانبولی (ترکیه)',
        'tt' => 'تاتاری',
        'tt-RU' => 'تاتاری (روسیه)',
        'twq' => 'تسواکی',
        'twq-NE' => 'تسواکی (نیجر)',
        'tzm' => 'آمازیغی اطلس مرکزی',
        'tzm-MA' => 'آمازیغی اطلس مرکزی (مراکش)',
        'ug' => 'اویغوری',
        'ug-CN' => 'اویغوری (چین)',
        'uk' => 'اوکراینی',
        'uk-UA' => 'اوکراینی (اوکراین)',
        'ur' => 'اردو',
        'ur-IN' => 'اردو (هند)',
        'ur-PK' => 'اردو (پاکستان)',
        'uz' => 'ازبکی',
        'uz-Arab' => 'ازبکی (عربی)',
        'uz-Arab-AF' => 'ازبکی (عربی، افغانستان)',
        'uz-Cyrl' => 'ازبکی (سیریلی)',
        'uz-Cyrl-UZ' => 'ازبکی (سیریلی، ازبکستان)',
        'uz-Latn' => 'ازبکی (لاتینی)',
        'uz-Latn-UZ' => 'ازبکی (لاتینی، ازبکستان)',
        'vai' => 'ویایی',
        'vai-Latn' => 'ویایی (لاتینی)',
        'vai-Latn-LR' => 'ویایی (لاتینی، لیبریا)',
        'vai-Vaii' => 'ویایی (ویایی)',
        'vai-Vaii-LR' => 'ویایی (ویایی، لیبریا)',
        'vi' => 'ویتنامی',
        'vi-VN' => 'ویتنامی (ویتنام)',
        'vun' => 'ونجو',
        'vun-TZ' => 'ونجو (تانزانیا)',
        'wae' => 'والسر',
        'wae-CH' => 'والسر (سوئیس)',
        'wo' => 'ولوفی',
        'wo-SN' => 'ولوفی (سنگال)',
        'xh' => 'خوسایی',
        'xh-ZA' => 'خوسایی (افریقای جنوبی)',
        'xog' => 'سوگایی',
        'xog-UG' => 'سوگایی (اوگاندا)',
        'yav' => 'یانگبنی',
        'yav-CM' => 'یانگبنی (کامرون)',
        'yi' => 'یدی',
        'yi-001' => 'یدی (جهان)',
        'yo' => 'یوروبایی',
        'yo-BJ' => 'یوروبایی (بنین)',
        'yo-NG' => 'یوروبایی (نیجریه)',
        'yue' => 'کانتونی',
        'yue-Hans' => 'کانتونی (ساده‌شده)',
        'yue-Hans-CN' => 'کانتونی (ساده‌شده، چین)',
        'yue-Hant' => 'کانتونی (سنتی)',
        'yue-Hant-HK' => 'کانتونی (سنتی، هنگ‌کنگ، منطقۀ ویژۀ اداری چین)',
        'zgh' => 'آمازیغی معیار مراکش',
        'zgh-MA' => 'آمازیغی معیار مراکش (مراکش)',
        'zh' => 'چینی',
        'zh-Hans' => 'چینی (ساده‌شده)',
        'zh-Hans-CN' => 'چینی (ساده‌شده، چین)',
        'zh-Hans-HK' => 'چینی (ساده‌شده، هنگ‌کنگ، منطقۀ ویژۀ اداری چین)',
        'zh-Hans-MO' => 'چینی (ساده‌شده، ماکائو، منطقۀ ویژۀ اداری چین)',
        'zh-Hans-SG' => 'چینی (ساده‌شده، سنگاپور)',
        'zh-Hant' => 'چینی (سنتی)',
        'zh-Hant-HK' => 'چینی (سنتی، هنگ‌کنگ، منطقۀ ویژۀ اداری چین)',
        'zh-Hant-MO' => 'چینی (سنتی، ماکائو، منطقۀ ویژۀ اداری چین)',
        'zh-Hant-TW' => 'چینی (سنتی، تایوان)',
        'zu' => 'زولویی',
        'zu-ZA' => 'زولویی (افریقای جنوبی)',
    ],
];
