<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'y/M/d',
            'time' => 'ah:mm',
            'datetime' => 'y/M/d ah:mm',
        ],
        'medium' => [
            'date' => 'y年M月d日',
            'time' => 'ah:mm:ss',
            'datetime' => 'y年M月d日 ah:mm:ss',
        ],
        'long' => [
            'date' => 'y年M月d日',
            'time' => 'z ah:mm:ss',
            'datetime' => 'y年M月d日 z ah:mm:ss',
        ],
        'full' => [
            'date' => 'y年M月d日EEEE',
            'time' => 'zzzz ah:mm:ss',
            'datetime' => 'y年M月d日EEEE zzzz ah:mm:ss',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤#,##0.00',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => '上午',
    'pmName' => '下午',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '.',
        'groupingSeparator' => ',',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => '.',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ',',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => '￥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JP¥',
        'KRW' => '￦',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => 'THB ',
        'TWD' => 'NT$',
        'USD' => 'US$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月',
        ],
        'full' => [
            '一月',
            '二月',
            '三月',
            '四月',
            '五月',
            '六月',
            '七月',
            '八月',
            '九月',
            '十月',
            '十一月',
            '十二月',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月',
        ],
        'full' => [
            '一月',
            '二月',
            '三月',
            '四月',
            '五月',
            '六月',
            '七月',
            '八月',
            '九月',
            '十月',
            '十一月',
            '十二月',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            '日',
            '一',
            '二',
            '三',
            '四',
            '五',
            '六',
        ],
        'short' => [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六',
        ],
        'medium' => [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六',
        ],
        'full' => [
            '星期日',
            '星期一',
            '星期二',
            '星期三',
            '星期四',
            '星期五',
            '星期六',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            '日',
            '一',
            '二',
            '三',
            '四',
            '五',
            '六',
        ],
        'short' => [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六',
        ],
        'medium' => [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六',
        ],
        'full' => [
            '星期日',
            '星期一',
            '星期二',
            '星期三',
            '星期四',
            '星期五',
            '星期六',
        ],
    ],
    'localeDisplayNames' => [
        'af' => '南非荷兰语',
        'af-NA' => '南非荷兰语（纳米比亚）',
        'af-ZA' => '南非荷兰语（南非）',
        'agq' => '亚罕语',
        'agq-CM' => '亚罕语（喀麦隆）',
        'ak' => '阿肯语',
        'ak-GH' => '阿肯语（加纳）',
        'am' => '阿姆哈拉语',
        'am-ET' => '阿姆哈拉语（埃塞俄比亚）',
        'ar' => '阿拉伯语',
        'ar-001' => '阿拉伯语（世界）',
        'ar-AE' => '阿拉伯语（阿拉伯联合酋长国）',
        'ar-BH' => '阿拉伯语（巴林）',
        'ar-DJ' => '阿拉伯语（吉布提）',
        'ar-DZ' => '阿拉伯语（阿尔及利亚）',
        'ar-EG' => '阿拉伯语（埃及）',
        'ar-EH' => '阿拉伯语（西撒哈拉）',
        'ar-ER' => '阿拉伯语（厄立特里亚）',
        'ar-IL' => '阿拉伯语（以色列）',
        'ar-IQ' => '阿拉伯语（伊拉克）',
        'ar-JO' => '阿拉伯语（约旦）',
        'ar-KM' => '阿拉伯语（科摩罗）',
        'ar-KW' => '阿拉伯语（科威特）',
        'ar-LB' => '阿拉伯语（黎巴嫩）',
        'ar-LY' => '阿拉伯语（利比亚）',
        'ar-MA' => '阿拉伯语（摩洛哥）',
        'ar-MR' => '阿拉伯语（毛里塔尼亚）',
        'ar-OM' => '阿拉伯语（阿曼）',
        'ar-PS' => '阿拉伯语（巴勒斯坦领土）',
        'ar-QA' => '阿拉伯语（卡塔尔）',
        'ar-SA' => '阿拉伯语（沙特阿拉伯）',
        'ar-SD' => '阿拉伯语（苏丹）',
        'ar-SO' => '阿拉伯语（索马里）',
        'ar-SS' => '阿拉伯语（南苏丹）',
        'ar-SY' => '阿拉伯语（叙利亚）',
        'ar-TD' => '阿拉伯语（乍得）',
        'ar-TN' => '阿拉伯语（突尼斯）',
        'ar-YE' => '阿拉伯语（也门）',
        'as' => '阿萨姆语',
        'as-IN' => '阿萨姆语（印度）',
        'asa' => '帕雷语',
        'asa-TZ' => '帕雷语（坦桑尼亚）',
        'ast' => '阿斯图里亚斯语',
        'ast-ES' => '阿斯图里亚斯语（西班牙）',
        'az' => '阿塞拜疆语',
        'az-Cyrl' => '阿塞拜疆语（西里尔文）',
        'az-Cyrl-AZ' => '阿塞拜疆语（西里尔文，阿塞拜疆）',
        'az-Latn' => '阿塞拜疆语（拉丁文）',
        'az-Latn-AZ' => '阿塞拜疆语（拉丁文，阿塞拜疆）',
        'bas' => '巴萨语',
        'bas-CM' => '巴萨语（喀麦隆）',
        'be' => '白俄罗斯语',
        'be-BY' => '白俄罗斯语（白俄罗斯）',
        'bem' => '本巴语',
        'bem-ZM' => '本巴语（赞比亚）',
        'bez' => '贝纳语',
        'bez-TZ' => '贝纳语（坦桑尼亚）',
        'bg' => '保加利亚语',
        'bg-BG' => '保加利亚语（保加利亚）',
        'bm' => '班巴拉语',
        'bm-ML' => '班巴拉语（马里）',
        'bn' => '孟加拉语',
        'bn-BD' => '孟加拉语（孟加拉国）',
        'bn-IN' => '孟加拉语（印度）',
        'bo' => '藏语',
        'bo-CN' => '藏语（中国）',
        'bo-IN' => '藏语（印度）',
        'br' => '布列塔尼语',
        'br-FR' => '布列塔尼语（法国）',
        'brx' => '博多语',
        'brx-IN' => '博多语（印度）',
        'bs' => '波斯尼亚语',
        'bs-Cyrl' => '波斯尼亚语（西里尔文）',
        'bs-Cyrl-BA' => '波斯尼亚语（西里尔文，波斯尼亚和黑塞哥维那）',
        'bs-Latn' => '波斯尼亚语（拉丁文）',
        'bs-Latn-BA' => '波斯尼亚语（拉丁文，波斯尼亚和黑塞哥维那）',
        'ca' => '加泰罗尼亚语',
        'ca-AD' => '加泰罗尼亚语（安道尔）',
        'ca-ES' => '加泰罗尼亚语（西班牙）',
        'ca-FR' => '加泰罗尼亚语（法国）',
        'ca-IT' => '加泰罗尼亚语（意大利）',
        'ccp' => '查克玛语',
        'ccp-BD' => '查克玛语（孟加拉国）',
        'ccp-IN' => '查克玛语（印度）',
        'ce' => '车臣语',
        'ce-RU' => '车臣语（俄罗斯）',
        'ceb' => '宿务语',
        'ceb-PH' => '宿务语（菲律宾）',
        'cgg' => '奇加语',
        'cgg-UG' => '奇加语（乌干达）',
        'chr' => '切罗基语',
        'chr-US' => '切罗基语（美国）',
        'ckb' => '中库尔德语',
        'ckb-IQ' => '中库尔德语（伊拉克）',
        'ckb-IR' => '中库尔德语（伊朗）',
        'cs' => '捷克语',
        'cs-CZ' => '捷克语（捷克）',
        'cy' => '威尔士语',
        'cy-GB' => '威尔士语（英国）',
        'da' => '丹麦语',
        'da-DK' => '丹麦语（丹麦）',
        'da-GL' => '丹麦语（格陵兰）',
        'dav' => '台塔语',
        'dav-KE' => '台塔语（肯尼亚）',
        'de' => '德语',
        'de-AT' => '德语（奥地利）',
        'de-BE' => '德语（比利时）',
        'de-CH' => '德语（瑞士）',
        'de-DE' => '德语（德国）',
        'de-IT' => '德语（意大利）',
        'de-LI' => '德语（列支敦士登）',
        'de-LU' => '德语（卢森堡）',
        'dje' => '哲尔马语',
        'dje-NE' => '哲尔马语（尼日尔）',
        'dsb' => '下索布语',
        'dsb-DE' => '下索布语（德国）',
        'dua' => '都阿拉语',
        'dua-CM' => '都阿拉语（喀麦隆）',
        'dyo' => '朱拉语',
        'dyo-SN' => '朱拉语（塞内加尔）',
        'dz' => '宗卡语',
        'dz-BT' => '宗卡语（不丹）',
        'ebu' => '恩布语',
        'ebu-KE' => '恩布语（肯尼亚）',
        'ee' => '埃维语',
        'ee-GH' => '埃维语（加纳）',
        'ee-TG' => '埃维语（多哥）',
        'el' => '希腊语',
        'el-CY' => '希腊语（塞浦路斯）',
        'el-GR' => '希腊语（希腊）',
        'en' => '英语',
        'en-001' => '英语（世界）',
        'en-150' => '英语（欧洲）',
        'en-AE' => '英语（阿拉伯联合酋长国）',
        'en-AG' => '英语（安提瓜和巴布达）',
        'en-AI' => '英语（安圭拉）',
        'en-AS' => '英语（美属萨摩亚）',
        'en-AT' => '英语（奥地利）',
        'en-AU' => '英语（澳大利亚）',
        'en-BB' => '英语（巴巴多斯）',
        'en-BE' => '英语（比利时）',
        'en-BI' => '英语（布隆迪）',
        'en-BM' => '英语（百慕大）',
        'en-BS' => '英语（巴哈马）',
        'en-BW' => '英语（博茨瓦纳）',
        'en-BZ' => '英语（伯利兹）',
        'en-CA' => '英语（加拿大）',
        'en-CC' => '英语（科科斯［基林］群岛）',
        'en-CH' => '英语（瑞士）',
        'en-CK' => '英语（库克群岛）',
        'en-CM' => '英语（喀麦隆）',
        'en-CX' => '英语（圣诞岛）',
        'en-CY' => '英语（塞浦路斯）',
        'en-DE' => '英语（德国）',
        'en-DG' => '英语（迪戈加西亚岛）',
        'en-DK' => '英语（丹麦）',
        'en-DM' => '英语（多米尼克）',
        'en-ER' => '英语（厄立特里亚）',
        'en-FI' => '英语（芬兰）',
        'en-FJ' => '英语（斐济）',
        'en-FK' => '英语（福克兰群岛）',
        'en-FM' => '英语（密克罗尼西亚）',
        'en-GB' => '英语（英国）',
        'en-GD' => '英语（格林纳达）',
        'en-GG' => '英语（根西岛）',
        'en-GH' => '英语（加纳）',
        'en-GI' => '英语（直布罗陀）',
        'en-GM' => '英语（冈比亚）',
        'en-GU' => '英语（关岛）',
        'en-GY' => '英语（圭亚那）',
        'en-HK' => '英语（中国香港特别行政区）',
        'en-IE' => '英语（爱尔兰）',
        'en-IL' => '英语（以色列）',
        'en-IM' => '英语（马恩岛）',
        'en-IN' => '英语（印度）',
        'en-IO' => '英语（英属印度洋领地）',
        'en-JE' => '英语（泽西岛）',
        'en-JM' => '英语（牙买加）',
        'en-KE' => '英语（肯尼亚）',
        'en-KI' => '英语（基里巴斯）',
        'en-KN' => '英语（圣基茨和尼维斯）',
        'en-KY' => '英语（开曼群岛）',
        'en-LC' => '英语（圣卢西亚）',
        'en-LR' => '英语（利比里亚）',
        'en-LS' => '英语（莱索托）',
        'en-MG' => '英语（马达加斯加）',
        'en-MH' => '英语（马绍尔群岛）',
        'en-MO' => '英语（中国澳门特别行政区）',
        'en-MP' => '英语（北马里亚纳群岛）',
        'en-MS' => '英语（蒙特塞拉特）',
        'en-MT' => '英语（马耳他）',
        'en-MU' => '英语（毛里求斯）',
        'en-MW' => '英语（马拉维）',
        'en-MY' => '英语（马来西亚）',
        'en-NA' => '英语（纳米比亚）',
        'en-NF' => '英语（诺福克岛）',
        'en-NG' => '英语（尼日利亚）',
        'en-NL' => '英语（荷兰）',
        'en-NR' => '英语（瑙鲁）',
        'en-NU' => '英语（纽埃）',
        'en-NZ' => '英语（新西兰）',
        'en-PG' => '英语（巴布亚新几内亚）',
        'en-PH' => '英语（菲律宾）',
        'en-PK' => '英语（巴基斯坦）',
        'en-PN' => '英语（皮特凯恩群岛）',
        'en-PR' => '英语（波多黎各）',
        'en-PW' => '英语（帕劳）',
        'en-RW' => '英语（卢旺达）',
        'en-SB' => '英语（所罗门群岛）',
        'en-SC' => '英语（塞舌尔）',
        'en-SD' => '英语（苏丹）',
        'en-SE' => '英语（瑞典）',
        'en-SG' => '英语（新加坡）',
        'en-SH' => '英语（圣赫勒拿）',
        'en-SI' => '英语（斯洛文尼亚）',
        'en-SL' => '英语（塞拉利昂）',
        'en-SS' => '英语（南苏丹）',
        'en-SX' => '英语（荷属圣马丁）',
        'en-SZ' => '英语（斯威士兰）',
        'en-TC' => '英语（特克斯和凯科斯群岛）',
        'en-TK' => '英语（托克劳）',
        'en-TO' => '英语（汤加）',
        'en-TT' => '英语（特立尼达和多巴哥）',
        'en-TV' => '英语（图瓦卢）',
        'en-TZ' => '英语（坦桑尼亚）',
        'en-UG' => '英语（乌干达）',
        'en-UM' => '英语（美国本土外小岛屿）',
        'en-US' => '英语（美国）',
        'en-US-POSIX' => '英语（美国，电脑）',
        'en-VC' => '英语（圣文森特和格林纳丁斯）',
        'en-VG' => '英语（英属维尔京群岛）',
        'en-VI' => '英语（美属维尔京群岛）',
        'en-VU' => '英语（瓦努阿图）',
        'en-WS' => '英语（萨摩亚）',
        'en-ZA' => '英语（南非）',
        'en-ZM' => '英语（赞比亚）',
        'en-ZW' => '英语（津巴布韦）',
        'eo' => '世界语',
        'eo-001' => '世界语（世界）',
        'es' => '西班牙语',
        'es-419' => '西班牙语（拉丁美洲）',
        'es-AR' => '西班牙语（阿根廷）',
        'es-BO' => '西班牙语（玻利维亚）',
        'es-BR' => '西班牙语（巴西）',
        'es-BZ' => '西班牙语（伯利兹）',
        'es-CL' => '西班牙语（智利）',
        'es-CO' => '西班牙语（哥伦比亚）',
        'es-CR' => '西班牙语（哥斯达黎加）',
        'es-CU' => '西班牙语（古巴）',
        'es-DO' => '西班牙语（多米尼加共和国）',
        'es-EA' => '西班牙语（休达及梅利利亚）',
        'es-EC' => '西班牙语（厄瓜多尔）',
        'es-ES' => '西班牙语（西班牙）',
        'es-GQ' => '西班牙语（赤道几内亚）',
        'es-GT' => '西班牙语（危地马拉）',
        'es-HN' => '西班牙语（洪都拉斯）',
        'es-IC' => '西班牙语（加纳利群岛）',
        'es-MX' => '西班牙语（墨西哥）',
        'es-NI' => '西班牙语（尼加拉瓜）',
        'es-PA' => '西班牙语（巴拿马）',
        'es-PE' => '西班牙语（秘鲁）',
        'es-PH' => '西班牙语（菲律宾）',
        'es-PR' => '西班牙语（波多黎各）',
        'es-PY' => '西班牙语（巴拉圭）',
        'es-SV' => '西班牙语（萨尔瓦多）',
        'es-US' => '西班牙语（美国）',
        'es-UY' => '西班牙语（乌拉圭）',
        'es-VE' => '西班牙语（委内瑞拉）',
        'et' => '爱沙尼亚语',
        'et-EE' => '爱沙尼亚语（爱沙尼亚）',
        'eu' => '巴斯克语',
        'eu-ES' => '巴斯克语（西班牙）',
        'ewo' => '旺杜语',
        'ewo-CM' => '旺杜语（喀麦隆）',
        'fa' => '波斯语',
        'fa-AF' => '波斯语（阿富汗）',
        'fa-IR' => '波斯语（伊朗）',
        'ff' => '富拉语',
        'ff-Latn' => '富拉语（拉丁文）',
        'ff-Latn-BF' => '富拉语（拉丁文，布基纳法索）',
        'ff-Latn-CM' => '富拉语（拉丁文，喀麦隆）',
        'ff-Latn-GH' => '富拉语（拉丁文，加纳）',
        'ff-Latn-GM' => '富拉语（拉丁文，冈比亚）',
        'ff-Latn-GN' => '富拉语（拉丁文，几内亚）',
        'ff-Latn-GW' => '富拉语（拉丁文，几内亚比绍）',
        'ff-Latn-LR' => '富拉语（拉丁文，利比里亚）',
        'ff-Latn-MR' => '富拉语（拉丁文，毛里塔尼亚）',
        'ff-Latn-NE' => '富拉语（拉丁文，尼日尔）',
        'ff-Latn-NG' => '富拉语（拉丁文，尼日利亚）',
        'ff-Latn-SL' => '富拉语（拉丁文，塞拉利昂）',
        'ff-Latn-SN' => '富拉语（拉丁文，塞内加尔）',
        'fi' => '芬兰语',
        'fi-FI' => '芬兰语（芬兰）',
        'fil' => '菲律宾语',
        'fil-PH' => '菲律宾语（菲律宾）',
        'fo' => '法罗语',
        'fo-DK' => '法罗语（丹麦）',
        'fo-FO' => '法罗语（法罗群岛）',
        'fr' => '法语',
        'fr-BE' => '法语（比利时）',
        'fr-BF' => '法语（布基纳法索）',
        'fr-BI' => '法语（布隆迪）',
        'fr-BJ' => '法语（贝宁）',
        'fr-BL' => '法语（圣巴泰勒米）',
        'fr-CA' => '法语（加拿大）',
        'fr-CD' => '法语（刚果［金］）',
        'fr-CF' => '法语（中非共和国）',
        'fr-CG' => '法语（刚果［布］）',
        'fr-CH' => '法语（瑞士）',
        'fr-CI' => '法语（科特迪瓦）',
        'fr-CM' => '法语（喀麦隆）',
        'fr-DJ' => '法语（吉布提）',
        'fr-DZ' => '法语（阿尔及利亚）',
        'fr-FR' => '法语（法国）',
        'fr-GA' => '法语（加蓬）',
        'fr-GF' => '法语（法属圭亚那）',
        'fr-GN' => '法语（几内亚）',
        'fr-GP' => '法语（瓜德罗普）',
        'fr-GQ' => '法语（赤道几内亚）',
        'fr-HT' => '法语（海地）',
        'fr-KM' => '法语（科摩罗）',
        'fr-LU' => '法语（卢森堡）',
        'fr-MA' => '法语（摩洛哥）',
        'fr-MC' => '法语（摩纳哥）',
        'fr-MF' => '法语（法属圣马丁）',
        'fr-MG' => '法语（马达加斯加）',
        'fr-ML' => '法语（马里）',
        'fr-MQ' => '法语（马提尼克）',
        'fr-MR' => '法语（毛里塔尼亚）',
        'fr-MU' => '法语（毛里求斯）',
        'fr-NC' => '法语（新喀里多尼亚）',
        'fr-NE' => '法语（尼日尔）',
        'fr-PF' => '法语（法属波利尼西亚）',
        'fr-PM' => '法语（圣皮埃尔和密克隆群岛）',
        'fr-RE' => '法语（留尼汪）',
        'fr-RW' => '法语（卢旺达）',
        'fr-SC' => '法语（塞舌尔）',
        'fr-SN' => '法语（塞内加尔）',
        'fr-SY' => '法语（叙利亚）',
        'fr-TD' => '法语（乍得）',
        'fr-TG' => '法语（多哥）',
        'fr-TN' => '法语（突尼斯）',
        'fr-VU' => '法语（瓦努阿图）',
        'fr-WF' => '法语（瓦利斯和富图纳）',
        'fr-YT' => '法语（马约特）',
        'fur' => '弗留利语',
        'fur-IT' => '弗留利语（意大利）',
        'fy' => '西弗里西亚语',
        'fy-NL' => '西弗里西亚语（荷兰）',
        'ga' => '爱尔兰语',
        'ga-IE' => '爱尔兰语（爱尔兰）',
        'gd' => '苏格兰盖尔语',
        'gd-GB' => '苏格兰盖尔语（英国）',
        'gl' => '加利西亚语',
        'gl-ES' => '加利西亚语（西班牙）',
        'gsw' => '瑞士德语',
        'gsw-CH' => '瑞士德语（瑞士）',
        'gsw-FR' => '瑞士德语（法国）',
        'gsw-LI' => '瑞士德语（列支敦士登）',
        'gu' => '古吉拉特语',
        'gu-IN' => '古吉拉特语（印度）',
        'guz' => '古西语',
        'guz-KE' => '古西语（肯尼亚）',
        'gv' => '马恩语',
        'gv-IM' => '马恩语（马恩岛）',
        'ha' => '豪萨语',
        'ha-GH' => '豪萨语（加纳）',
        'ha-NE' => '豪萨语（尼日尔）',
        'ha-NG' => '豪萨语（尼日利亚）',
        'haw' => '夏威夷语',
        'haw-US' => '夏威夷语（美国）',
        'he' => '希伯来语',
        'he-IL' => '希伯来语（以色列）',
        'hi' => '印地语',
        'hi-IN' => '印地语（印度）',
        'hr' => '克罗地亚语',
        'hr-BA' => '克罗地亚语（波斯尼亚和黑塞哥维那）',
        'hr-HR' => '克罗地亚语（克罗地亚）',
        'hsb' => '上索布语',
        'hsb-DE' => '上索布语（德国）',
        'hu' => '匈牙利语',
        'hu-HU' => '匈牙利语（匈牙利）',
        'hy' => '亚美尼亚语',
        'hy-AM' => '亚美尼亚语（亚美尼亚）',
        'ia' => '国际语',
        'ia-001' => '国际语（世界）',
        'id' => '印度尼西亚语',
        'id-ID' => '印度尼西亚语（印度尼西亚）',
        'ig' => '伊博语',
        'ig-NG' => '伊博语（尼日利亚）',
        'ii' => '四川彝语',
        'ii-CN' => '四川彝语（中国）',
        'is' => '冰岛语',
        'is-IS' => '冰岛语（冰岛）',
        'it' => '意大利语',
        'it-CH' => '意大利语（瑞士）',
        'it-IT' => '意大利语（意大利）',
        'it-SM' => '意大利语（圣马力诺）',
        'it-VA' => '意大利语（梵蒂冈）',
        'ja' => '日语',
        'ja-JP' => '日语（日本）',
        'jgo' => '恩艮巴语',
        'jgo-CM' => '恩艮巴语（喀麦隆）',
        'jmc' => '马切姆语',
        'jmc-TZ' => '马切姆语（坦桑尼亚）',
        'jv' => '爪哇语',
        'jv-ID' => '爪哇语（印度尼西亚）',
        'ka' => '格鲁吉亚语',
        'ka-GE' => '格鲁吉亚语（格鲁吉亚）',
        'kab' => '卡拜尔语',
        'kab-DZ' => '卡拜尔语（阿尔及利亚）',
        'kam' => '卡姆巴语',
        'kam-KE' => '卡姆巴语（肯尼亚）',
        'kde' => '马孔德语',
        'kde-TZ' => '马孔德语（坦桑尼亚）',
        'kea' => '卡布佛得鲁语',
        'kea-CV' => '卡布佛得鲁语（佛得角）',
        'khq' => '西桑海语',
        'khq-ML' => '西桑海语（马里）',
        'ki' => '吉库尤语',
        'ki-KE' => '吉库尤语（肯尼亚）',
        'kk' => '哈萨克语',
        'kk-KZ' => '哈萨克语（哈萨克斯坦）',
        'kkj' => '卡库语',
        'kkj-CM' => '卡库语（喀麦隆）',
        'kl' => '格陵兰语',
        'kl-GL' => '格陵兰语（格陵兰）',
        'kln' => '卡伦金语',
        'kln-KE' => '卡伦金语（肯尼亚）',
        'km' => '高棉语',
        'km-KH' => '高棉语（柬埔寨）',
        'kn' => '卡纳达语',
        'kn-IN' => '卡纳达语（印度）',
        'ko' => '韩语',
        'ko-KP' => '韩语（朝鲜）',
        'ko-KR' => '韩语（韩国）',
        'kok' => '孔卡尼语',
        'kok-IN' => '孔卡尼语（印度）',
        'ks' => '克什米尔语',
        'ks-IN' => '克什米尔语（印度）',
        'ksb' => '香巴拉语',
        'ksb-TZ' => '香巴拉语（坦桑尼亚）',
        'ksf' => '巴菲亚语',
        'ksf-CM' => '巴菲亚语（喀麦隆）',
        'ksh' => '科隆语',
        'ksh-DE' => '科隆语（德国）',
        'ku' => '库尔德语',
        'ku-TR' => '库尔德语（土耳其）',
        'kw' => '康沃尔语',
        'kw-GB' => '康沃尔语（英国）',
        'ky' => '柯尔克孜语',
        'ky-KG' => '柯尔克孜语（吉尔吉斯斯坦）',
        'lag' => '朗吉语',
        'lag-TZ' => '朗吉语（坦桑尼亚）',
        'lb' => '卢森堡语',
        'lb-LU' => '卢森堡语（卢森堡）',
        'lg' => '卢干达语',
        'lg-UG' => '卢干达语（乌干达）',
        'lkt' => '拉科塔语',
        'lkt-US' => '拉科塔语（美国）',
        'ln' => '林加拉语',
        'ln-AO' => '林加拉语（安哥拉）',
        'ln-CD' => '林加拉语（刚果［金］）',
        'ln-CF' => '林加拉语（中非共和国）',
        'ln-CG' => '林加拉语（刚果［布］）',
        'lo' => '老挝语',
        'lo-LA' => '老挝语（老挝）',
        'lrc' => '北卢尔语',
        'lrc-IQ' => '北卢尔语（伊拉克）',
        'lrc-IR' => '北卢尔语（伊朗）',
        'lt' => '立陶宛语',
        'lt-LT' => '立陶宛语（立陶宛）',
        'lu' => '鲁巴加丹加语',
        'lu-CD' => '鲁巴加丹加语（刚果［金］）',
        'luo' => '卢奥语',
        'luo-KE' => '卢奥语（肯尼亚）',
        'luy' => '卢雅语',
        'luy-KE' => '卢雅语（肯尼亚）',
        'lv' => '拉脱维亚语',
        'lv-LV' => '拉脱维亚语（拉脱维亚）',
        'mas' => '马赛语',
        'mas-KE' => '马赛语（肯尼亚）',
        'mas-TZ' => '马赛语（坦桑尼亚）',
        'mer' => '梅鲁语',
        'mer-KE' => '梅鲁语（肯尼亚）',
        'mfe' => '毛里求斯克里奥尔语',
        'mfe-MU' => '毛里求斯克里奥尔语（毛里求斯）',
        'mg' => '马拉加斯语',
        'mg-MG' => '马拉加斯语（马达加斯加）',
        'mgh' => '马库阿语',
        'mgh-MZ' => '马库阿语（莫桑比克）',
        'mgo' => '梅塔语',
        'mgo-CM' => '梅塔语（喀麦隆）',
        'mi' => '毛利语',
        'mi-NZ' => '毛利语（新西兰）',
        'mk' => '马其顿语',
        'mk-MK' => '马其顿语（北马其顿）',
        'ml' => '马拉雅拉姆语',
        'ml-IN' => '马拉雅拉姆语（印度）',
        'mn' => '蒙古语',
        'mn-MN' => '蒙古语（蒙古）',
        'mr' => '马拉地语',
        'mr-IN' => '马拉地语（印度）',
        'ms' => '马来语',
        'ms-BN' => '马来语（文莱）',
        'ms-MY' => '马来语（马来西亚）',
        'ms-SG' => '马来语（新加坡）',
        'mt' => '马耳他语',
        'mt-MT' => '马耳他语（马耳他）',
        'mua' => '蒙当语',
        'mua-CM' => '蒙当语（喀麦隆）',
        'my' => '缅甸语',
        'my-MM' => '缅甸语（缅甸）',
        'mzn' => '马赞德兰语',
        'mzn-IR' => '马赞德兰语（伊朗）',
        'naq' => '纳马语',
        'naq-NA' => '纳马语（纳米比亚）',
        'nb' => '书面挪威语',
        'nb-NO' => '书面挪威语（挪威）',
        'nb-SJ' => '书面挪威语（斯瓦尔巴和扬马延）',
        'nd' => '北恩德贝勒语',
        'nd-ZW' => '北恩德贝勒语（津巴布韦）',
        'nds' => '低地德语',
        'nds-DE' => '低地德语（德国）',
        'nds-NL' => '低地德语（荷兰）',
        'ne' => '尼泊尔语',
        'ne-IN' => '尼泊尔语（印度）',
        'ne-NP' => '尼泊尔语（尼泊尔）',
        'nl' => '荷兰语',
        'nl-AW' => '荷兰语（阿鲁巴）',
        'nl-BE' => '荷兰语（比利时）',
        'nl-BQ' => '荷兰语（荷属加勒比区）',
        'nl-CW' => '荷兰语（库拉索）',
        'nl-NL' => '荷兰语（荷兰）',
        'nl-SR' => '荷兰语（苏里南）',
        'nl-SX' => '荷兰语（荷属圣马丁）',
        'nmg' => '夸西奥语',
        'nmg-CM' => '夸西奥语（喀麦隆）',
        'nn' => '挪威尼诺斯克语',
        'nn-NO' => '挪威尼诺斯克语（挪威）',
        'nnh' => '恩甘澎语',
        'nnh-CM' => '恩甘澎语（喀麦隆）',
        'nus' => '努埃尔语',
        'nus-SS' => '努埃尔语（南苏丹）',
        'nyn' => '尼昂科勒语',
        'nyn-UG' => '尼昂科勒语（乌干达）',
        'om' => '奥罗莫语',
        'om-ET' => '奥罗莫语（埃塞俄比亚）',
        'om-KE' => '奥罗莫语（肯尼亚）',
        'or' => '奥里亚语',
        'or-IN' => '奥里亚语（印度）',
        'os' => '奥塞梯语',
        'os-GE' => '奥塞梯语（格鲁吉亚）',
        'os-RU' => '奥塞梯语（俄罗斯）',
        'pa' => '旁遮普语',
        'pa-Arab' => '旁遮普语（阿拉伯文）',
        'pa-Arab-PK' => '旁遮普语（阿拉伯文，巴基斯坦）',
        'pa-Guru' => '旁遮普语（果鲁穆奇文）',
        'pa-Guru-IN' => '旁遮普语（果鲁穆奇文，印度）',
        'pl' => '波兰语',
        'pl-PL' => '波兰语（波兰）',
        'ps' => '普什图语',
        'ps-AF' => '普什图语（阿富汗）',
        'ps-PK' => '普什图语（巴基斯坦）',
        'pt' => '葡萄牙语',
        'pt-AO' => '葡萄牙语（安哥拉）',
        'pt-BR' => '葡萄牙语（巴西）',
        'pt-CH' => '葡萄牙语（瑞士）',
        'pt-CV' => '葡萄牙语（佛得角）',
        'pt-GQ' => '葡萄牙语（赤道几内亚）',
        'pt-GW' => '葡萄牙语（几内亚比绍）',
        'pt-LU' => '葡萄牙语（卢森堡）',
        'pt-MO' => '葡萄牙语（中国澳门特别行政区）',
        'pt-MZ' => '葡萄牙语（莫桑比克）',
        'pt-PT' => '葡萄牙语（葡萄牙）',
        'pt-ST' => '葡萄牙语（圣多美和普林西比）',
        'pt-TL' => '葡萄牙语（东帝汶）',
        'qu' => '克丘亚语',
        'qu-BO' => '克丘亚语（玻利维亚）',
        'qu-EC' => '克丘亚语（厄瓜多尔）',
        'qu-PE' => '克丘亚语（秘鲁）',
        'rm' => '罗曼什语',
        'rm-CH' => '罗曼什语（瑞士）',
        'rn' => '隆迪语',
        'rn-BI' => '隆迪语（布隆迪）',
        'ro' => '罗马尼亚语',
        'ro-MD' => '罗马尼亚语（摩尔多瓦）',
        'ro-RO' => '罗马尼亚语（罗马尼亚）',
        'rof' => '兰博语',
        'rof-TZ' => '兰博语（坦桑尼亚）',
        'ru' => '俄语',
        'ru-BY' => '俄语（白俄罗斯）',
        'ru-KG' => '俄语（吉尔吉斯斯坦）',
        'ru-KZ' => '俄语（哈萨克斯坦）',
        'ru-MD' => '俄语（摩尔多瓦）',
        'ru-RU' => '俄语（俄罗斯）',
        'ru-UA' => '俄语（乌克兰）',
        'rw' => '卢旺达语',
        'rw-RW' => '卢旺达语（卢旺达）',
        'rwk' => '罗瓦语',
        'rwk-TZ' => '罗瓦语（坦桑尼亚）',
        'sah' => '萨哈语',
        'sah-RU' => '萨哈语（俄罗斯）',
        'saq' => '桑布鲁语',
        'saq-KE' => '桑布鲁语（肯尼亚）',
        'sbp' => '桑古语',
        'sbp-TZ' => '桑古语（坦桑尼亚）',
        'sd' => '信德语',
        'sd-PK' => '信德语（巴基斯坦）',
        'se' => '北方萨米语',
        'se-FI' => '北方萨米语（芬兰）',
        'se-NO' => '北方萨米语（挪威）',
        'se-SE' => '北方萨米语（瑞典）',
        'seh' => '塞纳语',
        'seh-MZ' => '塞纳语（莫桑比克）',
        'ses' => '东桑海语',
        'ses-ML' => '东桑海语（马里）',
        'sg' => '桑戈语',
        'sg-CF' => '桑戈语（中非共和国）',
        'shi' => '希尔哈语',
        'shi-Latn' => '希尔哈语（拉丁文）',
        'shi-Latn-MA' => '希尔哈语（拉丁文，摩洛哥）',
        'shi-Tfng' => '希尔哈语（提非纳文）',
        'shi-Tfng-MA' => '希尔哈语（提非纳文，摩洛哥）',
        'si' => '僧伽罗语',
        'si-LK' => '僧伽罗语（斯里兰卡）',
        'sk' => '斯洛伐克语',
        'sk-SK' => '斯洛伐克语（斯洛伐克）',
        'sl' => '斯洛文尼亚语',
        'sl-SI' => '斯洛文尼亚语（斯洛文尼亚）',
        'smn' => '伊纳里萨米语',
        'smn-FI' => '伊纳里萨米语（芬兰）',
        'sn' => '绍纳语',
        'sn-ZW' => '绍纳语（津巴布韦）',
        'so' => '索马里语',
        'so-DJ' => '索马里语（吉布提）',
        'so-ET' => '索马里语（埃塞俄比亚）',
        'so-KE' => '索马里语（肯尼亚）',
        'so-SO' => '索马里语（索马里）',
        'sq' => '阿尔巴尼亚语',
        'sq-AL' => '阿尔巴尼亚语（阿尔巴尼亚）',
        'sq-MK' => '阿尔巴尼亚语（北马其顿）',
        'sq-XK' => '阿尔巴尼亚语（科索沃）',
        'sr' => '塞尔维亚语',
        'sr-Cyrl' => '塞尔维亚语（西里尔文）',
        'sr-Cyrl-BA' => '塞尔维亚语（西里尔文，波斯尼亚和黑塞哥维那）',
        'sr-Cyrl-ME' => '塞尔维亚语（西里尔文，黑山）',
        'sr-Cyrl-RS' => '塞尔维亚语（西里尔文，塞尔维亚）',
        'sr-Cyrl-XK' => '塞尔维亚语（西里尔文，科索沃）',
        'sr-Latn' => '塞尔维亚语（拉丁文）',
        'sr-Latn-BA' => '塞尔维亚语（拉丁文，波斯尼亚和黑塞哥维那）',
        'sr-Latn-ME' => '塞尔维亚语（拉丁文，黑山）',
        'sr-Latn-RS' => '塞尔维亚语（拉丁文，塞尔维亚）',
        'sr-Latn-XK' => '塞尔维亚语（拉丁文，科索沃）',
        'sv' => '瑞典语',
        'sv-AX' => '瑞典语（奥兰群岛）',
        'sv-FI' => '瑞典语（芬兰）',
        'sv-SE' => '瑞典语（瑞典）',
        'sw' => '斯瓦希里语',
        'sw-CD' => '斯瓦希里语（刚果［金］）',
        'sw-KE' => '斯瓦希里语（肯尼亚）',
        'sw-TZ' => '斯瓦希里语（坦桑尼亚）',
        'sw-UG' => '斯瓦希里语（乌干达）',
        'ta' => '泰米尔语',
        'ta-IN' => '泰米尔语（印度）',
        'ta-LK' => '泰米尔语（斯里兰卡）',
        'ta-MY' => '泰米尔语（马来西亚）',
        'ta-SG' => '泰米尔语（新加坡）',
        'te' => '泰卢固语',
        'te-IN' => '泰卢固语（印度）',
        'teo' => '特索语',
        'teo-KE' => '特索语（肯尼亚）',
        'teo-UG' => '特索语（乌干达）',
        'tg' => '塔吉克语',
        'tg-TJ' => '塔吉克语（塔吉克斯坦）',
        'th' => '泰语',
        'th-TH' => '泰语（泰国）',
        'ti' => '提格利尼亚语',
        'ti-ER' => '提格利尼亚语（厄立特里亚）',
        'ti-ET' => '提格利尼亚语（埃塞俄比亚）',
        'tk' => '土库曼语',
        'tk-TM' => '土库曼语（土库曼斯坦）',
        'to' => '汤加语',
        'to-TO' => '汤加语（汤加）',
        'tr' => '土耳其语',
        'tr-CY' => '土耳其语（塞浦路斯）',
        'tr-TR' => '土耳其语（土耳其）',
        'tt' => '鞑靼语',
        'tt-RU' => '鞑靼语（俄罗斯）',
        'twq' => '北桑海语',
        'twq-NE' => '北桑海语（尼日尔）',
        'tzm' => '塔马齐格特语',
        'tzm-MA' => '塔马齐格特语（摩洛哥）',
        'ug' => '维吾尔语',
        'ug-CN' => '维吾尔语（中国）',
        'uk' => '乌克兰语',
        'uk-UA' => '乌克兰语（乌克兰）',
        'ur' => '乌尔都语',
        'ur-IN' => '乌尔都语（印度）',
        'ur-PK' => '乌尔都语（巴基斯坦）',
        'uz' => '乌兹别克语',
        'uz-Arab' => '乌兹别克语（阿拉伯文）',
        'uz-Arab-AF' => '乌兹别克语（阿拉伯文，阿富汗）',
        'uz-Cyrl' => '乌兹别克语（西里尔文）',
        'uz-Cyrl-UZ' => '乌兹别克语（西里尔文，乌兹别克斯坦）',
        'uz-Latn' => '乌兹别克语（拉丁文）',
        'uz-Latn-UZ' => '乌兹别克语（拉丁文，乌兹别克斯坦）',
        'vai' => '瓦伊语',
        'vai-Latn' => '瓦伊语（拉丁文）',
        'vai-Latn-LR' => '瓦伊语（拉丁文，利比里亚）',
        'vai-Vaii' => '瓦伊语（瓦依文）',
        'vai-Vaii-LR' => '瓦伊语（瓦依文，利比里亚）',
        'vi' => '越南语',
        'vi-VN' => '越南语（越南）',
        'vun' => '温旧语',
        'vun-TZ' => '温旧语（坦桑尼亚）',
        'wae' => '瓦尔瑟语',
        'wae-CH' => '瓦尔瑟语（瑞士）',
        'wo' => '沃洛夫语',
        'wo-SN' => '沃洛夫语（塞内加尔）',
        'xh' => '科萨语',
        'xh-ZA' => '科萨语（南非）',
        'xog' => '索加语',
        'xog-UG' => '索加语（乌干达）',
        'yav' => '洋卞语',
        'yav-CM' => '洋卞语（喀麦隆）',
        'yi' => '意第绪语',
        'yi-001' => '意第绪语（世界）',
        'yo' => '约鲁巴语',
        'yo-BJ' => '约鲁巴语（贝宁）',
        'yo-NG' => '约鲁巴语（尼日利亚）',
        'yue' => '粤语',
        'yue-Hans' => '粤语（简体）',
        'yue-Hans-CN' => '粤语（简体，中国）',
        'yue-Hant' => '粤语（繁体）',
        'yue-Hant-HK' => '粤语（繁体，中国香港特别行政区）',
        'zgh' => '标准摩洛哥塔马塞特语',
        'zgh-MA' => '标准摩洛哥塔马塞特语（摩洛哥）',
        'zh' => '中文',
        'zh-Hans' => '中文（简体）',
        'zh-Hans-CN' => '中文（简体，中国）',
        'zh-Hans-HK' => '中文（简体，中国香港特别行政区）',
        'zh-Hans-MO' => '中文（简体，中国澳门特别行政区）',
        'zh-Hans-SG' => '中文（简体，新加坡）',
        'zh-Hant' => '中文（繁体）',
        'zh-Hant-HK' => '中文（繁体，中国香港特别行政区）',
        'zh-Hant-MO' => '中文（繁体，中国澳门特别行政区）',
        'zh-Hant-TW' => '中文（繁体，台湾）',
        'zu' => '祖鲁语',
        'zu-ZA' => '祖鲁语（南非）',
    ],
];
