<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd.MM.y',
            'time' => 'HH:mm',
            'datetime' => 'd.MM.y HH:mm',
        ],
        'medium' => [
            'date' => 'd MMM y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd MMM y HH:mm:ss',
        ],
        'long' => [
            'date' => 'd MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd MMMM y HH:mm:ss z',
        ],
        'full' => [
            'date' => 'd MMMM y EEEE',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'd MMMM y EEEE HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤#,##0.00',
        'percent' => '%#,##0',
        'scientific' => '#E0',
    ],
    'amName' => 'ÖÖ',
    'pmName' => 'ÖS',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => '.',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '.',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => '¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'O',
            'Ş',
            'M',
            'N',
            'M',
            'H',
            'T',
            'A',
            'E',
            'E',
            'K',
            'A',
        ],
        'medium' => [
            'Oca',
            'Şub',
            'Mar',
            'Nis',
            'May',
            'Haz',
            'Tem',
            'Ağu',
            'Eyl',
            'Eki',
            'Kas',
            'Ara',
        ],
        'full' => [
            'Ocak',
            'Şubat',
            'Mart',
            'Nisan',
            'Mayıs',
            'Haziran',
            'Temmuz',
            'Ağustos',
            'Eylül',
            'Ekim',
            'Kasım',
            'Aralık',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'O',
            'Ş',
            'M',
            'N',
            'M',
            'H',
            'T',
            'A',
            'E',
            'E',
            'K',
            'A',
        ],
        'medium' => [
            'Oca',
            'Şub',
            'Mar',
            'Nis',
            'May',
            'Haz',
            'Tem',
            'Ağu',
            'Eyl',
            'Eki',
            'Kas',
            'Ara',
        ],
        'full' => [
            'Ocak',
            'Şubat',
            'Mart',
            'Nisan',
            'Mayıs',
            'Haziran',
            'Temmuz',
            'Ağustos',
            'Eylül',
            'Ekim',
            'Kasım',
            'Aralık',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'P',
            'P',
            'S',
            'Ç',
            'P',
            'C',
            'C',
        ],
        'short' => [
            'Pa',
            'Pt',
            'Sa',
            'Ça',
            'Pe',
            'Cu',
            'Ct',
        ],
        'medium' => [
            'Paz',
            'Pzt',
            'Sal',
            'Çar',
            'Per',
            'Cum',
            'Cmt',
        ],
        'full' => [
            'Pazar',
            'Pazartesi',
            'Salı',
            'Çarşamba',
            'Perşembe',
            'Cuma',
            'Cumartesi',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'P',
            'P',
            'S',
            'Ç',
            'P',
            'C',
            'C',
        ],
        'short' => [
            'Pa',
            'Pt',
            'Sa',
            'Ça',
            'Pe',
            'Cu',
            'Ct',
        ],
        'medium' => [
            'Paz',
            'Pzt',
            'Sal',
            'Çar',
            'Per',
            'Cum',
            'Cmt',
        ],
        'full' => [
            'Pazar',
            'Pazartesi',
            'Salı',
            'Çarşamba',
            'Perşembe',
            'Cuma',
            'Cumartesi',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'Afrikaanca',
        'af-NA' => 'Afrikaanca (Namibya)',
        'af-ZA' => 'Afrikaanca (Güney Afrika)',
        'agq' => 'Aghem',
        'agq-CM' => 'Aghem (Kamerun)',
        'ak' => 'Akan',
        'ak-GH' => 'Akan (Gana)',
        'am' => 'Amharca',
        'am-ET' => 'Amharca (Etiyopya)',
        'ar' => 'Arapça',
        'ar-001' => 'Arapça (Dünya)',
        'ar-AE' => 'Arapça (Birleşik Arap Emirlikleri)',
        'ar-BH' => 'Arapça (Bahreyn)',
        'ar-DJ' => 'Arapça (Cibuti)',
        'ar-DZ' => 'Arapça (Cezayir)',
        'ar-EG' => 'Arapça (Mısır)',
        'ar-EH' => 'Arapça (Batı Sahra)',
        'ar-ER' => 'Arapça (Eritre)',
        'ar-IL' => 'Arapça (İsrail)',
        'ar-IQ' => 'Arapça (Irak)',
        'ar-JO' => 'Arapça (Ürdün)',
        'ar-KM' => 'Arapça (Komorlar)',
        'ar-KW' => 'Arapça (Kuveyt)',
        'ar-LB' => 'Arapça (Lübnan)',
        'ar-LY' => 'Arapça (Libya)',
        'ar-MA' => 'Arapça (Fas)',
        'ar-MR' => 'Arapça (Moritanya)',
        'ar-OM' => 'Arapça (Umman)',
        'ar-PS' => 'Arapça (Filistin Bölgeleri)',
        'ar-QA' => 'Arapça (Katar)',
        'ar-SA' => 'Arapça (Suudi Arabistan)',
        'ar-SD' => 'Arapça (Sudan)',
        'ar-SO' => 'Arapça (Somali)',
        'ar-SS' => 'Arapça (Güney Sudan)',
        'ar-SY' => 'Arapça (Suriye)',
        'ar-TD' => 'Arapça (Çad)',
        'ar-TN' => 'Arapça (Tunus)',
        'ar-YE' => 'Arapça (Yemen)',
        'as' => 'Assamca',
        'as-IN' => 'Assamca (Hindistan)',
        'asa' => 'Asu',
        'asa-TZ' => 'Asu (Tanzanya)',
        'ast' => 'Asturyasça',
        'ast-ES' => 'Asturyasça (İspanya)',
        'az' => 'Azerice',
        'az-Cyrl' => 'Azerice (Kiril)',
        'az-Cyrl-AZ' => 'Azerice (Kiril, Azerbaycan)',
        'az-Latn' => 'Azerice (Latin)',
        'az-Latn-AZ' => 'Azerice (Latin, Azerbaycan)',
        'bas' => 'Basa Dili',
        'bas-CM' => 'Basa Dili (Kamerun)',
        'be' => 'Belarusça',
        'be-BY' => 'Belarusça (Belarus)',
        'bem' => 'Bemba',
        'bem-ZM' => 'Bemba (Zambiya)',
        'bez' => 'Bena',
        'bez-TZ' => 'Bena (Tanzanya)',
        'bg' => 'Bulgarca',
        'bg-BG' => 'Bulgarca (Bulgaristan)',
        'bm' => 'Bambara',
        'bm-ML' => 'Bambara (Mali)',
        'bn' => 'Bengalce',
        'bn-BD' => 'Bengalce (Bangladeş)',
        'bn-IN' => 'Bengalce (Hindistan)',
        'bo' => 'Tibetçe',
        'bo-CN' => 'Tibetçe (Çin)',
        'bo-IN' => 'Tibetçe (Hindistan)',
        'br' => 'Bretonca',
        'br-FR' => 'Bretonca (Fransa)',
        'brx' => 'Bodo',
        'brx-IN' => 'Bodo (Hindistan)',
        'bs' => 'Boşnakça',
        'bs-Cyrl' => 'Boşnakça (Kiril)',
        'bs-Cyrl-BA' => 'Boşnakça (Kiril, Bosna-Hersek)',
        'bs-Latn' => 'Boşnakça (Latin)',
        'bs-Latn-BA' => 'Boşnakça (Latin, Bosna-Hersek)',
        'ca' => 'Katalanca',
        'ca-AD' => 'Katalanca (Andorra)',
        'ca-ES' => 'Katalanca (İspanya)',
        'ca-FR' => 'Katalanca (Fransa)',
        'ca-IT' => 'Katalanca (İtalya)',
        'ccp' => 'Chakma',
        'ccp-BD' => 'Chakma (Bangladeş)',
        'ccp-IN' => 'Chakma (Hindistan)',
        'ce' => 'Çeçence',
        'ce-RU' => 'Çeçence (Rusya)',
        'ceb' => 'Sebuano dili',
        'ceb-PH' => 'Sebuano dili (Filipinler)',
        'cgg' => 'Kigaca',
        'cgg-UG' => 'Kigaca (Uganda)',
        'chr' => 'Çerokice',
        'chr-US' => 'Çerokice (Amerika Birleşik Devletleri)',
        'ckb' => 'Orta Kürtçe',
        'ckb-IQ' => 'Orta Kürtçe (Irak)',
        'ckb-IR' => 'Orta Kürtçe (İran)',
        'cs' => 'Çekçe',
        'cs-CZ' => 'Çekçe (Çekya)',
        'cy' => 'Galce',
        'cy-GB' => 'Galce (Birleşik Krallık)',
        'da' => 'Danca',
        'da-DK' => 'Danca (Danimarka)',
        'da-GL' => 'Danca (Grönland)',
        'dav' => 'Taita',
        'dav-KE' => 'Taita (Kenya)',
        'de' => 'Almanca',
        'de-AT' => 'Almanca (Avusturya)',
        'de-BE' => 'Almanca (Belçika)',
        'de-CH' => 'Almanca (İsviçre)',
        'de-DE' => 'Almanca (Almanya)',
        'de-IT' => 'Almanca (İtalya)',
        'de-LI' => 'Almanca (Liechtenstein)',
        'de-LU' => 'Almanca (Lüksemburg)',
        'dje' => 'Zarma',
        'dje-NE' => 'Zarma (Nijer)',
        'dsb' => 'Aşağı Sorbça',
        'dsb-DE' => 'Aşağı Sorbça (Almanya)',
        'dua' => 'Duala',
        'dua-CM' => 'Duala (Kamerun)',
        'dyo' => 'Jola-Fonyi',
        'dyo-SN' => 'Jola-Fonyi (Senegal)',
        'dz' => 'Dzongkha',
        'dz-BT' => 'Dzongkha (Butan)',
        'ebu' => 'Embu',
        'ebu-KE' => 'Embu (Kenya)',
        'ee' => 'Ewe',
        'ee-GH' => 'Ewe (Gana)',
        'ee-TG' => 'Ewe (Togo)',
        'el' => 'Yunanca',
        'el-CY' => 'Yunanca (Kıbrıs)',
        'el-GR' => 'Yunanca (Yunanistan)',
        'en' => 'İngilizce',
        'en-001' => 'İngilizce (Dünya)',
        'en-150' => 'İngilizce (Avrupa)',
        'en-AE' => 'İngilizce (Birleşik Arap Emirlikleri)',
        'en-AG' => 'İngilizce (Antigua ve Barbuda)',
        'en-AI' => 'İngilizce (Anguilla)',
        'en-AS' => 'İngilizce (Amerikan Samoası)',
        'en-AT' => 'İngilizce (Avusturya)',
        'en-AU' => 'İngilizce (Avustralya)',
        'en-BB' => 'İngilizce (Barbados)',
        'en-BE' => 'İngilizce (Belçika)',
        'en-BI' => 'İngilizce (Burundi)',
        'en-BM' => 'İngilizce (Bermuda)',
        'en-BS' => 'İngilizce (Bahamalar)',
        'en-BW' => 'İngilizce (Botsvana)',
        'en-BZ' => 'İngilizce (Belize)',
        'en-CA' => 'İngilizce (Kanada)',
        'en-CC' => 'İngilizce (Cocos [Keeling] Adaları)',
        'en-CH' => 'İngilizce (İsviçre)',
        'en-CK' => 'İngilizce (Cook Adaları)',
        'en-CM' => 'İngilizce (Kamerun)',
        'en-CX' => 'İngilizce (Christmas Adası)',
        'en-CY' => 'İngilizce (Kıbrıs)',
        'en-DE' => 'İngilizce (Almanya)',
        'en-DG' => 'İngilizce (Diego Garcia)',
        'en-DK' => 'İngilizce (Danimarka)',
        'en-DM' => 'İngilizce (Dominika)',
        'en-ER' => 'İngilizce (Eritre)',
        'en-FI' => 'İngilizce (Finlandiya)',
        'en-FJ' => 'İngilizce (Fiji)',
        'en-FK' => 'İngilizce (Falkland Adaları)',
        'en-FM' => 'İngilizce (Mikronezya)',
        'en-GB' => 'İngilizce (Birleşik Krallık)',
        'en-GD' => 'İngilizce (Grenada)',
        'en-GG' => 'İngilizce (Guernsey)',
        'en-GH' => 'İngilizce (Gana)',
        'en-GI' => 'İngilizce (Cebelitarık)',
        'en-GM' => 'İngilizce (Gambiya)',
        'en-GU' => 'İngilizce (Guam)',
        'en-GY' => 'İngilizce (Guyana)',
        'en-HK' => 'İngilizce (Çin Hong Kong ÖİB)',
        'en-IE' => 'İngilizce (İrlanda)',
        'en-IL' => 'İngilizce (İsrail)',
        'en-IM' => 'İngilizce (Man Adası)',
        'en-IN' => 'İngilizce (Hindistan)',
        'en-IO' => 'İngilizce (Britanya Hint Okyanusu Toprakları)',
        'en-JE' => 'İngilizce (Jersey)',
        'en-JM' => 'İngilizce (Jamaika)',
        'en-KE' => 'İngilizce (Kenya)',
        'en-KI' => 'İngilizce (Kiribati)',
        'en-KN' => 'İngilizce (Saint Kitts ve Nevis)',
        'en-KY' => 'İngilizce (Cayman Adaları)',
        'en-LC' => 'İngilizce (Saint Lucia)',
        'en-LR' => 'İngilizce (Liberya)',
        'en-LS' => 'İngilizce (Lesotho)',
        'en-MG' => 'İngilizce (Madagaskar)',
        'en-MH' => 'İngilizce (Marshall Adaları)',
        'en-MO' => 'İngilizce (Çin Makao ÖİB)',
        'en-MP' => 'İngilizce (Kuzey Mariana Adaları)',
        'en-MS' => 'İngilizce (Montserrat)',
        'en-MT' => 'İngilizce (Malta)',
        'en-MU' => 'İngilizce (Mauritius)',
        'en-MW' => 'İngilizce (Malavi)',
        'en-MY' => 'İngilizce (Malezya)',
        'en-NA' => 'İngilizce (Namibya)',
        'en-NF' => 'İngilizce (Norfolk Adası)',
        'en-NG' => 'İngilizce (Nijerya)',
        'en-NL' => 'İngilizce (Hollanda)',
        'en-NR' => 'İngilizce (Nauru)',
        'en-NU' => 'İngilizce (Niue)',
        'en-NZ' => 'İngilizce (Yeni Zelanda)',
        'en-PG' => 'İngilizce (Papua Yeni Gine)',
        'en-PH' => 'İngilizce (Filipinler)',
        'en-PK' => 'İngilizce (Pakistan)',
        'en-PN' => 'İngilizce (Pitcairn Adaları)',
        'en-PR' => 'İngilizce (Porto Riko)',
        'en-PW' => 'İngilizce (Palau)',
        'en-RW' => 'İngilizce (Ruanda)',
        'en-SB' => 'İngilizce (Solomon Adaları)',
        'en-SC' => 'İngilizce (Seyşeller)',
        'en-SD' => 'İngilizce (Sudan)',
        'en-SE' => 'İngilizce (İsveç)',
        'en-SG' => 'İngilizce (Singapur)',
        'en-SH' => 'İngilizce (Saint Helena)',
        'en-SI' => 'İngilizce (Slovenya)',
        'en-SL' => 'İngilizce (Sierra Leone)',
        'en-SS' => 'İngilizce (Güney Sudan)',
        'en-SX' => 'İngilizce (Sint Maarten)',
        'en-SZ' => 'İngilizce (Esvatini)',
        'en-TC' => 'İngilizce (Turks ve Caicos Adaları)',
        'en-TK' => 'İngilizce (Tokelau)',
        'en-TO' => 'İngilizce (Tonga)',
        'en-TT' => 'İngilizce (Trinidad ve Tobago)',
        'en-TV' => 'İngilizce (Tuvalu)',
        'en-TZ' => 'İngilizce (Tanzanya)',
        'en-UG' => 'İngilizce (Uganda)',
        'en-UM' => 'İngilizce (ABD Küçük Harici Adaları)',
        'en-US' => 'İngilizce (Amerika Birleşik Devletleri)',
        'en-US-POSIX' => 'İngilizce (Amerika Birleşik Devletleri, Bilgisayar)',
        'en-VC' => 'İngilizce (Saint Vincent ve Grenadinler)',
        'en-VG' => 'İngilizce (Britanya Virjin Adaları)',
        'en-VI' => 'İngilizce (ABD Virjin Adaları)',
        'en-VU' => 'İngilizce (Vanuatu)',
        'en-WS' => 'İngilizce (Samoa)',
        'en-ZA' => 'İngilizce (Güney Afrika)',
        'en-ZM' => 'İngilizce (Zambiya)',
        'en-ZW' => 'İngilizce (Zimbabve)',
        'eo' => 'Esperanto',
        'eo-001' => 'Esperanto (Dünya)',
        'es' => 'İspanyolca',
        'es-419' => 'İspanyolca (Latin Amerika)',
        'es-AR' => 'İspanyolca (Arjantin)',
        'es-BO' => 'İspanyolca (Bolivya)',
        'es-BR' => 'İspanyolca (Brezilya)',
        'es-BZ' => 'İspanyolca (Belize)',
        'es-CL' => 'İspanyolca (Şili)',
        'es-CO' => 'İspanyolca (Kolombiya)',
        'es-CR' => 'İspanyolca (Kosta Rika)',
        'es-CU' => 'İspanyolca (Küba)',
        'es-DO' => 'İspanyolca (Dominik Cumhuriyeti)',
        'es-EA' => 'İspanyolca (Ceuta ve Melilla)',
        'es-EC' => 'İspanyolca (Ekvador)',
        'es-ES' => 'İspanyolca (İspanya)',
        'es-GQ' => 'İspanyolca (Ekvator Ginesi)',
        'es-GT' => 'İspanyolca (Guatemala)',
        'es-HN' => 'İspanyolca (Honduras)',
        'es-IC' => 'İspanyolca (Kanarya Adaları)',
        'es-MX' => 'İspanyolca (Meksika)',
        'es-NI' => 'İspanyolca (Nikaragua)',
        'es-PA' => 'İspanyolca (Panama)',
        'es-PE' => 'İspanyolca (Peru)',
        'es-PH' => 'İspanyolca (Filipinler)',
        'es-PR' => 'İspanyolca (Porto Riko)',
        'es-PY' => 'İspanyolca (Paraguay)',
        'es-SV' => 'İspanyolca (El Salvador)',
        'es-US' => 'İspanyolca (Amerika Birleşik Devletleri)',
        'es-UY' => 'İspanyolca (Uruguay)',
        'es-VE' => 'İspanyolca (Venezuela)',
        'et' => 'Estonca',
        'et-EE' => 'Estonca (Estonya)',
        'eu' => 'Baskça',
        'eu-ES' => 'Baskça (İspanya)',
        'ewo' => 'Ewondo',
        'ewo-CM' => 'Ewondo (Kamerun)',
        'fa' => 'Farsça',
        'fa-AF' => 'Farsça (Afganistan)',
        'fa-IR' => 'Farsça (İran)',
        'ff' => 'Fula dili',
        'ff-Latn' => 'Fula dili (Latin)',
        'ff-Latn-BF' => 'Fula dili (Latin, Burkina Faso)',
        'ff-Latn-CM' => 'Fula dili (Latin, Kamerun)',
        'ff-Latn-GH' => 'Fula dili (Latin, Gana)',
        'ff-Latn-GM' => 'Fula dili (Latin, Gambiya)',
        'ff-Latn-GN' => 'Fula dili (Latin, Gine)',
        'ff-Latn-GW' => 'Fula dili (Latin, Gine-Bissau)',
        'ff-Latn-LR' => 'Fula dili (Latin, Liberya)',
        'ff-Latn-MR' => 'Fula dili (Latin, Moritanya)',
        'ff-Latn-NE' => 'Fula dili (Latin, Nijer)',
        'ff-Latn-NG' => 'Fula dili (Latin, Nijerya)',
        'ff-Latn-SL' => 'Fula dili (Latin, Sierra Leone)',
        'ff-Latn-SN' => 'Fula dili (Latin, Senegal)',
        'fi' => 'Fince',
        'fi-FI' => 'Fince (Finlandiya)',
        'fil' => 'Filipince',
        'fil-PH' => 'Filipince (Filipinler)',
        'fo' => 'Faroe dili',
        'fo-DK' => 'Faroe dili (Danimarka)',
        'fo-FO' => 'Faroe dili (Faroe Adaları)',
        'fr' => 'Fransızca',
        'fr-BE' => 'Fransızca (Belçika)',
        'fr-BF' => 'Fransızca (Burkina Faso)',
        'fr-BI' => 'Fransızca (Burundi)',
        'fr-BJ' => 'Fransızca (Benin)',
        'fr-BL' => 'Fransızca (Saint Barthelemy)',
        'fr-CA' => 'Fransızca (Kanada)',
        'fr-CD' => 'Fransızca (Kongo - Kinşasa)',
        'fr-CF' => 'Fransızca (Orta Afrika Cumhuriyeti)',
        'fr-CG' => 'Fransızca (Kongo - Brazavil)',
        'fr-CH' => 'Fransızca (İsviçre)',
        'fr-CI' => 'Fransızca (Fildişi Sahili)',
        'fr-CM' => 'Fransızca (Kamerun)',
        'fr-DJ' => 'Fransızca (Cibuti)',
        'fr-DZ' => 'Fransızca (Cezayir)',
        'fr-FR' => 'Fransızca (Fransa)',
        'fr-GA' => 'Fransızca (Gabon)',
        'fr-GF' => 'Fransızca (Fransız Guyanası)',
        'fr-GN' => 'Fransızca (Gine)',
        'fr-GP' => 'Fransızca (Guadeloupe)',
        'fr-GQ' => 'Fransızca (Ekvator Ginesi)',
        'fr-HT' => 'Fransızca (Haiti)',
        'fr-KM' => 'Fransızca (Komorlar)',
        'fr-LU' => 'Fransızca (Lüksemburg)',
        'fr-MA' => 'Fransızca (Fas)',
        'fr-MC' => 'Fransızca (Monako)',
        'fr-MF' => 'Fransızca (Saint Martin)',
        'fr-MG' => 'Fransızca (Madagaskar)',
        'fr-ML' => 'Fransızca (Mali)',
        'fr-MQ' => 'Fransızca (Martinik)',
        'fr-MR' => 'Fransızca (Moritanya)',
        'fr-MU' => 'Fransızca (Mauritius)',
        'fr-NC' => 'Fransızca (Yeni Kaledonya)',
        'fr-NE' => 'Fransızca (Nijer)',
        'fr-PF' => 'Fransızca (Fransız Polinezyası)',
        'fr-PM' => 'Fransızca (Saint Pierre ve Miquelon)',
        'fr-RE' => 'Fransızca (Réunion)',
        'fr-RW' => 'Fransızca (Ruanda)',
        'fr-SC' => 'Fransızca (Seyşeller)',
        'fr-SN' => 'Fransızca (Senegal)',
        'fr-SY' => 'Fransızca (Suriye)',
        'fr-TD' => 'Fransızca (Çad)',
        'fr-TG' => 'Fransızca (Togo)',
        'fr-TN' => 'Fransızca (Tunus)',
        'fr-VU' => 'Fransızca (Vanuatu)',
        'fr-WF' => 'Fransızca (Wallis ve Futuna)',
        'fr-YT' => 'Fransızca (Mayotte)',
        'fur' => 'Friuli dili',
        'fur-IT' => 'Friuli dili (İtalya)',
        'fy' => 'Batı Frizcesi',
        'fy-NL' => 'Batı Frizcesi (Hollanda)',
        'ga' => 'İrlandaca',
        'ga-IE' => 'İrlandaca (İrlanda)',
        'gd' => 'İskoç Gaelcesi',
        'gd-GB' => 'İskoç Gaelcesi (Birleşik Krallık)',
        'gl' => 'Galiçyaca',
        'gl-ES' => 'Galiçyaca (İspanya)',
        'gsw' => 'İsviçre Almancası',
        'gsw-CH' => 'İsviçre Almancası (İsviçre)',
        'gsw-FR' => 'İsviçre Almancası (Fransa)',
        'gsw-LI' => 'İsviçre Almancası (Liechtenstein)',
        'gu' => 'Güceratça',
        'gu-IN' => 'Güceratça (Hindistan)',
        'guz' => 'Gusii',
        'guz-KE' => 'Gusii (Kenya)',
        'gv' => 'Man dili',
        'gv-IM' => 'Man dili (Man Adası)',
        'ha' => 'Hausa dili',
        'ha-GH' => 'Hausa dili (Gana)',
        'ha-NE' => 'Hausa dili (Nijer)',
        'ha-NG' => 'Hausa dili (Nijerya)',
        'haw' => 'Hawaii dili',
        'haw-US' => 'Hawaii dili (Amerika Birleşik Devletleri)',
        'he' => 'İbranice',
        'he-IL' => 'İbranice (İsrail)',
        'hi' => 'Hintçe',
        'hi-IN' => 'Hintçe (Hindistan)',
        'hr' => 'Hırvatça',
        'hr-BA' => 'Hırvatça (Bosna-Hersek)',
        'hr-HR' => 'Hırvatça (Hırvatistan)',
        'hsb' => 'Yukarı Sorbça',
        'hsb-DE' => 'Yukarı Sorbça (Almanya)',
        'hu' => 'Macarca',
        'hu-HU' => 'Macarca (Macaristan)',
        'hy' => 'Ermenice',
        'hy-AM' => 'Ermenice (Ermenistan)',
        'ia' => 'Interlingua',
        'ia-001' => 'Interlingua (Dünya)',
        'id' => 'Endonezce',
        'id-ID' => 'Endonezce (Endonezya)',
        'ig' => 'İbo dili',
        'ig-NG' => 'İbo dili (Nijerya)',
        'ii' => 'Sichuan Yi',
        'ii-CN' => 'Sichuan Yi (Çin)',
        'is' => 'İzlandaca',
        'is-IS' => 'İzlandaca (İzlanda)',
        'it' => 'İtalyanca',
        'it-CH' => 'İtalyanca (İsviçre)',
        'it-IT' => 'İtalyanca (İtalya)',
        'it-SM' => 'İtalyanca (San Marino)',
        'it-VA' => 'İtalyanca (Vatikan)',
        'ja' => 'Japonca',
        'ja-JP' => 'Japonca (Japonya)',
        'jgo' => 'Ngomba',
        'jgo-CM' => 'Ngomba (Kamerun)',
        'jmc' => 'Machame',
        'jmc-TZ' => 'Machame (Tanzanya)',
        'jv' => 'Cava Dili',
        'jv-ID' => 'Cava Dili (Endonezya)',
        'ka' => 'Gürcüce',
        'ka-GE' => 'Gürcüce (Gürcistan)',
        'kab' => 'Kabiliyece',
        'kab-DZ' => 'Kabiliyece (Cezayir)',
        'kam' => 'Kamba',
        'kam-KE' => 'Kamba (Kenya)',
        'kde' => 'Makonde',
        'kde-TZ' => 'Makonde (Tanzanya)',
        'kea' => 'Kabuverdianu',
        'kea-CV' => 'Kabuverdianu (Cape Verde)',
        'khq' => 'Koyra Chiini',
        'khq-ML' => 'Koyra Chiini (Mali)',
        'ki' => 'Kikuyu',
        'ki-KE' => 'Kikuyu (Kenya)',
        'kk' => 'Kazakça',
        'kk-KZ' => 'Kazakça (Kazakistan)',
        'kkj' => 'Kako',
        'kkj-CM' => 'Kako (Kamerun)',
        'kl' => 'Grönland dili',
        'kl-GL' => 'Grönland dili (Grönland)',
        'kln' => 'Kalenjin',
        'kln-KE' => 'Kalenjin (Kenya)',
        'km' => 'Khmer dili',
        'km-KH' => 'Khmer dili (Kamboçya)',
        'kn' => 'Kannada dili',
        'kn-IN' => 'Kannada dili (Hindistan)',
        'ko' => 'Korece',
        'ko-KP' => 'Korece (Kuzey Kore)',
        'ko-KR' => 'Korece (Güney Kore)',
        'kok' => 'Konkani dili',
        'kok-IN' => 'Konkani dili (Hindistan)',
        'ks' => 'Keşmir dili',
        'ks-IN' => 'Keşmir dili (Hindistan)',
        'ksb' => 'Shambala',
        'ksb-TZ' => 'Shambala (Tanzanya)',
        'ksf' => 'Bafia',
        'ksf-CM' => 'Bafia (Kamerun)',
        'ksh' => 'Köln lehçesi',
        'ksh-DE' => 'Köln lehçesi (Almanya)',
        'ku' => 'Kürtçe',
        'ku-TR' => 'Kürtçe (Türkiye)',
        'kw' => 'Kernevekçe',
        'kw-GB' => 'Kernevekçe (Birleşik Krallık)',
        'ky' => 'Kırgızca',
        'ky-KG' => 'Kırgızca (Kırgızistan)',
        'lag' => 'Langi',
        'lag-TZ' => 'Langi (Tanzanya)',
        'lb' => 'Lüksemburgca',
        'lb-LU' => 'Lüksemburgca (Lüksemburg)',
        'lg' => 'Ganda',
        'lg-UG' => 'Ganda (Uganda)',
        'lkt' => 'Lakotaca',
        'lkt-US' => 'Lakotaca (Amerika Birleşik Devletleri)',
        'ln' => 'Lingala',
        'ln-AO' => 'Lingala (Angola)',
        'ln-CD' => 'Lingala (Kongo - Kinşasa)',
        'ln-CF' => 'Lingala (Orta Afrika Cumhuriyeti)',
        'ln-CG' => 'Lingala (Kongo - Brazavil)',
        'lo' => 'Lao dili',
        'lo-LA' => 'Lao dili (Laos)',
        'lrc' => 'Kuzey Luri',
        'lrc-IQ' => 'Kuzey Luri (Irak)',
        'lrc-IR' => 'Kuzey Luri (İran)',
        'lt' => 'Litvanca',
        'lt-LT' => 'Litvanca (Litvanya)',
        'lu' => 'Luba-Katanga',
        'lu-CD' => 'Luba-Katanga (Kongo - Kinşasa)',
        'luo' => 'Luo',
        'luo-KE' => 'Luo (Kenya)',
        'luy' => 'Luyia',
        'luy-KE' => 'Luyia (Kenya)',
        'lv' => 'Letonca',
        'lv-LV' => 'Letonca (Letonya)',
        'mas' => 'Masai',
        'mas-KE' => 'Masai (Kenya)',
        'mas-TZ' => 'Masai (Tanzanya)',
        'mer' => 'Meru',
        'mer-KE' => 'Meru (Kenya)',
        'mfe' => 'Morisyen',
        'mfe-MU' => 'Morisyen (Mauritius)',
        'mg' => 'Malgaşça',
        'mg-MG' => 'Malgaşça (Madagaskar)',
        'mgh' => 'Makhuwa-Meetto',
        'mgh-MZ' => 'Makhuwa-Meetto (Mozambik)',
        'mgo' => 'Meta’',
        'mgo-CM' => 'Meta’ (Kamerun)',
        'mi' => 'Maori dili',
        'mi-NZ' => 'Maori dili (Yeni Zelanda)',
        'mk' => 'Makedonca',
        'mk-MK' => 'Makedonca (Kuzey Makedonya)',
        'ml' => 'Malayalam dili',
        'ml-IN' => 'Malayalam dili (Hindistan)',
        'mn' => 'Moğolca',
        'mn-MN' => 'Moğolca (Moğolistan)',
        'mr' => 'Marathi dili',
        'mr-IN' => 'Marathi dili (Hindistan)',
        'ms' => 'Malayca',
        'ms-BN' => 'Malayca (Brunei)',
        'ms-MY' => 'Malayca (Malezya)',
        'ms-SG' => 'Malayca (Singapur)',
        'mt' => 'Maltaca',
        'mt-MT' => 'Maltaca (Malta)',
        'mua' => 'Mundang',
        'mua-CM' => 'Mundang (Kamerun)',
        'my' => 'Birman dili',
        'my-MM' => 'Birman dili (Myanmar [Burma])',
        'mzn' => 'Mazenderanca',
        'mzn-IR' => 'Mazenderanca (İran)',
        'naq' => 'Nama',
        'naq-NA' => 'Nama (Namibya)',
        'nb' => 'Norveççe Bokmål',
        'nb-NO' => 'Norveççe Bokmål (Norveç)',
        'nb-SJ' => 'Norveççe Bokmål (Svalbard ve Jan Mayen)',
        'nd' => 'Kuzey Ndebele',
        'nd-ZW' => 'Kuzey Ndebele (Zimbabve)',
        'nds' => 'Aşağı Almanca',
        'nds-DE' => 'Aşağı Almanca (Almanya)',
        'nds-NL' => 'Aşağı Almanca (Hollanda)',
        'ne' => 'Nepalce',
        'ne-IN' => 'Nepalce (Hindistan)',
        'ne-NP' => 'Nepalce (Nepal)',
        'nl' => 'Felemenkçe',
        'nl-AW' => 'Felemenkçe (Aruba)',
        'nl-BE' => 'Felemenkçe (Belçika)',
        'nl-BQ' => 'Felemenkçe (Karayip Hollandası)',
        'nl-CW' => 'Felemenkçe (Curaçao)',
        'nl-NL' => 'Felemenkçe (Hollanda)',
        'nl-SR' => 'Felemenkçe (Surinam)',
        'nl-SX' => 'Felemenkçe (Sint Maarten)',
        'nmg' => 'Kwasio',
        'nmg-CM' => 'Kwasio (Kamerun)',
        'nn' => 'Norveççe Nynorsk',
        'nn-NO' => 'Norveççe Nynorsk (Norveç)',
        'nnh' => 'Ngiemboon',
        'nnh-CM' => 'Ngiemboon (Kamerun)',
        'nus' => 'Nuer',
        'nus-SS' => 'Nuer (Güney Sudan)',
        'nyn' => 'Nyankole',
        'nyn-UG' => 'Nyankole (Uganda)',
        'om' => 'Oromo dili',
        'om-ET' => 'Oromo dili (Etiyopya)',
        'om-KE' => 'Oromo dili (Kenya)',
        'or' => 'Oriya Dili',
        'or-IN' => 'Oriya Dili (Hindistan)',
        'os' => 'Osetçe',
        'os-GE' => 'Osetçe (Gürcistan)',
        'os-RU' => 'Osetçe (Rusya)',
        'pa' => 'Pencapça',
        'pa-Arab' => 'Pencapça (Arap)',
        'pa-Arab-PK' => 'Pencapça (Arap, Pakistan)',
        'pa-Guru' => 'Pencapça (Gurmukhi)',
        'pa-Guru-IN' => 'Pencapça (Gurmukhi, Hindistan)',
        'pl' => 'Lehçe',
        'pl-PL' => 'Lehçe (Polonya)',
        'ps' => 'Peştuca',
        'ps-AF' => 'Peştuca (Afganistan)',
        'ps-PK' => 'Peştuca (Pakistan)',
        'pt' => 'Portekizce',
        'pt-AO' => 'Portekizce (Angola)',
        'pt-BR' => 'Portekizce (Brezilya)',
        'pt-CH' => 'Portekizce (İsviçre)',
        'pt-CV' => 'Portekizce (Cape Verde)',
        'pt-GQ' => 'Portekizce (Ekvator Ginesi)',
        'pt-GW' => 'Portekizce (Gine-Bissau)',
        'pt-LU' => 'Portekizce (Lüksemburg)',
        'pt-MO' => 'Portekizce (Çin Makao ÖİB)',
        'pt-MZ' => 'Portekizce (Mozambik)',
        'pt-PT' => 'Portekizce (Portekiz)',
        'pt-ST' => 'Portekizce (São Tomé ve Príncipe)',
        'pt-TL' => 'Portekizce (Timor-Leste)',
        'qu' => 'Keçuva dili',
        'qu-BO' => 'Keçuva dili (Bolivya)',
        'qu-EC' => 'Keçuva dili (Ekvador)',
        'qu-PE' => 'Keçuva dili (Peru)',
        'rm' => 'Romanşça',
        'rm-CH' => 'Romanşça (İsviçre)',
        'rn' => 'Kirundi',
        'rn-BI' => 'Kirundi (Burundi)',
        'ro' => 'Rumence',
        'ro-MD' => 'Rumence (Moldova)',
        'ro-RO' => 'Rumence (Romanya)',
        'rof' => 'Rombo',
        'rof-TZ' => 'Rombo (Tanzanya)',
        'ru' => 'Rusça',
        'ru-BY' => 'Rusça (Belarus)',
        'ru-KG' => 'Rusça (Kırgızistan)',
        'ru-KZ' => 'Rusça (Kazakistan)',
        'ru-MD' => 'Rusça (Moldova)',
        'ru-RU' => 'Rusça (Rusya)',
        'ru-UA' => 'Rusça (Ukrayna)',
        'rw' => 'Kinyarwanda',
        'rw-RW' => 'Kinyarwanda (Ruanda)',
        'rwk' => 'Rwa',
        'rwk-TZ' => 'Rwa (Tanzanya)',
        'sah' => 'Yakutça',
        'sah-RU' => 'Yakutça (Rusya)',
        'saq' => 'Samburu',
        'saq-KE' => 'Samburu (Kenya)',
        'sbp' => 'Sangu',
        'sbp-TZ' => 'Sangu (Tanzanya)',
        'sd' => 'Sindhi dili',
        'sd-PK' => 'Sindhi dili (Pakistan)',
        'se' => 'Kuzey Laponcası',
        'se-FI' => 'Kuzey Laponcası (Finlandiya)',
        'se-NO' => 'Kuzey Laponcası (Norveç)',
        'se-SE' => 'Kuzey Laponcası (İsveç)',
        'seh' => 'Sena',
        'seh-MZ' => 'Sena (Mozambik)',
        'ses' => 'Koyraboro Senni',
        'ses-ML' => 'Koyraboro Senni (Mali)',
        'sg' => 'Sango',
        'sg-CF' => 'Sango (Orta Afrika Cumhuriyeti)',
        'shi' => 'Taşelhit',
        'shi-Latn' => 'Taşelhit (Latin)',
        'shi-Latn-MA' => 'Taşelhit (Latin, Fas)',
        'shi-Tfng' => 'Taşelhit (Tifinagh)',
        'shi-Tfng-MA' => 'Taşelhit (Tifinagh, Fas)',
        'si' => 'Sinhali dili',
        'si-LK' => 'Sinhali dili (Sri Lanka)',
        'sk' => 'Slovakça',
        'sk-SK' => 'Slovakça (Slovakya)',
        'sl' => 'Slovence',
        'sl-SI' => 'Slovence (Slovenya)',
        'smn' => 'İnari Laponcası',
        'smn-FI' => 'İnari Laponcası (Finlandiya)',
        'sn' => 'Shona',
        'sn-ZW' => 'Shona (Zimbabve)',
        'so' => 'Somalice',
        'so-DJ' => 'Somalice (Cibuti)',
        'so-ET' => 'Somalice (Etiyopya)',
        'so-KE' => 'Somalice (Kenya)',
        'so-SO' => 'Somalice (Somali)',
        'sq' => 'Arnavutça',
        'sq-AL' => 'Arnavutça (Arnavutluk)',
        'sq-MK' => 'Arnavutça (Kuzey Makedonya)',
        'sq-XK' => 'Arnavutça (Kosova)',
        'sr' => 'Sırpça',
        'sr-Cyrl' => 'Sırpça (Kiril)',
        'sr-Cyrl-BA' => 'Sırpça (Kiril, Bosna-Hersek)',
        'sr-Cyrl-ME' => 'Sırpça (Kiril, Karadağ)',
        'sr-Cyrl-RS' => 'Sırpça (Kiril, Sırbistan)',
        'sr-Cyrl-XK' => 'Sırpça (Kiril, Kosova)',
        'sr-Latn' => 'Sırpça (Latin)',
        'sr-Latn-BA' => 'Sırpça (Latin, Bosna-Hersek)',
        'sr-Latn-ME' => 'Sırpça (Latin, Karadağ)',
        'sr-Latn-RS' => 'Sırpça (Latin, Sırbistan)',
        'sr-Latn-XK' => 'Sırpça (Latin, Kosova)',
        'sv' => 'İsveççe',
        'sv-AX' => 'İsveççe (Åland Adaları)',
        'sv-FI' => 'İsveççe (Finlandiya)',
        'sv-SE' => 'İsveççe (İsveç)',
        'sw' => 'Svahili dili',
        'sw-CD' => 'Svahili dili (Kongo - Kinşasa)',
        'sw-KE' => 'Svahili dili (Kenya)',
        'sw-TZ' => 'Svahili dili (Tanzanya)',
        'sw-UG' => 'Svahili dili (Uganda)',
        'ta' => 'Tamilce',
        'ta-IN' => 'Tamilce (Hindistan)',
        'ta-LK' => 'Tamilce (Sri Lanka)',
        'ta-MY' => 'Tamilce (Malezya)',
        'ta-SG' => 'Tamilce (Singapur)',
        'te' => 'Telugu dili',
        'te-IN' => 'Telugu dili (Hindistan)',
        'teo' => 'Teso',
        'teo-KE' => 'Teso (Kenya)',
        'teo-UG' => 'Teso (Uganda)',
        'tg' => 'Tacikçe',
        'tg-TJ' => 'Tacikçe (Tacikistan)',
        'th' => 'Tayca',
        'th-TH' => 'Tayca (Tayland)',
        'ti' => 'Tigrinya dili',
        'ti-ER' => 'Tigrinya dili (Eritre)',
        'ti-ET' => 'Tigrinya dili (Etiyopya)',
        'tk' => 'Türkmence',
        'tk-TM' => 'Türkmence (Türkmenistan)',
        'to' => 'Tonga dili',
        'to-TO' => 'Tonga dili (Tonga)',
        'tr' => 'Türkçe',
        'tr-CY' => 'Türkçe (Kıbrıs)',
        'tr-TR' => 'Türkçe (Türkiye)',
        'tt' => 'Tatarca',
        'tt-RU' => 'Tatarca (Rusya)',
        'twq' => 'Tasawaq',
        'twq-NE' => 'Tasawaq (Nijer)',
        'tzm' => 'Orta Atlas Tamazigti',
        'tzm-MA' => 'Orta Atlas Tamazigti (Fas)',
        'ug' => 'Uygurca',
        'ug-CN' => 'Uygurca (Çin)',
        'uk' => 'Ukraynaca',
        'uk-UA' => 'Ukraynaca (Ukrayna)',
        'ur' => 'Urduca',
        'ur-IN' => 'Urduca (Hindistan)',
        'ur-PK' => 'Urduca (Pakistan)',
        'uz' => 'Özbekçe',
        'uz-Arab' => 'Özbekçe (Arap)',
        'uz-Arab-AF' => 'Özbekçe (Arap, Afganistan)',
        'uz-Cyrl' => 'Özbekçe (Kiril)',
        'uz-Cyrl-UZ' => 'Özbekçe (Kiril, Özbekistan)',
        'uz-Latn' => 'Özbekçe (Latin)',
        'uz-Latn-UZ' => 'Özbekçe (Latin, Özbekistan)',
        'vai' => 'Vai',
        'vai-Latn' => 'Vai (Latin)',
        'vai-Latn-LR' => 'Vai (Latin, Liberya)',
        'vai-Vaii' => 'Vai (Vai)',
        'vai-Vaii-LR' => 'Vai (Vai, Liberya)',
        'vi' => 'Vietnamca',
        'vi-VN' => 'Vietnamca (Vietnam)',
        'vun' => 'Vunjo',
        'vun-TZ' => 'Vunjo (Tanzanya)',
        'wae' => 'Walser',
        'wae-CH' => 'Walser (İsviçre)',
        'wo' => 'Volofça',
        'wo-SN' => 'Volofça (Senegal)',
        'xh' => 'Zosa dili',
        'xh-ZA' => 'Zosa dili (Güney Afrika)',
        'xog' => 'Soga',
        'xog-UG' => 'Soga (Uganda)',
        'yav' => 'Yangben',
        'yav-CM' => 'Yangben (Kamerun)',
        'yi' => 'Yidiş',
        'yi-001' => 'Yidiş (Dünya)',
        'yo' => 'Yorubaca',
        'yo-BJ' => 'Yorubaca (Benin)',
        'yo-NG' => 'Yorubaca (Nijerya)',
        'yue' => 'Kantonca',
        'yue-Hans' => 'Kantonca (Basitleştirilmiş)',
        'yue-Hans-CN' => 'Kantonca (Basitleştirilmiş, Çin)',
        'yue-Hant' => 'Kantonca (Geleneksel)',
        'yue-Hant-HK' => 'Kantonca (Geleneksel, Çin Hong Kong ÖİB)',
        'zgh' => 'Standart Fas Tamazigti',
        'zgh-MA' => 'Standart Fas Tamazigti (Fas)',
        'zh' => 'Çince',
        'zh-Hans' => 'Çince (Basitleştirilmiş)',
        'zh-Hans-CN' => 'Çince (Basitleştirilmiş, Çin)',
        'zh-Hans-HK' => 'Çince (Basitleştirilmiş, Çin Hong Kong ÖİB)',
        'zh-Hans-MO' => 'Çince (Basitleştirilmiş, Çin Makao ÖİB)',
        'zh-Hans-SG' => 'Çince (Basitleştirilmiş, Singapur)',
        'zh-Hant' => 'Çince (Geleneksel)',
        'zh-Hant-HK' => 'Çince (Geleneksel, Çin Hong Kong ÖİB)',
        'zh-Hant-MO' => 'Çince (Geleneksel, Çin Makao ÖİB)',
        'zh-Hant-TW' => 'Çince (Geleneksel, Tayvan)',
        'zu' => 'Zuluca',
        'zu-ZA' => 'Zuluca (Güney Afrika)',
    ],
];
